<?php 

/**
 * Swipper Lib
*/
if(!function_exists('roofex_elements_scripts')){
    add_action( 'wp_enqueue_scripts', 'roofex_elements_scripts');
    function roofex_elements_scripts() {  
        $theme = wp_get_theme( get_template() );
        wp_enqueue_script('roofex-elementor', get_template_directory_uri() . '/elements/widgets/js/elementor.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_enqueue_script('roofex-tilt', get_template_directory_uri() . '/elements/widgets/js/ct-tilt.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        //wp_enqueue_script('roofex-vanillas', get_template_directory_uri() . '/elements/widgets/js/vanilla-tilt.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('roofex-particle', get_template_directory_uri() . '/elements/widgets/js/particle.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('roofex-parallax', get_template_directory_uri() . '/elements/widgets/js/parallax.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('pxl-post-grid', get_template_directory_uri() . '/elements/widgets/js/grid.js', [ 'isotope', 'jquery' ], $theme->get( 'Version' ), true);
        wp_localize_script( 'pxl-post-grid', 'main_data', array( 'ajax_url' => admin_url( 'admin-ajax.php' ) ) );
        wp_enqueue_script('pxl-swiper', get_template_directory_uri() . '/elements/widgets/js/carousel.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('roofex-counter', get_template_directory_uri() . '/elements/widgets/js/counter.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('roofex-accordion', get_template_directory_uri() . '/elements/widgets/js/accordion.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_enqueue_script('roofex-piecharts', get_template_directory_uri() . '/elements/widgets/js/ct-piecharts-widget.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('roofex-tabs', get_template_directory_uri() . '/elements/widgets/js/tabs.js', [ 'jquery' ], $theme->get( 'Version' ), true);
        wp_register_script('roofex-progressbar', get_template_directory_uri() . '/elements/widgets/js/progressbar.js', [ 'jquery' ], $theme->get( 'Version' ), true);
    }
}

/**
 * Extra Elementor Icons
*/
if(!function_exists('roofex_register_custom_icon_library')){
    add_filter('elementor/icons_manager/native', 'roofex_register_custom_icon_library');
    function roofex_register_custom_icon_library($tabs){
        $custom_tabs = [
            'pxl_icon1' => [
                'name' => 'flaticon',
                'label' => esc_html__( 'Roofex', 'roofex' ),
                'url' => false,
                'enqueue' => false,
                'prefix' => 'flaticon-',
                'displayPrefix' => 'flaticon',
                'labelIcon' => 'flaticon-shop-bag',
                'ver' => '1.0.0',
                'fetchJson' => get_template_directory_uri() . '/assets/fonts/flaticon/icons.js',
                'native' => true,
            ],

        ];
        $tabs = array_merge($custom_tabs, $tabs);
        return $tabs;
    }
}

/**
 * Get class widget path
*/
if(!function_exists('roofex_get_class_widget_path')){
    function roofex_get_class_widget_path(){
        $upload_dir = wp_upload_dir();
        $cls_path = $upload_dir['basedir'].'/elementor-widget/';
        if(!is_dir($cls_path)) {
            wp_mkdir_p( $cls_path );
        }
        return $cls_path;
    }
}

/**
 * Get post type options
*/
function roofex_get_post_type_options($pt_supports=[]){
    $post_types = get_post_types([
        'public'   => true,
    ], 'objects');
    $excluded_post_type = [
        'page',
        'attachment',
        'revision',
        'nav_menu_item',
        'custom_css',
        'customize_changeset',
        'oembed_cache',
        'e-landing-page',
        'header',
        'footer',
        'mega-menu',
        'product',
        'elementor_library'
    ];

    $result_some = [];
    $result_any = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $post_type) {
        if (!$post_type instanceof WP_Post_Type)
            continue;
        if (in_array($post_type->name, $excluded_post_type))
            continue;

        if(!empty($pt_supports) && in_array($post_type->name, $pt_supports)){
            $result_some[$post_type->name] = $post_type->labels->singular_name;
        }else{
            $result_any[$post_type->name] = $post_type->labels->singular_name;
        }
    }

    if(!empty($pt_supports))
        return $result_some;
    else   
        return $result_any;
}


/**
 * Start Post Grid Functions
*/
function roofex_get_post_grid_layout($pt_supports = []){
    $post_types  = roofex_get_post_type_options($pt_supports); 
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {
        $result[] = array(
            'name'     => 'layout_'.$name,
            'label'    => sprintf(esc_html__( 'Select Templates of %s', 'roofex' ), $label),
            'type'     => 'layoutcontrol',
            'default' => 'post-1',
            'options'  => roofex_get_grid_layout_options($name),
            'prefix_class' => 'pxl-post-layout-',
            'condition' => [
                'post_type' => [$name]
            ]
        );
    }
    return $result;   
}

function roofex_get_grid_layout_options($posttype_name){
    $option_layouts = [];
    switch ($posttype_name) {
        case 'service':
        $option_layouts = [
            'service-1' => [
                'label' => esc_html__( 'Layout 1', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/service-layout1.jpg'
            ],
            'service-2' => [
                'label' => esc_html__( 'Layout 2', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/service-layout2.jpg'
            ],
            'service-3' => [
                'label' => esc_html__( 'Layout 3', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/service-layout3.jpg'
            ],
            'service-4' => [
                'label' => esc_html__( 'Layout 4', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/service-layout4.jpg'
            ],
            'service-5' => [
                'label' => esc_html__( 'Layout 5', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/service-layout5.jpg'
            ],
            'service-6' => [
                'label' => esc_html__( 'Layout 6', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/service-layout6.jpg'
            ],

        ];
        break;

        case 'portfolio':
        $option_layouts = [
            'portfolio-1' => [
                'label' => esc_html__( 'Layout 1', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout1.jpg'
            ],
            'portfolio-2' => [
                'label' => esc_html__( 'Layout 2', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout2.jpg'
            ],
            'portfolio-3' => [
                'label' => esc_html__( 'Layout 3', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout3.jpg'
            ],
            'portfolio-4' => [
                'label' => esc_html__( 'Layout 4', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout4.jpg'
            ],
            'portfolio-5' => [
                'label' => esc_html__( 'Layout 5', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout5.jpg'
            ],
            'portfolio-6' => [
                'label' => esc_html__( 'Layout 6', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout6.jpg'
            ],
            'portfolio-7' => [
                'label' => esc_html__( 'Layout 7', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout7.jpg'
            ],
            'portfolio-8' => [
                'label' => esc_html__( 'Layout 8', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/portfolio-layout8.jpg'
            ],

        ];
        break;

        case 'post':  
        $option_layouts = [
            'post-1' => [
                'label' => esc_html__( 'Layout 1', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/post-layout1.jpg'
            ],
            'post-2' => [
                'label' => esc_html__( 'Layout 2', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/post-layout2.jpg'
            ], 
            'post-3' => [
                'label' => esc_html__( 'Layout 3', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/post-layout3.jpg'
            ],
            'post-4' => [
                'label' => esc_html__( 'Layout 4', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_grid/layout-image/post-layout4.jpg'
            ],
        ];
        break;
    }
    return $option_layouts;
}

function roofex_get_grid_term_by_posttype($pt_supports = [], $args=[]){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]); 
    $post_types  = roofex_get_post_type_options($pt_supports); 
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $taxonomy = get_object_taxonomies($name, 'names');
        
        if($name == 'post') $taxonomy = ['category'];
        if($name == 'product') $taxonomy = ['product_cat'];

        $result[] = array(
            'name'     => 'source_'.$name,
            'label'    => sprintf(esc_html__( 'Select Term of %s', 'roofex' ), $label),
            'type'     => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'options'  => pxl_get_grid_term_options($name,$taxonomy),
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}

function roofex_get_grid_ids_by_posttype($pt_supports = [], $args = []){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types = roofex_get_post_type_options($pt_supports);
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $posts = roofex_list_post($name, false);

        $result[] = array(
            'name' => 'source_' . $name . '_post_ids',
            'label' => sprintf(esc_html__('Select posts', 'roofex'), $label),
            'type'     => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'options' => $posts,
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}

/**
 * End Post Grid Functions
*/


/**
 * Start Post Carousel Functions
*/
function roofex_get_post_carousel_layout($pt_supports = []){
    $post_types  = roofex_get_post_type_options($pt_supports); 
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {
        $result[] = array(
            'name'     => 'layout_'.$name,
            'label'    => sprintf(esc_html__( 'Select Templates of %s', 'roofex' ), $label),
            'type'     => 'layoutcontrol',
            'default' => 'post-1',
            'options'  => roofex_get_carousel_layout_options($name),
            'prefix_class' => 'post-layout-',
            'condition' => [
                'post_type' => [$name]
            ]
        );
    }
    return $result;   
}

function roofex_get_carousel_layout_options($posttype_name){
    $option_layouts = [];
    switch ($posttype_name) {
        case 'service':
        $option_layouts = [
            'service-1' => [
                'label' => esc_html__( 'Layout 1', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout1.jpg'
            ],
            'service-2' => [
                'label' => esc_html__( 'Layout 2', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout2.jpg'
            ],
            'service-3' => [
                'label' => esc_html__( 'Layout 3', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout3.jpg'
            ],
            'service-4' => [
                'label' => esc_html__( 'Layout 4', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout4.jpg'
            ],
            'service-5' => [
                'label' => esc_html__( 'Layout 5', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout5.jpg'
            ],
            'service-6' => [
                'label' => esc_html__( 'Layout 6', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout6.jpg'
            ],
            'service-7' => [
                'label' => esc_html__( 'Layout 7', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout7.jpg'
            ],
            'service-8' => [
                'label' => esc_html__( 'Layout 8', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout8.jpg'
            ],
            'service-9' => [
                'label' => esc_html__( 'Layout 9', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout9.jpg'
            ],
            'service-10' => [
                'label' => esc_html__( 'Layout 10', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout10.jpg'
            ],
            'service-11' => [
                'label' => esc_html__( 'Layout 11', 'roofex' ),
                'image' => get_template_directory_uri() . '/elements/templates/pxl_post_carousel/layout-image/service-layout11.jpg'
            ]
        ];
        break;
        case 'post':  
        $option_layouts = [
            'post-1' => [
                'label' => esc_html__( 'Layout 1', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/post-layout1.jpg'
            ],
            'post-2' => [
                'label' => esc_html__( 'Layout 2', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/post-layout2.jpg'
            ],
            'post-3' => [
                'label' => esc_html__( 'Layout 3', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/post-layout3.jpg'
            ],
            'post-4' => [
                'label' => esc_html__( 'Layout 4', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/post-layout4.jpg'
            ],
            'post-5' => [
                'label' => esc_html__( 'Layout 5', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/post-layout5.jpg'
            ],
            'post-6' => [
                'label' => esc_html__( 'Layout 6', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/post-layout6.jpg'
            ]
        ];
        break;
        
        case 'portfolio':  
        $option_layouts = [
            'portfolio-1' => [
                'label' => esc_html__( 'Layout 1', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/portfolio-layout1.jpg'
            ],
            'portfolio-2' => [
                'label' => esc_html__( 'Layout 2', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/portfolio-layout2.jpg'
            ],
            'portfolio-3' => [
                'label' => esc_html__( 'Layout 3', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/portfolio-layout3.jpg'
            ],
            'portfolio-4' => [
                'label' => esc_html__( 'Layout 4', 'roofex' ),
                'image' => get_template_directory_uri() . '//elements/templates/pxl_post_carousel/layout-image/portfolio-layout4.jpg'
            ],
        ];
        break;
    }
    return $option_layouts;
}

function roofex_get_carousel_term_by_posttype($pt_supports = [], $args=[]){
    $args = wp_parse_args($args, ['condition' => 'post_type', 'custom_condition' => []]);
    $post_types  = roofex_get_post_type_options($pt_supports); 
    $result = [];
    if (!is_array($post_types))
        return $result;
    foreach ($post_types as $name => $label) {

        $taxonomy = get_object_taxonomies($name, 'names');
        
        if($name == 'post') $taxonomy = ['category'];
        if($name == 'product') $taxonomy = ['product_cat'];

        $result[] = array(
            'name'     => 'source_'.$name,
            'label'    => sprintf(esc_html__( 'Select Term of %s', 'roofex' ), $label),
            'type'     => \Elementor\Controls_Manager::SELECT2,
            'multiple' => true,
            'options'  => pxl_get_grid_term_options($name,$taxonomy),
            'condition' => array_merge(
                [
                    $args['condition'] => [$name]
                ],
                $args['custom_condition']
            )
        );
    }

    return $result;
}
/**
 * End Post Carousel Functions
*/


/* Icon render */ 
function roofex_elementor_icon_render( $settings, $args = []){
    $args = wp_parse_args($args, [
        'prefix'     => '',   
        'id'         => 'selected_icon',
        'loop'       => false,
        'tag'        => 'div',   
        'wrap_class' => '',
        'class'      => '',
        'style'      => '',
        'before'     => '',
        'after'      => '',
        'atts'       => [],
        'animate_data' => '',
        'default_icon'    => [
            'value'   => '',
            'library' => ''
        ],
        'echo' => true
    ]);
    if($args['loop']) {
        $icon = $args['id'];
    } else {
        $icon = $settings[$args['id']];
    }
    if(empty($icon['value'])) $icon = $args['default_icon'];
    if (empty($icon['value'])) return;

    if ( 'svg' === $icon['library'] ){
        $args['before'] = '<span class="'.$args['wrap_class'].' '.$args['class'].'" data-settings="'. esc_attr($args['animate_data']).'">';
        $args['after']  = '</span>';
    }
    ob_start();
    printf('%s', $args['before']);
    ?>
    <?php \Elementor\Icons_Manager::render_icon( $icon, array_merge(
        [ 
            'aria-hidden' => 'true', 
            'class'       => trim(implode(' ', ['pxl-icon', $args['class'], $args['wrap_class']])),
            'style'       => $args['style']  
        ],
        $args['atts']
    ), $args['tag']); ?>
    <?php
    printf('%s', $args['after']);

    if($args['echo']){
        echo ob_get_clean();
    } else {
        return ob_get_clean();
    }
}

/**
 * Animation List
*/

function roofex_widget_animate() {
    $roofex_animate = array(
        '' => 'None',
        'wow bounce' => 'bounce',
        'wow flash' => 'flash',
        'wow pulse' => 'pulse',
        'wow rubberBand' => 'rubberBand',
        'wow shake' => 'shake',
        'wow swing' => 'swing',
        'wow tada' => 'tada',
        'wow wobble' => 'wobble',
        'wow bounceIn' => 'bounceIn',
        'wow bounceInDown' => 'bounceInDown',
        'wow bounceInLeft' => 'bounceInLeft',
        'wow bounceInRight' => 'bounceInRight',
        'wow bounceInUp' => 'bounceInUp',
        'wow bounceOut' => 'bounceOut',
        'wow bounceOutDown' => 'bounceOutDown',
        'wow bounceOutLeft' => 'bounceOutLeft',
        'wow bounceOutRight' => 'bounceOutRight',
        'wow bounceOutUp' => 'bounceOutUp',
        'wow fadeIn' => 'fadeIn',
        'wow fadeInDown' => 'fadeInDown',
        'wow fadeInDownBig' => 'fadeInDownBig',
        'wow fadeInLeft' => 'fadeInLeft',
        'wow fadeInLeftBig' => 'fadeInLeftBig',
        'wow fadeInRight' => 'fadeInRight',
        'wow fadeInRightBig' => 'fadeInRightBig',
        'wow fadeInUp' => 'fadeInUp',
        'wow fadeInUpBig' => 'fadeInUpBig',
        'wow fadeOut' => 'fadeOut',
        'wow fadeOutDown' => 'fadeOutDown',
        'wow fadeOutDownBig' => 'fadeOutDownBig',
        'wow fadeOutLeft' => 'fadeOutLeft',
        'wow fadeOutLeftBig' => 'fadeOutLeftBig',
        'wow fadeOutRight' => 'fadeOutRight',
        'wow fadeOutRightBig' => 'fadeOutRightBig',
        'wow fadeOutUp' => 'fadeOutUp',
        'wow fadeOutUpBig' => 'fadeOutUpBig',
        'wow flip' => 'flip',
        'wow flipInX' => 'flipInX',
        'wow flipInY' => 'flipInY',
        'wow flipOutX' => 'flipOutX',
        'wow flipOutY' => 'flipOutY',
        'wow lightSpeedIn' => 'lightSpeedIn',
        'wow lightSpeedOut' => 'lightSpeedOut',
        'wow rotateIn' => 'rotateIn',
        'wow rotateInDownLeft' => 'rotateInDownLeft',
        'wow rotateInDownRight' => 'rotateInDownRight',
        'wow rotateInUpLeft' => 'rotateInUpLeft',
        'wow rotateInUpRight' => 'rotateInUpRight',
        'wow rotateOut' => 'rotateOut',
        'wow rotateOutDownLeft' => 'rotateOutDownLeft',
        'wow rotateOutDownRight' => 'rotateOutDownRight',
        'wow rotateOutUpLeft' => 'rotateOutUpLeft',
        'wow rotateOutUpRight' => 'rotateOutUpRight',
        'wow hinge' => 'hinge',
        'wow rollIn' => 'rollIn',
        'wow rollOut' => 'rollOut',
        'wow zoomIn' => 'zoomIn',
        'wow zoomInDown' => 'zoomInDown',
        'wow zoomInLeft' => 'zoomInLeft',
        'wow zoomInRight' => 'zoomInRight',
        'wow zoomInUp' => 'zoomInUp',
        'wow zoomOut' => 'zoomOut',
        'wow zoomOutDown' => 'zoomOutDown',
        'wow zoomOutLeft' => 'zoomOutLeft',
        'wow zoomOutRight' => 'zoomOutRight',
        'wow zoomOutUp' => 'zoomOutUp',
        'wow skewIn' => 'skewIn',
        'wow RotatingY' => 'RotatingY',
        'wow PXLfadeInUp' => 'PXLfadeInUp',
    );
    return $roofex_animate;
}

function roofex_widget_animate_v2() {
    $roofex_animate_v2 = array(
        '' => 'None',
        'wow letter' => 'Letter',
        'wow bounce' => 'bounce',
        'wow flash' => 'flash',
        'wow pulse' => 'pulse',
        'wow rubberBand' => 'rubberBand',
        'wow shake' => 'shake',
        'wow swing' => 'swing',
        'wow tada' => 'tada',
        'wow wobble' => 'wobble',
        'wow bounceIn' => 'bounceIn',
        'wow bounceInDown' => 'bounceInDown',
        'wow bounceInLeft' => 'bounceInLeft',
        'wow bounceInRight' => 'bounceInRight',
        'wow bounceInUp' => 'bounceInUp',
        'wow bounceOut' => 'bounceOut',
        'wow bounceOutDown' => 'bounceOutDown',
        'wow bounceOutLeft' => 'bounceOutLeft',
        'wow bounceOutRight' => 'bounceOutRight',
        'wow bounceOutUp' => 'bounceOutUp',
        'wow fadeIn' => 'fadeIn',
        'wow fadeInDown' => 'fadeInDown',
        'wow fadeInDownBig' => 'fadeInDownBig',
        'wow fadeInLeft' => 'fadeInLeft',
        'wow fadeInLeftBig' => 'fadeInLeftBig',
        'wow fadeInRight' => 'fadeInRight',
        'wow fadeInRightBig' => 'fadeInRightBig',
        'wow fadeInUp' => 'fadeInUp',
        'wow fadeInUpBig' => 'fadeInUpBig',
        'wow fadeOut' => 'fadeOut',
        'wow fadeOutDown' => 'fadeOutDown',
        'wow fadeOutDownBig' => 'fadeOutDownBig',
        'wow fadeOutLeft' => 'fadeOutLeft',
        'wow fadeOutLeftBig' => 'fadeOutLeftBig',
        'wow fadeOutRight' => 'fadeOutRight',
        'wow fadeOutRightBig' => 'fadeOutRightBig',
        'wow fadeOutUp' => 'fadeOutUp',
        'wow fadeOutUpBig' => 'fadeOutUpBig',
        'wow flip' => 'flip',
        'wow flipInX' => 'flipInX',
        'wow flipInY' => 'flipInY',
        'wow flipOutX' => 'flipOutX',
        'wow flipOutY' => 'flipOutY',
        'wow lightSpeedIn' => 'lightSpeedIn',
        'wow lightSpeedOut' => 'lightSpeedOut',
        'wow rotateIn' => 'rotateIn',
        'wow rotateInDownLeft' => 'rotateInDownLeft',
        'wow rotateInDownRight' => 'rotateInDownRight',
        'wow rotateInUpLeft' => 'rotateInUpLeft',
        'wow rotateInUpRight' => 'rotateInUpRight',
        'wow rotateOut' => 'rotateOut',
        'wow rotateOutDownLeft' => 'rotateOutDownLeft',
        'wow rotateOutDownRight' => 'rotateOutDownRight',
        'wow rotateOutUpLeft' => 'rotateOutUpLeft',
        'wow rotateOutUpRight' => 'rotateOutUpRight',
        'wow hinge' => 'hinge',
        'wow rollIn' => 'rollIn',
        'wow rollOut' => 'rollOut',
        'wow zoomIn' => 'zoomIn',
        'wow zoomInDown' => 'zoomInDown',
        'wow zoomInLeft' => 'zoomInLeft',
        'wow zoomInRight' => 'zoomInRight',
        'wow zoomInUp' => 'zoomInUp',
        'wow zoomOut' => 'zoomOut',
        'wow zoomOutDown' => 'zoomOutDown',
        'wow zoomOutLeft' => 'zoomOutLeft',
        'wow zoomOutRight' => 'zoomOutRight',
        'wow zoomOutUp' => 'zoomOutUp',
        'wow skewIn' => 'skewIn',
        'wow RotatingY' => 'RotatingY',
        'wow PXLfadeInUp' => 'PXLfadeInUp',
    );
    return $roofex_animate_v2;
}


/**
 * Pagram Animation
*/
if(!function_exists('roofex_widget_animation_settings')){
    function roofex_widget_animation_settings($args = []){
        $args = wp_parse_args($args, [
            'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => []
        ]);
        return array(
            'name'      => 'section_animation',
            'label'     => esc_html__('Animation', 'roofex'),
            'tab'       => $args['tab'],
            'condition' => $args['condition'],
            'controls'  => array_merge(
                array(
                    array(
                        'name' => 'pxl_animate',
                        'label' => esc_html__('Case Animate', 'roofex' ),
                        'type' => \Elementor\Controls_Manager::SELECT,
                        'options' => roofex_widget_animate(),
                        'default' => '',
                    ),
                    array(
                        'name' => 'pxl_animate_delay',
                        'label' => esc_html__('Animate Delay', 'roofex' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => '0',
                        'description' => 'Enter number. Default 0ms',
                    ),
                )
            )
        );
    }
}

/* Search Popup */
if(!function_exists('roofex_hook_anchor_search')){
    function roofex_hook_anchor_search(){ ?>
        <div id="pxl-search-popup">
            <div class="pxl-item--overlay"></div>
            <div class="pxl-item--conent">
                <div class="pxl-item--close pxl-close"></div>
                <form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
                    <input type="text" placeholder="<?php esc_attr_e('Type Your Search Words...', 'roofex'); ?>" name="s" class="search-field" />
                    <button type="submit" class="search-submit rm-style-default"><i class="caseicon-search"></i></button>
                    <div class="pxl--search-divider"></div>
                </form>
            </div>
        </div>
    <?php }
}       

add_action( 'pxl_anchor_target', 'roofex_hook_anchor_templates_hidden_panel');
function roofex_hook_anchor_templates_hidden_panel(){

    $hidden_templates = roofex_get_templates_slug('hidden-panel');
    if(empty($hidden_templates)) return;

    foreach ($hidden_templates as $slug => $values){
        $args = [
            'slug' => $slug,
            'post_id' => $values['post_id'],
            'position' => !empty($values['position']) ? $values['position'] : 'custom-pos'
        ];
        if( did_action('pxl_anchor_target_hidden_panel_'.$values['post_id']) <= 0){  
            //can be assign from here: do_action( 'pxl_anchor_target_hidden_panel_'.$slug);
            do_action( 'pxl_anchor_target_hidden_panel_'.$values['post_id'], $args );  
        }
    } 
}

function roofex_hook_anchor_hidden_panel($args){  

    ?>
    <div id="pxl-hidden-sidebar" class="pxl-hidden-sidebar pxl-hidden-template-<?php echo esc_attr($args['post_id'])?> pos-<?php echo esc_attr($args['position']) ?>">
        <div class="pxl-item--overlay"></div>
        <div class="pxl-item--conent">
            <div class="pxl-item--close pxl-close"></div>
            <?php echo Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$args['post_id']); ?>
        </div>
    </div>
    <?php 
}

/* Cart Sidebar */
if(!function_exists('roofex_hook_anchor_cart')){
    function roofex_hook_anchor_cart(){ 
       $cart_icon = roofex()->get_page_opt( 'cart_icon', false );
       ?>
       <?php if(class_exists('Woocommerce')) : ?>
        <div class="pxl-widget-cart-wrap">
            <div class="pxl-item--overlay"></div>
            <div class="pxl-widget-cart-sidebar">
                <div class="pxl-close"><i class="pxl-icon-close"></i></div>
                <div class="widget_shopping_cart">
                    <div class="widget_shopping_head">
                        <div class="widget_shopping_title">
                            <?php echo esc_html__( 'Cart', 'roofex' ); ?>
                        </div>
                    </div>
                    <div class="widget_shopping_cart_content">
                        <?php woocommerce_mini_cart(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
<?php }
}
add_action( 'pxl_anchor_target', 'roofex_hook_anchor_cart');

/**
 * Show Cart Sidebar Hidden
 */
add_action('wp_ajax_nopriv_item_added', 'roofex_addedtocart_sweet_message');
add_action('wp_ajax_item_added', 'roofex_addedtocart_sweet_message');
function roofex_addedtocart_sweet_message() {
    echo isset($_POST['id']) && $_POST['id'] > 0 ? (int) esc_attr($_POST['id']) : false;
    die();
}
add_action('wp_footer', 'roofex_product_count_check');
function roofex_product_count_check() {
    if (class_exists('Woocommerce') && is_checkout())
        return;
    ?>
    <script type="text/javascript">
        jQuery( function($) {
            if ( typeof wc_add_to_cart_params === 'undefined' )
                return false;

            $(document.body).on( 'added_to_cart', function( event, fragments, cart_hash, $button ) {
                var $pid = $button.data('product_id');

                $.ajax({
                    type: 'POST',
                    url: wc_add_to_cart_params.ajax_url,
                    data: {
                        'action': 'item_added',
                        'id'    : $pid
                    },
                    success: function (response) {
                        $('.pxl-widget-cart-wrap').addClass('open');
                    }
                });
            });
        });
    </script>
    <?php
}       

