<?php

class PxlProgressbar_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_progressbar';
    protected $title = 'PXL Progress Bar';
    protected $icon = 'eicon-skill-bar';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"source_section","label":"Source Settings","tab":"content","controls":[{"name":"progressbar_list","label":"Progress Bar Lists","type":"repeater","controls":[{"name":"title","label":"Title","type":"text","placeholder":"Enter your title","default":"My Skill","label_block":true},{"name":"percent","label":"Percentage","type":"slider","default":{"size":50,"unit":"%"},"label_block":true},{"name":"item_bar_color","label":"Bar Background Color","type":"color","selectors":{"{{WRAPPER}} {{CURRENT_ITEM}} .pxl-progress-bar":"background-color: {{VALUE}}"}}],"title_field":"{{title}}"}]},{"name":"section_title","label":"Style","tab":"style","controls":[{"name":"style","label":"Style","type":"select","options":{"style-default":"Default","style1":"Style 1"},"default":"style-default"},{"name":"height","label":"Height Bar","type":"slider","control_type":"responsive","size_units":["px","%"],"range":{"px":{"min":0,"max":3000}},"selectors":{"{{WRAPPER}} .pxl-progressbar .progress-bound":"height: {{SIZE}}{{UNIT}};","{{WRAPPER}} .pxl-progressbar .pxl-progress-bar":"height: {{SIZE}}{{UNIT}};"}},{"name":"title_color","label":"Title Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-title":"color: {{VALUE}};"}},{"name":"typography","label":"Title Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-progressbar .progress-title"},{"name":"percent_color","label":"Percentage Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-percentage":"color: {{VALUE}};"}},{"name":"percentage_typography","label":"Percentage Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-progressbar .progress-percentage"},{"name":"bound_color","label":"Bound Background Color","type":"color","selectors":{"{{WRAPPER}} .pxl-progressbar .progress-bound":"background-color: {{VALUE}};"}}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'pxl-progressbar','roofex-progressbar','progressbar' );
}