<?php $html_id = pxl_get_element_id($settings); 
if(isset($settings['tabs']) && !empty($settings['tabs']) && count($settings['tabs'])): 
    $tab_bd_ids = [];
?>
<div class="pxl-tabs pxl-tabs6 <?php echo esc_attr($settings['tab_effect'].' '.$settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-tabs--inner">
        <div class="wrap-title container">
            <div class="pxl-tabs--title row">
                <?php foreach ($settings['tabs'] as $key1 => $value) : 
                    $icon_key = $widget->get_repeater_setting_key( 'pxl_icon_tab', 'icons', $key1 );
                    $image = isset($value['image']) ? $value['image'] : '';
                    $widget->add_render_attribute( $icon_key, [
                        'class' => $value['pxl_icon_tab'],
                        'aria-hidden' => 'true',
                    ] );
                    ?>
                    <div class="pxl-item--title  <?php if($settings['tab_active'] == $key + 1) { echo 'active'; } ?>" data-target="#<?php echo esc_attr($html_id.'-'.$value['_id']); ?>">
                        <div class="wrap-icon-tab ">
                            <div class="title-tab">
                                <?php if(!empty($image['id'])) { 
                                    $img = pxl_get_image_by_size( array(
                                        'attach_id'  => $image['id'],
                                        'thumb_size' => 'full',
                                        'class' => 'no-lazyload',
                                    ));
                                    $thumbnail = $img['thumbnail'];
                                    echo wp_kses_post($thumbnail);
                                }?>
                                <span>
                                    <?php echo pxl_print_html($value['title']); ?>
                                </span>
                            </div> 
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="pxl-tabs--content">
            <?php foreach ($settings['tabs'] as $key => $content) : ?>
                <div id="<?php echo esc_attr($html_id.'-'.$content['_id']); ?>" class="pxl-item--content <?php if($settings['tab_active'] == $key + 1) { echo 'active'; } ?> <?php if($content['content_type'] == 'template') { echo 'pxl-tabs--elementor'; } ?>" <?php if($settings['tab_active'] == $key + 1) { ?>style="display: block; opacity: 1"<?php } ?>>
                    <?php if($content['content_type'] && !empty($content['desc'])) {
                        echo pxl_print_html($content['desc']); 
                    } elseif(!empty($content['content_template'])) {
                        $tab_content = Elementor\Plugin::$instance->frontend->get_builder_content_for_display( (int)$content['content_template']);
                        $tab_bd_ids[] = (int)$content['content_template'];
                        pxl_print_html($tab_content);
                    } ?>        
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>
<?php endif; ?>