<?php
/*
 * The template for displaying all pages.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

if ($roof_meta) {
	$roof_content_padding = $roof_meta['content_spacings'];
} else { $roof_content_padding = ''; }
// Padding - Metabox
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
	$roof_content_top_spacings = $roof_meta['content_top_spacings'];
	$roof_content_bottom_spacings = $roof_meta['content_bottom_spacings'];
	if ($roof_content_padding === 'padding-custom') {
		$roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
		$roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_custom_padding = '';
}

// Page Layout Options
$roof_woo_columns = cs_get_option('woo_product_columns');
$roof_woo_sidebar = cs_get_option('woo_sidebar_position');

$roof_woo_columns = $roof_woo_columns ? $roof_woo_columns : '3';

if ($roof_woo_sidebar === 'left-sidebar') {
	$roof_column_class = 'col-md-9';
	$roof_sidebar_class = 'roof-left-sidebar';
} elseif ($roof_woo_sidebar === 'sidebar-hide') {
	$roof_column_class = 'col-md-12';
	$roof_sidebar_class = 'roof-hide-sidebar';
} else {
	$roof_column_class = 'col-md-9';
	$roof_sidebar_class = 'roof-right-sidebar';
}

get_header();
get_template_part( 'layouts/header/title', 'bar' ); ?>

<section class="roof-main-wrap container sidebar-right woocommerce woocommerce-page woo-col-<?php echo esc_attr($roof_woo_columns .' '. $roof_content_padding .' '. $roof_sidebar_class); ?>" style="<?php echo esc_attr($roof_custom_padding); ?>">
	<div class="row">

		<?php
			// Left Sidebar
			if($roof_woo_sidebar === 'left-sidebar') {
	   		get_sidebar('shop');
			}
		?>

		<div class="roof-primary <?php echo esc_attr($roof_column_class); ?>">
			<?php
			if ( have_posts() ) :
				woocommerce_content();
			endif; // End of the loop.
			?>
		</div><!-- Content Area -->

		<?php
			// Right Sidebar
			if($roof_woo_sidebar !== 'left-sidebar' && $roof_woo_sidebar !== 'sidebar-hide') {
				get_sidebar('shop');
			}
		?>

	</div>
</section>

<?php
get_footer();