<?php
/*
 * The template for displaying all single posts.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */
get_header();
get_template_part( 'layouts/header/title', 'bar' );

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

if ($roof_meta) {
	$roof_content_padding = $roof_meta['content_spacings'];
} else { $roof_content_padding = ''; }
// Padding - Metabox
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
	$roof_content_top_spacings = $roof_meta['content_top_spacings'];
	$roof_content_bottom_spacings = $roof_meta['content_bottom_spacings'];
	if ($roof_content_padding === 'padding-custom') {
		$roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
		$roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_custom_padding = '';
}

// Theme Options
$roof_sidebar_position = cs_get_option('single_sidebar_position');
$roof_single_comment = cs_get_option('single_comment_form');

// Sidebar Position
if ($roof_sidebar_position === 'sidebar-hide') {
	$roof_layout_class = 'col-md-12';
	$roof_sidebar_class = 'roof-hide-sidebar';
} elseif ($roof_sidebar_position === 'sidebar-left') {
	$roof_layout_class = 'col-md-9';
	$roof_sidebar_class = 'roof-left-sidebar';
} else {
	$roof_layout_class = 'col-md-9';
	$roof_sidebar_class = 'sidebar-right';
}
?>

<div class="container roof-main-wrap <?php echo esc_attr($roof_content_padding .' '. $roof_sidebar_class); ?>" style="<?php echo esc_attr($roof_custom_padding); ?>">
	<div class="row">

		<?php
		if ($roof_sidebar_position === 'sidebar-left' && $roof_sidebar_position !== 'sidebar-hide') {
			get_sidebar(); // Sidebar
		}
		?>

		<div class="roof-primary <?php echo esc_attr($roof_layout_class); ?>">
			<div class="roof-unit-fix">
				<div class="roof-blog-detail">
					<?php
					if ( have_posts() ) :
						while ( have_posts() ) : the_post();
							get_template_part( 'layouts/post/content', 'single' );
							$roof_single_comment = $roof_single_comment ? comments_template() : '';
						endwhile;
					else :
						get_template_part( 'layouts/post/content', 'none' );
					endif; ?>

				</div>
			</div>
				<?php
		    roof_paging_nav();
		    wp_reset_postdata();  // avoid errors further down the page
				?>
		</div>

			<?php
			if ($roof_sidebar_position !== 'sidebar-hide') {
				get_sidebar(); // Sidebar
			}
			?>

	</div>
</div>

<?php
get_footer();