<?php
/*
 * The template for displaying all single team.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */
get_header();
get_template_part( 'layouts/header/title', 'bar' );

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );
if ($roof_meta) {
	$roof_content_padding = $roof_meta['content_spacings'];
} else { $roof_content_padding = ''; }
// Padding - Theme Options
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
	$roof_content_top_spacings = $roof_meta['content_top_spacings'];
	$roof_content_bottom_spacings = $roof_meta['content_bottom_spacings'];
	if ($roof_content_padding === 'padding-custom') {
		$roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
		$roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_top_spacing = cs_get_option('team_top_spacing');
	$roof_bottom_spacing = cs_get_option('team_bottom_spacing');
	if ($roof_top_spacing || $roof_bottom_spacing) {
		$roof_top_spacing = $roof_top_spacing ? 'padding-top:'. roof_check_px($roof_top_spacing) .';' : '';
		$roof_bottom_spacing = $roof_bottom_spacing ? 'padding-bottom:'. roof_check_px($roof_bottom_spacing) .';' : '';
		$roof_custom_padding = $roof_top_spacing . $roof_bottom_spacing;
	} else {
		$roof_custom_padding = '';
	}
}

// Sidebar Position
$roof_layout_class = 'col-lg-12 no-padding';
?>

<div class="container roof-main-wrap <?php echo esc_attr($roof_content_padding); ?>" style="<?php echo esc_attr($roof_custom_padding); ?>">
	<div class="row">
		<div class="<?php echo esc_attr($roof_layout_class); ?> sngl-team-cnt">
			<div class="roof-blog-one roof-blog-list roof-blog-col-1">
				<?php
					if (have_posts()) : while (have_posts()) : the_post();
						the_content();
					endwhile;
					endif;
				?>
			</div>
			<?php
	    wp_reset_postdata();  
			?>
		</div>
	</div>
</div>

<?php
get_footer();