<?php
/*
 * The template for displaying all single portfolios.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */
get_header();
get_template_part( 'layouts/header/title', 'bar' );

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'portfolio_type_metabox', true );
$roof_meta_port  = get_post_meta( $roof_id, 'page_type_metabox', true );

if ($roof_meta) {
	$roof_content_padding = $roof_meta_port['content_spacings'];
	$gallery_portfolio = $roof_meta['gallery_portfolio'];
	$include_gallery = $roof_meta['include_gallery'];
	$disable_gallery_featured = $roof_meta['disable_gallery_featured'];
} else {
	$roof_content_padding = '';
	$gallery_portfolio = '';
	$include_gallery = '';
	$disable_gallery_featured = '';
}
// Padding - Metabox
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
	$roof_content_top_spacings = $roof_meta_port['content_top_spacings'];
	$roof_content_bottom_spacings = $roof_meta_port['content_bottom_spacings'];
	if ($roof_content_padding === 'padding-custom') {
		$roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
		$roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_custom_padding = '';
}

// Translation
$roof_single_pagination = cs_get_option('portfolio_single_pagination');
$roof_prev_port = cs_get_option('prev_port');
$roof_next_port = cs_get_option('next_port');
$roof_prev_port = ($roof_prev_port) ? $roof_prev_port : esc_html__('Prev Project', 'roof');
$roof_next_port = ($roof_next_port) ? $roof_next_port : esc_html__('Next Project', 'roof');
?>

<div class="container roof-main-wrap <?php echo esc_attr($roof_content_padding); ?>" style="<?php echo esc_attr($roof_custom_padding); ?>">
	<div class="row">
		<div class="work-detail">
			<div class="no-padding sngl-port-cnt">
				<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
					<?php
						if (have_posts()) : while (have_posts()) : the_post();
						global $post;
						if($disable_gallery_featured != true){
						  if($include_gallery === true){
								if($gallery_portfolio){
									$ids = explode( ',', $gallery_portfolio );?>
									<div class="roof-carousel popup-picture" data-autoplay="true" data-items="1" data-margin="0" data-loop="true" data-nav="false" data-dots="true">
									<?php foreach ( $ids as $id ) {
									  $attachment = wp_get_attachment_image_src( $id, 'fullsize' );
									  $alt = get_post_meta($id, '_wp_attachment_image_alt', true);
									  $g_img = isset($attachment[0]) ? $attachment[0] : '';
								    $post_img = $g_img;
									  echo '<div class="item"><div class="roof-picture"><a href="'. $post_img .'"><img src="'. $post_img .'" alt="'. esc_attr($alt) .'"></a></div></div>';
									} ?></div>
						  	<?php } else{
		              echo '<div class="item"><div class="roof-picturee"><a href="<?php get_the_permalink(); ?>"><img src="'. get_the_post_thumbnail_url() .'" alt="'. get_the_title() .'"></a></div></div>';
						  	}
							} else {
									echo '<div class="item"><div class="roof-picturee"><a href="<?php get_the_permalink(); ?>"><img src="'. get_the_post_thumbnail_url() .'" alt="'. get_the_title() .'"></a></div></div>';
							}
						}
					?>
				</div>
		  </div>
      <div class="work-description">
				<?php the_content(); ?>
			</div>

			<?php
			endwhile;
			endif;
			?>

		</div><!-- Post ID -->
		<?php
		if ($roof_single_pagination) {
    	if ( function_exists( 'roof_single_portfolio_navigation' ) ) {
      	echo roof_single_portfolio_navigation();
			}
		} ?>

	</div>
</div>

<?php
get_footer();
