<?php
/*
 * The sidebar containing the main widget area.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

$roof_blog_widget = cs_get_option('blog_widget');
$roof_single_blog_widget = cs_get_option('single_blog_widget');
$roof_team_widget = cs_get_option('team_widget');

if (is_page()) {
	// Page Layout Options
	$roof_page_layout = get_post_meta( get_the_ID(), 'page_layout_options', true );
}
?>

<div class="col-md-3 roof-secondary">
	<?php if (is_page() && $roof_page_layout['page_sidebar_widget']) {
		if (is_active_sidebar($roof_page_layout['page_sidebar_widget'])) {
			dynamic_sidebar($roof_page_layout['page_sidebar_widget']);
		}
	} elseif (!is_page() && $roof_blog_widget && !$roof_single_blog_widget) {
		if (is_active_sidebar($roof_blog_widget)) {
			dynamic_sidebar($roof_blog_widget);
		}
	} elseif ($roof_team_widget && is_singular('team')) {
		if (is_active_sidebar($roof_team_widget)) {
			dynamic_sidebar($roof_team_widget);
		}
	} elseif (is_single() && $roof_single_blog_widget) {
		if (is_active_sidebar($roof_single_blog_widget)) {
			dynamic_sidebar($roof_single_blog_widget);
		}
	} else {
		if (is_active_sidebar('sidebar-1')) {
			dynamic_sidebar( 'sidebar-1' );
		}
	} ?>
</div><!-- #secondary -->

<?php 
