<?php
/*
 * The template for displaying search results pages.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

get_header();
get_template_part( 'layouts/header/title', 'bar' );

// Theme Options
$roof_blog_style = cs_get_option('blog_listing_style');
$roof_blog_columns = cs_get_option('blog_listing_columns');
$roof_sidebar_position = cs_get_option('blog_sidebar_position');

// Columns
if ($roof_blog_style === 'style-two') {
	$roof_blog_columns = $roof_blog_columns ? $roof_blog_columns : 'roof-blog-col-2';
} else {
	$roof_blog_columns = 'roof-blog-col-1';
}

// Style
if ($roof_blog_style === 'style-two') {
	$roof_blog_style = ' roof-blog-one ';
} else {
	$roof_blog_style = ' roof-blog-one roof-blog-list ';
}

// Sidebar Position
if ($roof_sidebar_position === 'sidebar-hide') {
	$roof_layout_class = 'col-md-12';
	$roof_sidebar_class = 'roof-hide-sidebar';
} elseif ($roof_sidebar_position === 'sidebar-left') {
	$roof_layout_class = 'col-md-9';
	$roof_sidebar_class = 'roof-left-sidebar';
} else {
	$roof_layout_class = 'col-md-9';
	$roof_sidebar_class = 'sidebar-right';
}
?>

<div class="container roof-main-wrap <?php echo esc_attr($roof_sidebar_class); ?>">
	<div class="row">

		<?php
		if ($roof_sidebar_position === 'sidebar-left' && $roof_sidebar_position !== 'sidebar-hide') {
			get_sidebar(); 
		}
		?>

		<div class="roof-primary <?php echo esc_attr($roof_layout_class); ?>">
			<div class="<?php echo esc_attr($roof_blog_style) .' '. esc_attr($roof_blog_columns); ?>">
				<?php
				if ( have_posts() ) :
					/* Start the Loop */
					while ( have_posts() ) : the_post();
						get_template_part( 'layouts/post/content' );
					endwhile;
				else :
					get_template_part( 'layouts/post/content', 'none' );
				endif; ?>
			</div>
				<?php
		    roof_paging_nav();
		    wp_reset_postdata();  // avoid errors further down the page
				?>
		</div>

				<?php
				if ($roof_sidebar_position !== 'sidebar-hide') {
					get_sidebar(); 
				}
				?>
	</div>
</div>

<?php
get_footer();