<?php
/*
 * The template for displaying all pages.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

if ($roof_meta) {
	$roof_content_padding = $roof_meta['content_spacings'];
} else { $roof_content_padding = ''; }
// Padding - Metabox
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
	$roof_content_top_spacings = $roof_meta['content_top_spacings'];
	$roof_content_bottom_spacings = $roof_meta['content_bottom_spacings'];
	if ($roof_content_padding === 'padding-custom') {
		$roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
		$roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_custom_padding = '';
}

// Page Layout Options
$roof_page_layout = get_post_meta( get_the_ID(), 'page_layout_options', true );
if ($roof_page_layout) {

	$roof_page_layout = $roof_page_layout['page_layout'];

	if ($roof_page_layout === 'extra-width') {
		$roof_column_class = 'extra-width';
		$roof_layout_class = 'container-fluid';
	} elseif($roof_page_layout === 'left-sidebar' || $roof_page_layout === 'right-sidebar') {
		$roof_column_class = 'col-md-9';
		$roof_layout_class = 'container';
	} else {
		$roof_column_class = 'col-md-12';
		$roof_layout_class = 'container';
	}

	// Page Layout Class
	if ($roof_page_layout === 'left-sidebar') {
		$roof_sidebar_class = 'roof-left-sidebar';
	} elseif ($roof_page_layout === 'right-sidebar') {
		$roof_sidebar_class = 'roof-right-sidebar';
	} elseif ($roof_page_layout === 'extra-width') {
		$roof_sidebar_class = 'roof-extra-width';
	} else {
		$roof_sidebar_class = 'roof-full-width';
	}
} else {
	$roof_column_class = 'col-md-12';
	$roof_layout_class = 'container';
	$roof_sidebar_class = 'roof-full-width';
}

get_header();
get_template_part( 'layouts/header/title', 'bar' );
// echo '<pre>'. json_encode( get_option('_cs_options') ) . '</pre>'; // RoofWP - JSON File, json, Json.
?>
<div class="<?php echo esc_attr($roof_layout_class .' '. $roof_content_padding .' '. $roof_sidebar_class); ?> roof-main-wrap" style="<?php echo esc_attr($roof_custom_padding); ?>">
	<div class="row">

		<?php
		// Left Sidebar
		if($roof_page_layout === 'left-sidebar') {
   		get_sidebar();
		}
		?>

		<div class="roof-primary roof-content-side <?php echo esc_attr($roof_column_class); ?>">
			<?php
			while ( have_posts() ) : the_post();
				the_content();
				// If comments are open or we have at least one comment, load up the comment template.
				$roof_theme_page_comments = cs_get_option('theme_page_comments');
				if ( isset($roof_theme_page_comments) && (comments_open() || get_comments_number()) ) :
					comments_template();
				endif;
			endwhile;
			?>
		</div>
		<?php
			// Right Sidebar
			if($roof_page_layout === 'right-sidebar') {
				get_sidebar();
			}
		?>

	</div>
</div>

<?php
get_footer();