<?php
/**
 * Template part for displaying posts.
 */
$roof_large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
$roof_large_image = isset($roof_large_image[0]) ? $roof_large_image[0] : '';

$roof_read_more_text = cs_get_option('read_more_text');
$roof_read_text = $roof_read_more_text ? $roof_read_more_text : esc_html__( 'Read More', 'roof' );
$roof_post_type = get_post_meta( get_the_ID(), 'post_type_metabox', true );
$roof_blog_style = cs_get_option('blog_listing_style');
$roof_metas_hide = (array) cs_get_option( 'theme_metas_hide' );
?>
<div id="post-<?php the_ID(); ?>" <?php post_class('blog-item'); ?>>
  <?php roof_post_meta();
  if(has_post_thumbnail()) { ?>
	  <div class="roof-picture popup-picture">
	    <a href="<?php echo esc_url($roof_large_image); ?>""><img src="<?php echo esc_url($roof_large_image); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></a>
	  </div>
  <?php } ?>
  <div class="blog-info">
    <?php roof_post_metas(); ?>
    <h3 class="blog-title"><a href="<?php echo esc_url( get_permalink() ); ?>" class="bp-heading"><?php echo esc_attr(get_the_title()); ?></a></h3>
		<p>
			<?php
				$blog_excerpt = cs_get_option('theme_blog_excerpt');
				if ($blog_excerpt) {
					$blog_excerpt = $blog_excerpt;
				} else {
					$blog_excerpt = '55';
				}
					roof_excerpt($blog_excerpt);
					echo roof_wp_link_pages();
			?>
		</p>
    <a href="<?php echo esc_url( get_permalink() ); ?>" class="roof-btn"><?php echo esc_attr($roof_read_text); ?></a>
  </div>
</div>

<?php

