<?php
/**
 * Single Post.
 */
$roof_large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
$roof_large_image = isset($roof_large_image[0]) ? $roof_large_image[0] : '';

$roof_post_type = get_post_meta( get_the_ID(), 'post_type_metabox', true );
$roof_blog_style = cs_get_option('blog_listing_style');

// Single Theme Option
$roof_single_featured_image = cs_get_option('single_featured_image');
$roof_single_author_info = cs_get_option('single_author_info');
$roof_single_share_option = cs_get_option('single_share_option');
$tags_text = cs_get_option('tags_text');
if($tags_text){
	$tag_txt = $tags_text;
} else {
	$tag_txt = esc_html__('Tags', 'roof');
} ?>
<div id="post-<?php the_ID(); ?>" <?php post_class('roof-blog-post'); ?>>

	<div class="blog-detail-wrap">
	 <?php roof_post_meta();
		 if($roof_single_featured_image){
		 	if(has_post_thumbnail()) { ?>
		  	<div class="blog-picture popup-picture"><a href="<?php the_permalink(); ?>">
		  		<img src="<?php echo esc_url($roof_large_image); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></a>
		  	</div>
		  <?php } }?>
	  <?php roof_post_metas(); ?>
	  <h3 class="blog-title"><?php echo esc_attr(get_the_title()); ?></h3>
	  <?php the_content();
	  echo roof_wp_link_pages();?>
	  <div class="roof-blog-meta">
			<?php
				$tag_list = get_the_tags();
				if($tag_list) { ?>
					<div class="roof-blog-tags">
						<?php echo the_tags( '<ul><li><span>'.esc_attr($tag_txt).' :</span>', '</li><li>', '</li></ul>' ); ?>
					</div>
			<?php } ?>

	  </div>
	</div>
	<div class="roof-more-posts">
		<div class="pull-left">
			<?php $prev_post = get_adjacent_post(false, '', true);
			if(!empty($prev_post)) {
			echo '<a href="' . get_permalink($prev_post->ID) . '" title="' . $prev_post->post_title . '"><i class="fa fa-angle-left" aria-hidden="true"></i>' . $prev_post->post_title . '</a>'; } ?>
		</div>
		<div class="pull-right">
			<?php $next_post = get_adjacent_post(false, '', false);
			if(!empty($next_post)) {
			echo '<a href="' . get_permalink($next_post->ID) . '" title="' . $next_post->post_title . '">' . $next_post->post_title . '<i class="fa fa-angle-right" aria-hidden="true"></i></a>'; } ?>
		</div>
	</div>

		<!-- Author Info -->
		<?php
		if($roof_single_author_info) {
			echo roof_author_info();
		}
		?>
		<!-- Author Info -->

</div><!-- #post-## -->

<?php
