<?php
/**
 * Template part for displaying a message that posts cannot be found.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package VT_Framework
 */

?>
<div class="no-results not-found text-center roof-main-wrap">
		<div class="page-content">
			<h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'roof' ); ?></h1>
			<?php
				if ( is_search() ) : ?>
					<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'roof' ); ?></p>
					<div class="roof-404-error">
						<div class="sgny-404-search-form">
							<?php get_search_form(); ?>
						</div>
		            </div><?php
				else : ?>
				<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'roof' ); ?></p>
					<div class="widget_search">
						<?php get_search_form(); ?>
					</div>
				<?php endif;
			?>
		</div>
</div>

<?php
