<!DOCTYPE html>
<!--[if IE 8]> <html <?php language_attributes(); ?> class="ie8"> <![endif]-->
<!--[if !IE]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<?php
$roof_viewport = cs_get_option('theme_responsive');
if($roof_viewport == 'on') { ?>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<?php } else { }

// if the `wp_site_icon` function does not exist (ie we're on < WP 4.3)
if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
  if (cs_get_option('brand_fav_icon')) {
    echo '<link rel="shortcut icon" href="'. esc_url(wp_get_attachment_url(cs_get_option('brand_fav_icon'))) .'" />';
  } else { ?>
    <link rel="shortcut icon" href="<?php echo esc_url(ROOF_IMAGES); ?>/favicon.png" />
  <?php }
  if (cs_get_option('iphone_icon')) {
    echo '<link rel="apple-touch-icon" sizes="57x57" href="'. esc_url(wp_get_attachment_url(cs_get_option('iphone_icon'))) .'" >';
  }
  if (cs_get_option('iphone_retina_icon')) {
    echo '<link rel="apple-touch-icon" sizes="114x114" href="'. esc_url(wp_get_attachment_url(cs_get_option('iphone_retina_icon'))) .'" >';
    echo '<link name="msapplication-TileImage" href="'. esc_url(wp_get_attachment_url(cs_get_option('iphone_retina_icon'))) .'" >';
  }
  if (cs_get_option('ipad_icon')) {
    echo '<link rel="apple-touch-icon" sizes="72x72" href="'. esc_url(wp_get_attachment_url(cs_get_option('ipad_icon'))) .'" >';
  }
  if (cs_get_option('ipad_retina_icon')) {
    echo '<link rel="apple-touch-icon" sizes="144x144" href="'. esc_url(wp_get_attachment_url(cs_get_option('ipad_retina_icon'))) .'" >';
  }
}
$roof_all_element_color  = cs_get_customize_option( 'all_element_colors' );
?>
<meta name="msapplication-TileColor" content="<?php echo esc_attr($roof_all_element_color); ?>">
<meta name="theme-color" content="<?php echo esc_attr($roof_all_element_color); ?>">

<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php
wp_head();

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

if ($roof_meta) {
  $roof_content_padding = $roof_meta['content_spacings'];
} else { $roof_content_padding = ''; }
// Padding - Metabox
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
  $roof_content_top_spacings = $roof_meta['content_top_spacings'];
  $roof_content_bottom_spacings = $roof_meta['content_bottom_spacings'];
  if ($roof_content_padding === 'padding-custom') {
    $roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
    $roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
    $roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
  } else {
    $roof_custom_padding = '';
  }
} else {
  $roof_custom_padding = '';
}
?>
</head>

	<body <?php body_class(); ?>>
    <div class="vt-maintenance-mode">
      <div class="container <?php echo esc_attr($roof_content_padding); ?> roof-content-area" style="<?php echo esc_attr($roof_custom_padding); ?>">
     	<div class="row">
        <?php
          $roof_page = get_post( cs_get_option('maintenance_mode_page') );
          WPBMap::addAllMappedShortcodes();
          echo ( is_object( $roof_page ) ) ? do_shortcode( $roof_page->post_content ) : '';
        ?>
      </div>
      </div>
    </div>
    <?php wp_footer(); ?>
  </body>
</html>

<?php
