<?php
// Metabox
global $post;
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );
if (($roof_meta && is_page()) || ($roof_meta && is_single($post->ID))) {
	$roof_title_bar_padding = $roof_meta['title_area_spacings'];
} else { $roof_title_bar_padding = ''; }
// Padding - Theme Options
if ($roof_title_bar_padding && $roof_title_bar_padding !== 'padding-none') {
	$roof_title_top_spacings = $roof_meta['title_top_spacings'];
	$roof_title_bottom_spacings = $roof_meta['title_bottom_spacings'];
	if ($roof_title_bar_padding === 'padding-custom') {
		$roof_title_top_spacings = $roof_title_top_spacings ? 'padding-top:'. roof_check_px($roof_title_top_spacings) .';' : '';
		$roof_title_bottom_spacings = $roof_title_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_title_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_title_top_spacings . $roof_title_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_title_bar_padding = cs_get_option('title_bar_padding');
	$roof_titlebar_top_padding = cs_get_option('titlebar_top_padding');
	$roof_titlebar_bottom_padding = cs_get_option('titlebar_bottom_padding');
	if ($roof_title_bar_padding === 'padding-custom') {
		$roof_titlebar_top_padding = $roof_titlebar_top_padding ? 'padding-top:'. roof_check_px($roof_titlebar_top_padding) .';' : '';
		$roof_titlebar_bottom_padding = $roof_titlebar_bottom_padding ? 'padding-bottom:'. roof_check_px($roof_titlebar_bottom_padding) .';' : '';
		$roof_custom_padding = $roof_titlebar_top_padding . $roof_titlebar_bottom_padding;
	} else {
		$roof_custom_padding = '';
	}
}

// Banner Type - Meta Box
if (($roof_meta && is_page()) || ($roof_meta && is_single($post->ID)) || ($roof_meta && is_woocommerce_shop())) {
	$roof_banner_type = $roof_meta['banner_type'];
} else { $roof_banner_type = ''; }

// Overlay Color - Theme Options
if (($roof_meta && is_page()) || ($roof_meta && is_single($post->ID)) || ($roof_meta && is_woocommerce_shop())) {
	$roof_bg_overlay_color = $roof_meta['titlebar_bg_overlay_color'];
} else { $roof_bg_overlay_color = ''; }
if ($roof_bg_overlay_color) {
	if ($roof_bg_overlay_color) {
		$roof_overlay_color = 'background-color: '. $roof_bg_overlay_color .';';
	} else {
		$roof_overlay_color = '';
	}
} else {
	$roof_bg_overlay_color = cs_get_option('titlebar_bg_overlay_color');
	if ($roof_bg_overlay_color) {
		$roof_overlay_color = 'background-color: '. $roof_bg_overlay_color .';';
	} else {
		$roof_overlay_color = '';
	}
}

// Background - Type
if( $roof_meta && isset( $roof_meta['title_area_bg'] ) ) {

  extract( $roof_meta['title_area_bg'] );

  $roof_background_image       = ( ! empty( $image ) ) ? 'background-image: url(' . $image . ');' : '';
  $roof_background_repeat      = ( ! empty( $image ) && ! empty( $repeat ) ) ? ' background-repeat: ' . $repeat . ';' : '';
  $roof_background_position    = ( ! empty( $image ) && ! empty( $position ) ) ? ' background-position: ' . $position . ';' : '';
  $roof_background_size    = ( ! empty( $image ) && ! empty( $size ) ) ? ' background-size: ' . $size . ';' : '';
  $roof_background_attachment    = ( ! empty( $image ) && ! empty( $size ) ) ? ' background-attachment: ' . $attachment . ';' : '';
  $roof_background_color       = ( ! empty( $color ) ) ? ' background-color: ' . $color . ';' : '';
  $roof_background_style       = ( ! empty( $image ) ) ? $roof_background_image . $roof_background_repeat . $roof_background_position . $roof_background_size . $roof_background_attachment : '';

  $roof_title_bg = ( ! empty( $roof_background_style ) || ! empty( $roof_background_color ) ) ? $roof_background_style . $roof_background_color : '';

} else { $roof_title_bg = ''; }

if($roof_banner_type === 'hide-title-area') { // Hide Title Area
} elseif($roof_meta && $roof_banner_type === 'revolution-slider') { // Hide Title Area
	echo do_shortcode($roof_meta['page_revslider']);
} else {

$need_title_bar = cs_get_option('need_title_bar');
if($roof_meta){
	if ($roof_meta['hide_breadcrumbs']) {
		$need_breadcrumbs = $roof_meta['hide_breadcrumbs'];
	} else {
		$need_breadcrumbs = cs_get_option('need_breadcrumbs');
	}
} else {
	$need_breadcrumbs = cs_get_option('need_breadcrumbs');
}

if($need_title_bar) { ?>
<section class="roof-page-title roof-parallax <?php echo esc_attr($roof_banner_type); ?>" data-parallax-background-ratio=".5" style="<?php echo esc_attr($roof_title_bg); ?>">
  <div class="roof-title-overlay <?php echo esc_attr($roof_title_bar_padding); ?>" style="<?php echo esc_attr($roof_overlay_color); ?><?php echo esc_attr($roof_custom_padding); ?>">
	  <div class="container">
	    <div class="row">
	      <div class="col-md-6 col-sm-6">
	        <h1 class="page-title"><?php echo roof_title_area(); ?></h1>
	      </div>
	      <?php if(!$need_breadcrumbs) { ?>
	        <div class="col-md-6 col-sm-6">
	          <div class="breadcrumb">
	            <?php if ( function_exists( 'breadcrumb_trail' ) ) breadcrumb_trail(); ?>
	          </div>
	        </div>
	      <?php } ?>
	    </div>
	  </div>
  </div>
</section>
<?php  }
 } ?>