<?php
// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('testimonial') ) ? $roof_id : false;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

// Header Style - ThemeOptions & Metabox
if ($roof_meta) {
  $roof_header_design  = $roof_meta['select_header_design'];
  $roof_sticky_header  = $roof_meta['sticky_header'];
} else {
  $roof_header_design  = cs_get_option('select_header_design');
  $roof_sticky_header  = cs_get_option('sticky_header');
}

if ($roof_header_design === 'default') {
  $roof_header_design_actual  = cs_get_option('select_header_design');
} else {
  $roof_header_design_actual = ( $roof_header_design ) ? $roof_header_design : cs_get_option('select_header_design');
}
if ($roof_meta && $roof_header_design !== 'default') {
  $header_social_icons = $roof_meta['header_social_icons'];
  $menubar_width = $roof_meta['menubar_width'];
  $roof_sticky_header  = $roof_meta['sticky_header'];

} else {
  $header_social_icons  = cs_get_option('header_social_icons');
  $menubar_width = cs_get_option('menubar_width');
  $roof_sticky_header  = cs_get_option('sticky_header');
}
$roof_mobile_breakpoint = cs_get_option('mobile_breakpoint');
$roof_breakpoint = $roof_mobile_breakpoint ? $roof_mobile_breakpoint : '992';
if($roof_header_design_actual === 'style_one'){
$roof_sticky_header_class = $roof_sticky_header ? ' roof-header-sticky ' : '';
} else {
  $roof_sticky_header_class = '';
}
// Disable Mean Menu
$theme_mean_menu = cs_get_option('theme_mean_menu');
if($theme_mean_menu){
  $class_mean = ' remove-mean';
} else {
  $class_mean = ' enable-mean';
}

?>
<div class="roof-navigation <?php echo $class_mean; ?> <?php echo $roof_sticky_header_class; ?>">
<?php
if ($roof_meta) {
  if ($roof_meta['choose_menu']) {
    $roof_choose_menu = $roof_meta['choose_menu'];
  } else {
    $roof_choose_menu = '';
  }
} else { $roof_choose_menu = ''; }
// $roof_choose_menu = $roof_choose_menu ? $roof_choose_menu : '';

if($roof_header_design_actual === 'style_two'){
  echo '<div class="header-right"><nav class="roof-menu" data-responsive-size="'.$roof_breakpoint.'">';
} else {
  if($menubar_width) {
    echo '<nav class="roof-menu menu-style-two" data-responsive-size="'.$roof_breakpoint.'">
    <div class="container">';
  } else {
    echo '<div class="container"><nav class="roof-menu menu-style-two menu-spacer-two" data-responsive-size="'.$roof_breakpoint.'">
    ';
  }
}
  if ($roof_meta) {
    wp_nav_menu(
      array(
        'menu'              => 'primary',
        'theme_location'    => 'primary',
        'container'         => '',
        'container_class'   => '',
        'container_id'      => '',
        'menu'              => $roof_choose_menu,
        'menu_class'        => 'nav navbar-nav',
        'fallback_cb'       => 'roof_wp_bootstrap_navwalker::fallback',
        'walker'            => new roof_wp_bootstrap_navwalker()
      )
    );
  } else {
    wp_nav_menu(
      array(
        'menu'              => 'primary',
        'theme_location'    => 'primary',
        'container'         => '',
        'container_class'   => '',
        'container_id'      => '',
        'menu_class'        => 'nav navbar-nav',
        'fallback_cb'       => 'roof_wp_bootstrap_navwalker::fallback',
        'walker'            => new roof_wp_bootstrap_navwalker()
      )
    );
  }
if($roof_header_design_actual === 'style_two'){
  echo ''.do_shortcode($header_social_icons).'</nav></div>';

} else {
  if($menubar_width) {
    echo ''.do_shortcode($header_social_icons).'</div></nav>';
  } else {
    echo ''.do_shortcode($header_social_icons).'</nav></div>';
  }
}
if(is_front_page()){} ?>
</div><?php
