<?php
// Logo Image
$roof_brand_logo_default = cs_get_option('brand_logo_default');
$roof_brand_logo_retina = cs_get_option('brand_logo_retina');

// Mobile Logo
$roof_mobile_logo = cs_get_option('mobile_logo_retina');
$roof_mobile_width = cs_get_option('mobile_logo_width');
$roof_mobile_height = cs_get_option('mobile_logo_height');
$roof_mobile_logo_top = cs_get_option('mobile_logo_top');
$roof_mobile_logo_bottom = cs_get_option('mobile_logo_bottom');
$roof_mobile_class = $roof_mobile_logo ? ' hav-mobile-logo' : ' dhve-mobile-logo';

// Transparent Header Logos
$roof_transparent_logo = cs_get_option('transparent_logo_default');
$roof_transparent_retina = cs_get_option('transparent_logo_retina');
$transparent_default_class = $roof_transparent_logo ? ' hav-transparent-logo' : ' dhav-transparent-logo';

// Metabox - Header Transparent
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox'. true );
if ($roof_meta) {
  $roof_transparent_header = $roof_meta['transparency_header'];
} else { $roof_transparent_header = ''; }

// Retina Size
$roof_retina_width = cs_get_option('retina_width');
$roof_retina_height = cs_get_option('retina_height');

if ($roof_meta) {
	$roof_header_design  = $roof_meta['select_header_design'];
} else {
	$roof_header_design  = cs_get_option('select_header_design');
}

// Logo Spacings
$roof_brand_logo_top = cs_get_option('brand_logo_top');
$roof_brand_logo_bottom = cs_get_option('brand_logo_bottom');
if ($roof_mobile_logo_top) {
	$roof_brand_logo_top = 'padding-top:'. roof_check_px($roof_mobile_logo_top) .';';
} elseif ($roof_brand_logo_top !== '') {
	$roof_brand_logo_top = 'padding-top:'. roof_check_px($roof_brand_logo_top) .';';
} else { $roof_brand_logo_top = ''; }
if ($roof_mobile_logo_bottom) {
	$roof_brand_logo_bottom = 'padding-bottom:'. roof_check_px($roof_mobile_logo_bottom) .';';
} elseif ($roof_brand_logo_bottom !== '') {
	$roof_brand_logo_bottom = 'padding-bottom:'. roof_check_px($roof_brand_logo_bottom) .';';
} else { $roof_brand_logo_bottom = ''; }

if ($roof_header_design === 'default') {
  $roof_header_design_actual  = cs_get_option('select_header_design');
} else {
  $roof_header_design_actual = ( $roof_header_design ) ? $roof_header_design : cs_get_option('select_header_design');
}

$retina_width_actual = $roof_retina_width ? $roof_retina_width : '';
$retina_height_actual = $roof_retina_height ? $roof_retina_height : '';
?>

<div class="roof-logo<?php echo esc_attr($roof_mobile_class); ?><?php echo esc_attr($transparent_default_class); ?>" style="<?php echo esc_attr($roof_brand_logo_top); echo esc_attr($roof_brand_logo_bottom); ?>">
	<a href="<?php echo esc_url(home_url( '/' )); ?>">
	<?php
	if (isset($roof_transparent_header) && isset($roof_transparent_logo)) {
		if (isset($roof_transparent_logo)){
			if (isset($roof_transparent_retina)){
				echo '<img src="'. esc_url(wp_get_attachment_url($roof_transparent_retina)) .'" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'" alt="" class="transparent-retina-logo transparent-logo">';
			}
			echo '<img src="'. esc_url(wp_get_attachment_url($roof_transparent_logo)) .'" alt="" class="transparent-default-logo transparent-logo" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'">';
		} elseif (isset($roof_brand_logo_default)){
			if ($roof_brand_logo_retina){
				echo '<img src="'. esc_url(wp_get_attachment_url($roof_brand_logo_retina)) .'" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'" alt="" class="retina-logo">
					';
			}
			echo '<img src="'. esc_url(wp_get_attachment_url($roof_brand_logo_default)) .'" alt="" class="default-logo" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'">';
		} else {
			echo '<div class="text-logo"><h2>'. esc_attr(get_bloginfo( 'name' )) . '</h2></div>';
		}
		if (isset($roof_brand_logo_default)){
			if ($roof_brand_logo_retina){
				echo '<img src="'. esc_url(wp_get_attachment_url($roof_brand_logo_retina)) .'" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'" alt="" class="retina-logo sticky-logo">
					';
			}
			echo '<img src="'. esc_url(wp_get_attachment_url($roof_brand_logo_default)) .'" alt="" class="default-logo sticky-logo" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'">';
		}
	} elseif (isset($roof_brand_logo_default)){
		if ($roof_brand_logo_retina){
			echo '<img src="'. esc_url(wp_get_attachment_url($roof_brand_logo_retina)) .'" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'" alt="" class="retina-logo">
				';
		}
		echo '<img src="'. esc_url(wp_get_attachment_url($roof_brand_logo_default)) .'" alt="" class="default-logo" width="'. esc_attr($retina_width_actual) .'" height="'. esc_attr($retina_height_actual) .'">';
	} else {
		echo '<div class="text-logo"><h2>'. esc_attr(get_bloginfo( 'name' )) . '</h2></div>';
	}
	echo '</a>';
	?>
</div><?php
