<?php
	// Main Text
	$roof_need_copyright = cs_get_option('need_copyright');
	$roof_footer_copyright_layout = cs_get_option('footer_copyright_layout');

	if ($roof_footer_copyright_layout === 'copyright-1') {
		$roof_copyright_layout_class = 'col-sm-6';
		$roof_copyright_seclayout_class = 'text-right';
	} elseif ($roof_footer_copyright_layout === 'copyright-2') {
		$roof_copyright_layout_class = 'col-sm-6 pull-right text-right';
		$roof_copyright_seclayout_class = 'text-left';
	} elseif ($roof_footer_copyright_layout === 'copyright-3') {
		$roof_copyright_layout_class = 'col-sm-12 text-center';
	} else {
		$roof_copyright_layout_class = '';
		$roof_copyright_seclayout_class = '';
	}

	if (isset($roof_need_copyright)) {
?>

<!-- Copyright Bar -->

<div class="roof-copyright">
	<div class="container">
		<div class="row">
			<div class="cprt-left <?php echo esc_attr($roof_copyright_layout_class); ?>">
				<?php
					$roof_copyright_text = cs_get_option('copyright_text');
					if($roof_copyright_text){
						echo '<p>'. do_shortcode($roof_copyright_text) .'</p>';
					} else {
						echo '<p>'.esc_html__('© 2017 Victor Themes - Elight Themeforest Author.' , 'roof').'</p>';
					}
				?>
			</div>
			<?php if ($roof_footer_copyright_layout != 'copyright-3') { ?>
			<div class="col-sm-6 cprt-right <?php echo esc_attr($roof_copyright_seclayout_class); ?>">
				<?php
				$roof_secondary_text = cs_get_option('secondary_text');
				if($roof_secondary_text) {
					echo ''. do_shortcode($roof_secondary_text) .'';

				} else {
				  wp_nav_menu(
				    array(
				      'menu'              => 'footer',
				      'theme_location'    => '',
				      'container'         => '',
				      'container_class'   => '',
				      'container_id'      => '',
				      'menu_class'        => 'nav navbar-nav footer-menu',
				      'fallback_cb'       => 'roof_wp_bootstrap_navwalker::fallback',
				      'walker'            => new roof_wp_bootstrap_navwalker()
				    )
				  );
				} ?>
			</div>

			<?php }?>

		</div>
	</div>
</div>
<!-- Copyright Bar -->
<?php }