<?php
/*
 * The main template file.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */
get_header();
get_template_part( 'layouts/header/title', 'bar' );

// Metabox
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

if ($roof_meta) {
	$roof_content_padding = $roof_meta['content_spacings'];
} else { $roof_content_padding = ''; }
// Padding - Metabox
if ($roof_content_padding && $roof_content_padding !== 'padding-none') {
	$roof_content_top_spacings = $roof_meta['content_top_spacings'];
	$roof_content_bottom_spacings = $roof_meta['content_bottom_spacings'];
	if ($roof_content_padding === 'padding-custom') {
		$roof_content_top_spacings = $roof_content_top_spacings ? 'padding-top:'. roof_check_px($roof_content_top_spacings) .';' : '';
		$roof_content_bottom_spacings = $roof_content_bottom_spacings ? 'padding-bottom:'. roof_check_px($roof_content_bottom_spacings) .';' : '';
		$roof_custom_padding = $roof_content_top_spacings . $roof_content_bottom_spacings;
	} else {
		$roof_custom_padding = '';
	}
} else {
	$roof_custom_padding = '';
}

// Theme Options
$roof_blog_style = cs_get_option('blog_listing_style');
$roof_blog_columns = cs_get_option('blog_listing_columns');
$roof_sidebar_position = cs_get_option('blog_sidebar_position');

// Columns
if ($roof_blog_style === 'style-two') {
	$roof_blog_columns = $roof_blog_columns ? $roof_blog_columns : 'roof-blog-col-2';
} elseif ($roof_blog_style === 'style-three') {
	$roof_blog_columns = $roof_blog_columns ? $roof_blog_columns : 'roof-blog-col-2';
} else {
	$roof_blog_columns = 'roof-blog-col-1';
}

// Style
if ($roof_blog_style === 'style-two') {
	$roof_blog_style = ' roof-blog-one ';
} elseif ($roof_blog_style === 'style-three') {
	$roof_blog_style = ' roof-blog-one roof-blog-two ';
} else {
	$roof_blog_style = ' roof-blog-one roof-blog-list ';
}

// Sidebar Position
if ($roof_sidebar_position === 'sidebar-hide') {
	$layout_class = 'col-md-12';
	$roof_sidebar_class = 'roof-hide-sidebar';
} elseif ($roof_sidebar_position === 'sidebar-left') {
	$layout_class = 'col-md-9';
	$roof_sidebar_class = 'roof-left-sidebar';
} else {
	$layout_class = 'col-md-9';
	$roof_sidebar_class = 'sidebar-right';
}
?>

<div class="roof-main-wrap <?php echo esc_attr($roof_content_padding .' '. $roof_sidebar_class); ?>" style="<?php echo esc_attr($roof_custom_padding); ?>">
	<div class="container">
		<div class="row">
			<?php
			if ($roof_sidebar_position === 'sidebar-left' && $roof_sidebar_position !== 'sidebar-hide') {
				get_sidebar();
			}
			?>

			<div class="roof-primary <?php echo esc_attr($layout_class); ?>">
				<div class="<?php echo esc_attr($roof_blog_style) .' '. esc_attr($roof_blog_columns); ?>">
					<?php
					if ( have_posts() ) :
						while ( have_posts() ) : the_post();
							get_template_part( 'layouts/post/content' );
						endwhile;
					else :
						get_template_part( 'layouts/post/content', 'none' );
					endif; ?>
				</div>
				<?php
					roof_paging_nav();
			    wp_reset_postdata();  // avoid errors further down the page
				?>
			</div><!-- Content Area -->

			<?php
				if ($roof_sidebar_position !== 'sidebar-hide') {
					get_sidebar();
				}
			?>

		</div>
	</div>
</div>

<?php
get_footer();
