<?php
/*
 * All Theme Options for Roof theme.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

function roof_vt_settings( $settings ) {

  $settings           = array(
    'menu_title'      => ROOF_NAME . esc_html__(' Options', 'roof'),
    'menu_slug'       => sanitize_title(ROOF_NAME) . '_options',
    'menu_type'       => 'menu',
    'menu_icon'       => 'dashicons-awards',
    'menu_position'   => '4',
    'ajax_save'       => false,
    'show_reset_all'  => true,
    'framework_title' => ROOF_NAME .' <small>V-'. ROOF_VERSION .' by <a href="'. ROOF_BRAND_URL .'" target="_blank">'. ROOF_BRAND_NAME .'</a></small>',
  );

  return $settings;

}
add_filter( 'cs_framework_settings', 'roof_vt_settings' );

// Theme Framework Options
function roof_vt_options( $options ) {

  $options      = array(); // remove old options

  // ------------------------------
  // Theme Brand
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_brand',
    'title'    => esc_html__('Brand', 'roof'),
    'icon'     => 'fa fa-bookmark',
    'sections' => array(

      // brand logo tab
      array(
        'name'     => 'brand_logo_title',
        'title'    => esc_html__('Logo', 'roof'),
        'icon'     => 'fa fa-star',
        'fields'   => array(

          // Site Logo
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Site Logo', 'roof')
          ),
          array(
            'id'    => 'brand_logo_default',
            'type'  => 'image',
            'title' => esc_html__('Default Logo', 'roof'),
            'info'  => esc_html__('Upload your default logo here. If you not upload, then site title will load in this logo location.', 'roof'),
            'add_title' => esc_html__('Add Logo', 'roof'),
          ),
          array(
            'id'    => 'brand_logo_retina',
            'type'  => 'image',
            'title' => esc_html__('Retina Logo', 'roof'),
            'info'  => esc_html__('Upload your retina logo here. Recommended size is 2x from default logo.', 'roof'),
            'add_title' => esc_html__('Add Retina Logo', 'roof'),
          ),
          array(
            'id'          => 'retina_width',
            'type'        => 'text',
            'title'       => esc_html__('Retina & Normal Logo Width', 'roof'),
            'unit'        => 'px',
          ),
          array(
            'id'          => 'retina_height',
            'type'        => 'text',
            'title'       => esc_html__('Retina & Normal Logo Height', 'roof'),
            'unit'        => 'px',
          ),
          array(
            'id'          => 'brand_logo_top',
            'type'        => 'number',
            'title'       => esc_html__('Logo Top Space', 'roof'),
            'attributes'  => array( 'placeholder' => 5 ),
            'unit'        => 'px',
          ),
          array(
            'id'          => 'brand_logo_bottom',
            'type'        => 'number',
            'title'       => esc_html__('Logo Bottom Space', 'roof'),
            'attributes'  => array( 'placeholder' => 5 ),
            'unit'        => 'px',
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Transparent Header', 'roof')
          ),
          array(
            'id'    => 'transparent_logo_default',
            'type'  => 'image',
            'title' => esc_html__('Transparent Logo', 'roof'),
            'info'  => esc_html__('Upload your transparent header logo here. This logo is used in transparent header by enabled in each pages.', 'roof'),
            'add_title' => esc_html__('Add Transparent Logo', 'roof'),
          ),
          array(
            'id'    => 'transparent_logo_retina',
            'type'  => 'image',
            'title' => esc_html__('Transparent Retina Logo', 'roof'),
            'info'  => esc_html__('Upload your transparent header retina logo here. This logo is used in transparent header by enabled in each pages.', 'roof'),
            'add_title' => esc_html__('Add Transparent Retina Logo', 'roof'),
          ),

          // WordPress Admin Logo
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('WordPress Admin Logo', 'roof')
          ),
          array(
            'id'    => 'brand_logo_wp',
            'type'  => 'image',
            'title' => esc_html__('Login logo', 'roof'),
            'info'  => esc_html__('Upload your WordPress login page logo here.', 'roof'),
            'add_title' => esc_html__('Add Login Logo', 'roof'),
          ),
        ) // end: fields
      ), // end: section

      // Fav
      array(
        'name'     => 'brand_fav',
        'title'    => esc_html__('Fav Icon', 'roof'),
        'icon'     => 'fa fa-anchor',
        'fields'   => array(

            // -----------------------------
            // Begin: Fav
            // -----------------------------
            array(
              'id'    => 'brand_fav_icon',
              'type'  => 'image',
              'title' => esc_html__('Fav Icon', 'roof'),
              'info'  => esc_html__('Upload your site fav icon, size should be 16x16.', 'roof'),
              'add_title' => esc_html__('Add Fav Icon', 'roof'),
            ),
            array(
              'id'    => 'iphone_icon',
              'type'  => 'image',
              'title' => esc_html__('Apple iPhone icon', 'roof'),
              'info'  => esc_html__('Icon for Apple iPhone (57px x 57px). This icon is used for Bookmark on Home screen.', 'roof'),
              'add_title' => esc_html__('Add iPhone Icon', 'roof'),
            ),
            array(
              'id'    => 'iphone_retina_icon',
              'type'  => 'image',
              'title' => esc_html__('Apple iPhone retina icon', 'roof'),
              'info'  => esc_html__('Icon for Apple iPhone retina (114px x114px). This icon is used for Bookmark on Home screen.', 'roof'),
              'add_title' => esc_html__('Add iPhone Retina Icon', 'roof'),
            ),
            array(
              'id'    => 'ipad_icon',
              'type'  => 'image',
              'title' => esc_html__('Apple iPad icon', 'roof'),
              'info'  => esc_html__('Icon for Apple iPad (72px x 72px). This icon is used for Bookmark on Home screen.', 'roof'),
              'add_title' => esc_html__('Add iPad Icon', 'roof'),
            ),
            array(
              'id'    => 'ipad_retina_icon',
              'type'  => 'image',
              'title' => esc_html__('Apple iPad retina icon', 'roof'),
              'info'  => esc_html__('Icon for Apple iPad retina (144px x 144px). This icon is used for Bookmark on Home screen.', 'roof'),
              'add_title' => esc_html__('Add iPad Retina Icon', 'roof'),
            ),

        ) // end: fields
      ), // end: section

    ),
  );

  // ------------------------------
  // Layout
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_layout',
    'title'  => esc_html__('Layout', 'roof'),
    'icon'   => 'fa fa-file-text'
  );

  $options[]      = array(
    'name'        => 'theme_general',
    'title'       => esc_html__('General', 'roof'),
    'icon'        => 'fa fa-wrench',

    // begin: fields
    'fields'      => array(

      // -----------------------------
      // Begin: Responsive
      // -----------------------------
      array(
        'id'    => 'theme_responsive',
        'type'  => 'switcher',
        'title' => esc_html__('Responsive', 'roof'),
        'info' => esc_html__('Turn off if you don\'t want your site to be responsive.', 'roof'),
        'default' => true,
      ),
      array(
        'id'    => 'theme_layout_width',
        'type'  => 'image_select',
        'title' => esc_html__('Full Width & Extra Width', 'roof'),
        'info' => esc_html__('Boxed or Fullwidth? Choose your site layout width. Default : Full Width', 'roof'),
        'options'      => array(
          'container'    => ROOF_CS_IMAGES .'/boxed-width.jpg',
          'container-fluid'    => ROOF_CS_IMAGES .'/full-width.jpg',
        ),
        'default'      => 'container-fluid',
        'radio'      => true,
      ),
      array(
        'id'    => 'theme_page_comments',
        'type'  => 'switcher',
        'title' => esc_html__('Page Comments', 'roof'),
        'info' => esc_html__('Turn On if you want to show comments in your pages.', 'roof'),
        'default' => true,
      ),
      array(
        'id'    => 'theme_mean_menu',
        'type'  => 'switcher',
        'title' => esc_html__('Disable Meanmenu', 'roof'),
        'info' => esc_html__('Turn On if you dont want to show meanmenu (mobile menu).', 'roof'),
        'default' => false,
      ),
      array(
        'id'    => 'disable_resizer',
        'type'  => 'switcher',
        'title' => esc_html__('Disable Image Resizer?', 'roof'),
        'info' => esc_html__('Turn on if you want to disable resizer for images.', 'roof'),
      ),

      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Background Options', 'roof'),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'             => 'theme_layout_bg_type',
        'type'           => 'select',
        'title'          => esc_html__('Background Type', 'roof'),
        'options'        => array(
          'bg-image' => esc_html__('Image', 'roof'),
          'bg-pattern' => esc_html__('Pattern', 'roof'),
        ),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'    => 'theme_layout_bg_pattern',
        'type'  => 'image_select',
        'title' => esc_html__('Background Pattern', 'roof'),
        'info' => esc_html__('Select background pattern', 'roof'),
        'options'      => array(
          'pattern-1'    => ROOF_CS_IMAGES . '/pattern-1.png',
          'pattern-2'    => ROOF_CS_IMAGES . '/pattern-2.png',
          'pattern-3'    => ROOF_CS_IMAGES . '/pattern-3.png',
          'pattern-4'    => ROOF_CS_IMAGES . '/pattern-4.png',
          'custom-pattern'  => ROOF_CS_IMAGES . '/pattern-5.png',
        ),
        'default'      => 'pattern-1',
        'radio'      => true,
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type', '==|==', 'true|bg-pattern' ),
      ),
      array(
        'id'      => 'custom_bg_pattern',
        'type'    => 'upload',
        'title'   => esc_html__('Custom Pattern', 'roof'),
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type|theme_layout_bg_pattern_custom-pattern', '==|==|==', 'true|bg-pattern|true' ),
        'info' => __('Select your custom background pattern. <br />Note, background pattern image will be repeat in all x and y axis. So, please consider all repeatable area will perfectly fit your custom patterns.', 'roof'),
      ),
      array(
        'id'      => 'theme_layout_bg',
        'type'    => 'background',
        'title'   => esc_html__('Background', 'roof'),
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type', '==|==', 'true|bg-image' ),
      ),
      array(
        'id'      => 'theme_bg_parallax',
        'type'    => 'switcher',
        'title'   => esc_html__('Parallax', 'roof'),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'      => 'theme_bg_parallax_speed',
        'type'    => 'text',
        'title'   => esc_html__('Parallax Speed', 'roof'),
        'attributes' => array(
          'placeholder'     => '0.4',
        ),
        'dependency' => array( 'theme_layout_width_container|theme_bg_parallax', '==|!=', 'true' ),
      ),
      array(
        'id'      => 'theme_bg_overlay_color',
        'type'    => 'color_picker',
        'title'   => esc_html__('Overlay Color', 'roof'),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),

    ), // end: fields

  );

  // ------------------------------
  // Header Sections
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_header_tab',
    'title'    => esc_html__('Header', 'roof'),
    'icon'     => 'fa fa-bars',
    'sections' => array(

      // header design tab
      array(
        'name'     => 'header_design_tab',
        'title'    => esc_html__('Design', 'roof'),
        'icon'     => 'fa fa-magic',
        'fields'   => array(

          // Header Select
          array(
            'id'           => 'select_header_design',
            'type'         => 'image_select',
            'title'        => esc_html__('Select Header Design', 'roof'),
            'options'      => array(
              'style_one'    => ROOF_CS_IMAGES .'/hs-1.png',
              'style_two'    => ROOF_CS_IMAGES .'/hs-2.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'header_design',
            ),
            'radio'        => true,
            'default'   => 'style_one',
            'info' => esc_html__('Select your header design, following options will may differ based on your selection of header design.', 'roof'),
          ),
          array(
            'id'    => 'menubar_width',
            'type'  => 'switcher',
            'title' => esc_html__('Full Width Menu-bar', 'roof'),
            'info' => esc_html__('Turn On if you want your Menu Bar as Fullwidth.', 'roof'),
            'default' => true,
            'dependency' => array('header_design', '==', 'style_one'),
          ),
          array(
            'id'              => 'header_address_info',
            'title'           => esc_html__('Header Content', 'roof'),
            'desc'            => esc_html__('Add your header content here. Example : Address Details', 'roof'),
            'type'            => 'textarea',
            'shortcode'       => true,
            'dependency' => array('header_design', '==', 'style_one'),
          ),
          array(
            'id'              => 'header_social_icons',
            'title'           => esc_html__('Header Social Icons', 'roof'),
            'desc'            => esc_html__('Add your header social icons here.', 'roof'),
            'type'            => 'textarea',
            'shortcode'       => true,
          ),
          array(
            'id'    => 'transparent_header_option',
            'type'  => 'switcher',
            'title' => esc_html__('Transparent Header', 'roof'),
            'info' => esc_html__('Turn On if you want your Header Bar as Transparent.', 'roof'),
            'default' => true,
            'dependency' => array('header_design', '==', 'style_two'),
          ),
          // Header Select

          // Extra's
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Extra\'s', 'roof'),
          ),
          array(
            'id'          => 'mobile_breakpoint',
            'type'        => 'text',
            'title'       => esc_html__('Mobile Menu Starts from?', 'roof'),
            'attributes'  => array( 'placeholder' => '767' ),
            'info' => esc_html__('Just put numeric value only. Like : 767. Don\'t use px or any other units.', 'roof'),
          ),
          array(
            'id'    => 'sticky_header',
            'type'  => 'switcher',
            'title' => esc_html__('Sticky Header', 'roof'),
            'info' => esc_html__('Turn On if you want your naviagtion bar on sticky.', 'roof'),
            'default' => true,
          ),
          array(
            'id'    => 'cart_widget',
            'type'  => 'switcher',
            'title' => esc_html__('Cart Widget', 'roof'),
            'info' => esc_html__('Turn On if you want to show cart widget in header. Make sure about installation/activation of WooCommerce plugin.', 'roof'),
            'default' => false,
            'dependency' => array('header_design', 'any', 'style_two,style_four'),
          ),

        )
      ),

      // header top bar
      array(
        'name'     => 'header_top_bar_tab',
        'title'    => esc_html__('Top Bar', 'roof'),
        'icon'     => 'fa fa-minus',
        'fields'   => array(

          array(
            'id'          => 'top_bar',
            'type'        => 'switcher',
            'title'       => esc_html__('Hide Top Bar', 'roof'),
            'on_text'     => esc_html__('Yes', 'roof'),
            'off_text'    => esc_html__('No', 'roof'),
            'default'     => false,
          ),
          array(
            'id'          => 'top_left',
            'title'       => esc_html__('Top Left Block', 'roof'),
            'desc'        => esc_html__('Top bar left block.', 'roof'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('top_bar', '==', false),
          ),
          array(
            'id'          => 'top_right',
            'title'       => esc_html__('Top Right Block', 'roof'),
            'desc'        => esc_html__('Top bar right block.', 'roof'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('top_bar', '==', false),
          ),

          array(
            'id'          => 'topbar_left_width',
            'type'        => 'text',
            'title'       => esc_html__('Top Left Width in %', 'roof'),
            'attributes'  => array(
              'placeholder' => '50%'
            ),
            'dependency'  => array('top_bar', '==', false),
          ),
          array(
            'id'          => 'topbar_right_width',
            'type'        => 'text',
            'title'       => esc_html__('Top Right Width in %', 'roof'),
            'attributes'  => array(
              'placeholder' => '50%'
            ),
            'dependency'  => array('top_bar', '==', false),
          ),

        )
      ),

      // header banner
      array(
        'name'     => 'header_banner_tab',
        'title'    => esc_html__('Title Bar (or) Banner', 'roof'),
        'icon'     => 'fa fa-bullhorn',
        'fields'   => array(

          // Title Area
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Title Area', 'roof')
          ),
          array(
            'id'      => 'need_title_bar',
            'type'    => 'switcher',
            'title'   => esc_html__('Title Bar', 'roof'),
            'label'   => esc_html__('If you want title bar in your sub-pages, please turn this ON.', 'roof'),
            'default'    => true,
          ),

          array(
            'id'             => 'title_bar_padding',
            'type'           => 'select',
            'title'          => esc_html__('Padding Spaces Top & Bottom', 'roof'),
            'options'        => array(
              'padding-none' => esc_html__('Default Spacing', 'roof'),
              'padding-xs' => esc_html__('Extra Small Padding', 'roof'),
              'padding-sm' => esc_html__('Small Padding', 'roof'),
              'padding-md' => esc_html__('Medium Padding', 'roof'),
              'padding-lg' => esc_html__('Large Padding', 'roof'),
              'padding-xl' => esc_html__('Extra Large Padding', 'roof'),
              'padding-no' => esc_html__('No Padding', 'roof'),
              'padding-custom' => esc_html__('Custom Padding', 'roof'),
            ),
            'dependency'   => array( 'need_title_bar', '==', 'true' ),
          ),
          array(
            'id'             => 'titlebar_top_padding',
            'type'           => 'text',
            'title'          => esc_html__('Padding Top', 'roof'),
            'attributes' => array(
              'placeholder'     => '100px',
            ),
            'dependency'   => array( 'title_bar_padding', '==', 'padding-custom' ),
          ),
          array(
            'id'             => 'titlebar_bottom_padding',
            'type'           => 'text',
            'title'          => esc_html__('Padding Bottom', 'roof'),
            'attributes' => array(
              'placeholder'     => '100px',
            ),
            'dependency'   => array( 'title_bar_padding', '==', 'padding-custom' ),
          ),
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Breadcrumbs', 'roof'),
            'dependency' => array( 'need_title_bar', '==', 'true' ),
          ),
          array(
            'id'      => 'need_breadcrumbs',
            'type'    => 'switcher',
            'title'   => esc_html__('Disable Breadcrumbs', 'roof'),
            'dependency' => array( 'need_title_bar', '==', 'true' ),
            'label'   => esc_html__('If you want to disable Breadcrumbs in your banner, please turn this ON.', 'roof'),
            'default'    => true,
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Background Options', 'roof'),
            'dependency' => array( 'need_title_bar', '==', 'true' ),
          ),
          array(
            'id'      => 'titlebar_bg',
            'type'    => 'background',
            'title'   => esc_html__('Background', 'roof'),
            'dependency' => array( 'need_title_bar', '==', 'true' ),
          ),
          array(
            'id'      => 'titlebar_bg_overlay_color',
            'type'    => 'color_picker',
            'title'   => esc_html__('Overlay Color', 'roof'),
            'dependency' => array( 'need_title_bar', '==', 'true' ),
          ),

        )
      ),

    ),
  );

  // ------------------------------
  // Footer Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'footer_section',
    'title'    => esc_html__('Footer', 'roof'),
    'icon'     => 'fa fa-ellipsis-h',
    'sections' => array(

      // footer widgets
      array(
        'name'     => 'footer_widgets_tab',
        'title'    => esc_html__('Widget Area', 'roof'),
        'icon'     => 'fa fa-th',
        'fields'   => array(

          // Footer Widget Block
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Footer Widget Block', 'roof')
          ),
          array(
            'id'    => 'footer_widget_block',
            'type'  => 'switcher',
            'title' => esc_html__('Enable Widget Block', 'roof'),
            'info' => __('If you turn this ON, then Goto : Appearance > Widgets. There you can see <strong>Footer Widget 1,2,3 or 4</strong> Widget Area, add your widgets there.', 'roof'),
            'default' => true,
          ),
          array(
            'id'    => 'footer_widget_layout',
            'type'  => 'image_select',
            'title' => esc_html__('Widget Layouts', 'roof'),
            'info' => esc_html__('Choose your footer widget layouts.', 'roof'),
            'default' => 4,
            'options' => array(
              1   => ROOF_CS_IMAGES . '/footer/footer-1.png',
              2   => ROOF_CS_IMAGES . '/footer/footer-2.png',
              3   => ROOF_CS_IMAGES . '/footer/footer-3.png',
              4   => ROOF_CS_IMAGES . '/footer/footer-4.png',
              5   => ROOF_CS_IMAGES . '/footer/footer-5.png',
              6   => ROOF_CS_IMAGES . '/footer/footer-6.png',
              7   => ROOF_CS_IMAGES . '/footer/footer-7.png',
              8   => ROOF_CS_IMAGES . '/footer/footer-8.png',
              9   => ROOF_CS_IMAGES . '/footer/footer-9.png',
            ),
            'radio'       => true,
            'dependency'  => array('footer_widget_block', '==', true),
          ),

        )
      ),

      // footer copyright
      array(
        'name'     => 'footer_copyright_tab',
        'title'    => esc_html__('Copyright Bar', 'roof'),
        'icon'     => 'fa fa-copyright',
        'fields'   => array(

          // Copyright
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Copyright Layout', 'roof'),
          ),
          array(
            'id'    => 'need_copyright',
            'type'  => 'switcher',
            'title' => esc_html__('Enable Copyright Section', 'roof'),
            'default' => true,
          ),
          array(
            'id'    => 'footer_copyright_layout',
            'type'  => 'image_select',
            'title' => esc_html__('Select Copyright Layout', 'roof'),
            'info' => esc_html__('In above image, blue box is copyright text and yellow box is secondary text.', 'roof'),
            'default'      => 'copyright-3',
            'options'      => array(
              'copyright-1'    => ROOF_CS_IMAGES .'/footer/copyright-1.png',
              'copyright-2'    => ROOF_CS_IMAGES .'/footer/copyright-2.png',
              'copyright-3'    => ROOF_CS_IMAGES .'/footer/copyright-3.png',
              ),
            'radio'        => true,
            'dependency'     => array('need_copyright', '==', true),
          ),
          array(
            'id'    => 'copyright_text',
            'type'  => 'textarea',
            'title' => esc_html__('Copyright Text', 'roof'),
            'shortcode' => true,
            'dependency' => array('need_copyright', '==', true),
            'after'       => 'Helpful shortcodes: [roof_current_year] [roof_home_url] or any shortcode.',
          ),

          // Copyright Another Text
          array(
            'type'    => 'notice',
            'class'   => 'warning cs-vt-heading',
            'content' => esc_html__('Copyright Secondary Text', 'roof'),
            'dependency'     => array('need_copyright', '==', true),
          ),
          array(
            'id'    => 'secondary_text',
            'type'  => 'textarea',
            'title' => esc_html__('Secondary Text', 'roof'),
            'shortcode' => true,
            'dependency' => array('need_copyright', '==', 'true'),
          ),

        )
      ),

    ),
  );

  // ------------------------------
  // Design
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_design',
    'title'  => esc_html__('Design', 'roof'),
    'icon'   => 'fa fa-magic'
  );

  // ------------------------------
  // color section
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_color_section',
    'title'    => esc_html__('Colors', 'roof'),
    'icon'     => 'fa fa-eyedropper',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Color Options', 'roof'),
      ),
      array(
        'type'    => 'subheading',
        'wrap_class' => 'color-tab-content',
        'content' => __('All color options are available in our theme customizer. The reason of we used customizer options for color section is because, you can choose each part of color from there and see the changes instantly using customizer.
          <br /><br />Highly customizable colors are in <strong>Appearance > Customize</strong>', 'roof'),
      ),

    ),
  );

  // ------------------------------
  // Typography section
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_typo_section',
    'title'    => esc_html__('Typography', 'roof'),
    'icon'     => 'fa fa-header',
    'fields' => array(

      // Start fields
      array(
        'id'                  => 'typography',
        'type'                => 'group',
        'fields'              => array(
          array(
            'id'              => 'title',
            'type'            => 'text',
            'title'           => esc_html__('Title', 'roof'),
          ),
          array(
            'id'              => 'selector',
            'type'            => 'textarea',
            'title'           => esc_html__('Selector', 'roof'),
            'info'           => __('Enter css selectors like : <strong>body, .custom-class</strong>', 'roof'),
          ),
          array(
            'id'              => 'font',
            'type'            => 'typography',
            'title'           => esc_html__('Font Family', 'roof'),
          ),
          array(
            'id'              => 'css',
            'type'            => 'textarea',
            'title'           => esc_html__('Custom CSS', 'roof'),
          ),
        ),
        'button_title'        => esc_html__('Add New Typography', 'roof'),
        'accordion_title'     => esc_html__('New Typography', 'roof'),
        'default'             => array(
          array(
            'title'           => esc_html__('Body Typography', 'roof'),
            'selector'        => 'p, .woocommerce ul.products li.product .price, .contact-item .contact-info span, input[type="text"], input[type="email"], input[type="password"], input[type="tel"], input[type="search"], input[type="date"], input[type="time"], input[type="datetime-local"], input[type="month"], input[type="url"], input[type="number"], textarea, select, .form-control, .progress-counter, .contact-item .contact-info span, .contact-item .contact-info p, .contact-item .contact-info p a, .work-info .work-category, .news-meta, .mate-designation, .emergency-number, .widget_tag_cloud a, .square-bullets, .plan-price, .post-info .post-time, .blog-links-wrap, .blog-meta, .roof-pagination, .roof-blog-tags ul li a, .roof-comments-area .roof-comments-meta .comments-date, .woocommerce ul.cart_list li a, .woocommerce ul.product_list_widget li a, .woocommerce ul.products li.product .price, .woocommerce nav.woocommerce-pagination ul, .woocommerce-product-rating .woocommerce-review-link, .product_meta, .woocommerce .cart_totals table.shop_table th, .woocommerce .cart_totals table.shop_table td, .woocommerce .cart_totals .shipping button[type="submit"], .roof-forms .lost-password, .roof-404-error .error-title, .roof-contact-wrap .contact-info ul, .roof-footer, .roof-copyright',
            'font'            => array(
              'family'        => 'Open Sans',
              'variant'       => 'regular',
            ),

          ),
          array(
            'title'           => esc_html__('Menu Typography', 'roof'),
            'selector'        => '.roof-menu .navbar-nav > li > a',
            'font'            => array(
              'family'        => 'Raleway',
              'variant'       => 'regular',
            ),

          ),
          array(
            'title'           => esc_html__('Sub Menu Typography', 'roof'),
            'selector'        => '.dropdown-menu',
            'font'            => array(
              'family'        => 'Raleway',
              'variant'       => 'regular',
            ),

          ),
          array(
            'title'           => esc_html__('Headings Typography', 'roof'),
            'selector'        => 'body, h1, h2, h3, h4, h5, h6, .roof-btn, input[type="submit"], blockquote p, .tooltip, .cpation-wrap p, .swiper-style-three .cpation-wrap .roof-btn, .roof-consult, .roof-consult p, #quote-carousel p, .certifications-style-two .section-title-wrap p, .testimonial-style-three .roof-carousel p, .post-info .post-title, .author-content .author-pro, .woocommerce-checkout form.woocomerce-form.woocommerce-form-login.login p:first-child, .estimation-item input[type="text"], .estimation-item input[type="email"], .estimation-item input[type="password"], .estimation-item input[type="tel"], .estimation-item input[type="search"], .estimation-item input[type="date"], .estimation-item input[type="time"], .estimation-item input[type="datetime-local"], .estimation-item input[type="month"], .estimation-item input[type="url"], .estimation-item input[type="number"], .estimation-item textarea, .estimation-item select, .estimation-item .form-control, .estimation-item.service .wpcf7-list-item-label, .roof-404-error form input[type="text"], .roof-footer h4, .panel-title button',
            'font'            => array(
              'family'        => 'Raleway',
              'variant'       => 'regular',
            ),
          ),
          array(
            'title'           => esc_html__('Top Bar Typography', 'roof'),
            'selector'        => '.roof-btn-big, .roof-top-bar, .link-info .roof-btn, .all-project .roof-btn, .roof-top-bar.top-bar-style-two, .roof-top-bar .dropdown-menu',
            'font'            => array(
              'family'        => 'Roboto',
              'variant'       => 'regular',
            ),
          ),
          // array(
          //   'title'           => esc_html__('Shortcode Elements Primary Font', 'roof'),
          //   'selector'        => '.roof-search-two input, .roof-search-three input, .btn-fourth, .roof-counter-two .counter-label, .roof-list-icon h5, .roof-testimonials-two .testi-client-info .testi-name, .roof-testimonials-two .testi-client-info .testi-pro, .roof-testimonials-three .testi-client-info .testi-name, .roof-testimonials-three .testi-client-info .testi-pro, .roof-testimonials-four .testi-client-info .testi-name, .roof-testimonials-four .testi-client-info .testi-pro, .roof-testimonials-five .testi-name, .roof-list-icon h5, .roof-comments-area .roof-comments-meta .comments-reply, .footer-nav-links, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button, .woocommerce #review_form #respond .form-submit input, .woocommerce .products li.product a.button, .woocommerce #review_form #respond input, .woocommerce #review_form #respond select, .woocommerce #review_form #respond textarea, .woocommerce form .form-row .input-text, .woocommerce-page form .form-row .input-text, .tooltip',
          //   'font'            => array(
          //     'family'        => 'Raleway',
          //     'variant'       => 'regular',
          //   ),
          // ),
          // array(
          //   'title'           => esc_html__('Shortcode Elements Secondary Font', 'roof'),
          //   'selector'        => '.nice-select, blockquote, .roof-link-arrow, input, select, textarea, .wpcf7 p, .roof-title-area .page-title, .roof-breadcrumbs ul, .roof-topbar-left, .roof-top-active, .roof-recent-blog .widget-bdate, .roof-topdd-content li a, .roof-list-three li, .roof-address-info, .roof-cta-one, .roof-cta-two, .roof-service-one .service-heading, .roof-service-one .services-read-more, .service-heading, .roof-service-five .service-heading, .roof-tab-links li a, .roof-counter-one, .roof-counter-two, .roof-panel-one .panel-default > .panel-heading, .roof-panel-two .panel-heading, .nav-tabs-two .nav-tabs > li > a, .testimonial-heading, .testi-client-info .testi-name, .roof-testimonials-three .testi-content p, .roof-team-member .team-content .team-name, .roof-team-member-two .team-content .team-name, .roof-team-member-two .team-content .view-profile, .roof-team-details .tm-name, .roof-history .bh-year, .roof-blog-one .bp-top-meta > div, .roof-blog-one .bp-heading, .roof-blog-one .bp-read-more, .roof-blog-one .bp-bottom-comments a, .featured-image.roof-theme-carousel .owl-controls, .bp-share > p, .bp-author-info .author-content .author-pro, .bp-author-info .author-content .author-name, .roof-comments-area .comments-title, .roof-comments-area .roof-comments-meta, .wp-pagenavi, .wp-link-pages, .roof-list-four li, .roof-map-address, .roof-get-quote .bgq-btn, .roof-widget .widget-title, .roof-blog-widget, .roof-sidebar .roof-widget.roof-recent-blog .widget-bdate, .roof-widget .mc4wp-form input[type="submit"], .roof-copyright, .woocommerce ul.products li.product .price, .woocommerce a.added_to_cart, .woocommerce #reviews #comments ol.commentlist li .comment-text p.meta, .woocommerce table.shop_table .cart_item td .amount, .woocommerce table.woocommerce-checkout-review-order-table tfoot td, .woocommerce ul.cart_list li a, .woocommerce ul.product_list_widget li a, .woocommerce ul.product_list_widget li .amount, .woocommerce .widget_price_filter .price_slider_amount, .woocommerce .woocommerce-result-count, .woocommerce-review-link, .woocommerce-cart .cart-collaterals .cart_totals table td, .woocommerce .widget_shopping_cart ul.product_list_widget li .amount, .woocommerce .widget_shopping_cart ul.product_list_widget li .quantity',
          //   'font'            => array(
          //     'family'        => 'Roboto Slab',
          //     'variant'       => 'regular',
          //   ),
          // ),
          array(
            'title'           => esc_html__('Example Usage', 'roof'),
            'selector'        => '.your-custom-class',
            'font'            => array(
              'family'        => 'Roboto Slab',
              'variant'       => 'regular',
            ),
          ),
        ),
      ),

      // Subset
      array(
        'id'                  => 'subsets',
        'type'                => 'select',
        'title'               => esc_html__('Subsets', 'roof'),
        'class'               => 'chosen',
        'options'             => array(
          'latin'             => 'latin',
          'latin-ext'         => 'latin-ext',
          'cyrillic'          => 'cyrillic',
          'cyrillic-ext'      => 'cyrillic-ext',
          'greek'             => 'greek',
          'greek-ext'         => 'greek-ext',
          'vietnamese'        => 'vietnamese',
          'devanagari'        => 'devanagari',
          'khmer'             => 'khmer',
        ),
        'attributes'         => array(
          'data-placeholder' => 'Subsets',
          'multiple'         => 'multiple',
          'style'            => 'width: 200px;'
        ),
        'default'             => array( 'latin' ),
      ),

      array(
        'id'                  => 'font_weight',
        'type'                => 'select',
        'title'               => esc_html__('Font Weights', 'roof'),
        'class'               => 'chosen',
        'options'             => array(
          '100'   => 'Thin 100',
          '100i'  => 'Thin 100 Italic',
          '200'   => 'Extra Light 200',
          '200i'  => 'Extra Light 200 Italic',
          '300'   => 'Light 300',
          '300i'  => 'Light 300 Italic',
          '400'   => 'Regular 400',
          '400i'  => 'Regular 400 Italic',
          '500'   => 'Medium 500',
          '500i'  => 'Medium 500 Italic',
          '600'   => 'Semi Bold 600',
          '600i'  => 'Semi Bold 600 Italic',
          '700'   => 'Bold 700',
          '700i'  => 'Bold 700 Italic',
          '800'   => 'Extra Bold 800',
          '800i'  => 'Extra Bold 800 Italic',
          '900'   => 'Black 900',
          '900i'  => 'Black 900 Italic',
        ),
        'attributes'         => array(
          'data-placeholder' => 'Font Weight',
          'multiple'         => 'multiple',
          'style'            => 'width: 200px;'
        ),
        'default'             => array( '400','700' ),
      ),

      // Custom Fonts Upload
      array(
        'id'                 => 'font_family',
        'type'               => 'group',
        'title'              => 'Upload Custom Fonts',
        'button_title'       => 'Add New Custom Font',
        'accordion_title'    => 'Adding New Font',
        'accordion'          => true,
        'desc'               => 'It is simple. Only add your custom fonts and click to save. After you can check "Font Family" selector. Do not forget to Save!',
        'fields'             => array(

          array(
            'id'             => 'name',
            'type'           => 'text',
            'title'          => 'Font-Family Name',
            'attributes'     => array(
              'placeholder'  => 'for eg. Arial'
            ),
          ),

          array(
            'id'             => 'ttf',
            'type'           => 'upload',
            'title'          => 'Upload .ttf <small><i>(optional)</i></small>',
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => 'Use this Font-Format',
              'button_title' => 'Upload <i>.ttf</i>',
            ),
          ),

          array(
            'id'             => 'eot',
            'type'           => 'upload',
            'title'          => 'Upload .eot <small><i>(optional)</i></small>',
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => 'Use this Font-Format',
              'button_title' => 'Upload <i>.eot</i>',
            ),
          ),

          array(
            'id'             => 'svg',
            'type'           => 'upload',
            'title'          => 'Upload .svg <small><i>(optional)</i></small>',
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => 'Use this Font-Format',
              'button_title' => 'Upload <i>.svg</i>',
            ),
          ),

          array(
            'id'             => 'otf',
            'type'           => 'upload',
            'title'          => 'Upload .otf <small><i>(optional)</i></small>',
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => 'Use this Font-Format',
              'button_title' => 'Upload <i>.otf</i>',
            ),
          ),

          array(
            'id'             => 'woff',
            'type'           => 'upload',
            'title'          => 'Upload .woff <small><i>(optional)</i></small>',
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => 'Use this Font-Format',
              'button_title' => 'Upload <i>.woff</i>',
            ),
          ),

          array(
            'id'             => 'css',
            'type'           => 'textarea',
            'title'          => 'Extra CSS Style <small><i>(optional)</i></small>',
            'attributes'     => array(
              'placeholder'  => 'for eg. font-weight: normal;'
            ),
          ),

        ),
      ),
      // End All field

    ),
  );

  // ------------------------------
  // Pages
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_pages',
    'title'  => esc_html__('Pages', 'roof'),
    'icon'   => 'fa fa-files-o'
  );

  // ------------------------------
  // Portfolio Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'portfolio_section',
    'title'    => esc_html__('Portfolio', 'roof'),
    'icon'     => 'fa fa-briefcase',
    'fields' => array(

      // portfolio name change
      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Name Change', 'roof')
      ),
      array(
        'id'      => 'theme_portfolio_name',
        'type'    => 'text',
        'title'   => esc_html__('Portfolio Name', 'roof'),
        'attributes'     => array(
          'placeholder'  => 'Portfolio'
        ),
      ),
      array(
        'id'      => 'theme_portfolio_slug',
        'type'    => 'text',
        'title'   => esc_html__('Portfolio Slug', 'roof'),
        'attributes'     => array(
          'placeholder'  => 'portfolio-item'
        ),
      ),
      array(
        'id'      => 'theme_portfolio_cat_slug',
        'type'    => 'text',
        'title'   => esc_html__('Portfolio Category Slug', 'roof'),
        'attributes'     => array(
          'placeholder'  => 'portfolio-category'
        ),
      ),
      array(
        'type'    => 'notice',
        'class'   => 'danger',
        'content' => __('<strong>Important</strong>: Please do not set portfolio slug and page slug as same. It\'ll not work.', 'roof')
      ),
      // Portfolio Name

      // portfolio listing
      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Portfolio Style', 'roof')
      ),
      array(
        'id'             => 'portfolio_style',
        'type'           => 'select',
        'title'          => esc_html__('Portfolio Style', 'roof'),
        'options'        => array(
          'one' => esc_html__('Style One', 'roof'),
          'two' => esc_html__('Style Two', 'roof'),
          'three' => esc_html__('Style Three', 'roof'),
        ),
        'default_option'     => esc_html__('Select Portfolio Style', 'roof'),
      ),
      array(
        'type' => 'select',
        'title' => __( 'Grid or Masonry', 'roof' ),
        'options'        => array(
          'grid' => esc_html__('Grid', 'roof'),
          'masonry' => esc_html__('Masonry', 'roof'),
        ),
        'dependency'   => array( 'portfolio_style', '==', 'two' ),
        'id' => 'portfolio_view',
        'info' => __( 'Select your portfolio style.', 'roof' ),
      ),
      array(
        'id'          => 'portfolio_order',
        'title'       => esc_html__('Portfolio Order', 'roof'),
        'desc'        => esc_html__('Select portfolio order', 'roof'),
        'type'        => 'select',
        'options'        => array(
          'ascending' => esc_html__('Ascending', 'roof'),
          'decending' => esc_html__('Decending', 'roof'),
        ),
      ),
      array(
        'id'          => 'portfolio_orderby',
        'title'       => esc_html__('Portfolio Orderby', 'roof'),
        'desc'        => esc_html__('Select portfolio orderby', 'roof'),
        'type'        => 'select',
        'options'        => array(
          'None' => esc_html__('None', 'roof'),
          'id' => esc_html__('ID', 'roof'),
          'author' => esc_html__('Author', 'roof'),
          'title' => esc_html__('Title', 'roof'),
          'name' => esc_html__('Name', 'roof'),
          'type' => esc_html__('Type', 'roof'),
          'date' => esc_html__('Date', 'roof'),
          'modified' => esc_html__('Modified', 'roof'),
          'random' => esc_html__('Random', 'roof'),
        ),
      ),
      array(
        'id'             => 'portfolio_column',
        'type'           => 'select',
        'title'          => esc_html__('Portfolio Column', 'roof'),
        'options'        => array(
          'bpw-col-2' => esc_html__('Two Columns', 'roof'),
          'bpw-col-3' => esc_html__('Three Columns', 'roof'),
          'bpw-col-4' => esc_html__('Four Columns', 'roof'),
          'bpw-col-5' => esc_html__('Five Columns', 'roof'),
        ),
        'dependency'   => array( 'portfolio_style', '==', 'three' ),
        'default_option'     => esc_html__('Select Portfolio Column', 'roof'),
      ),
      array(
        'id'      => 'portfolio_read_more_txt',
        'type'    => 'text',
        'title'   => esc_html__('Portfolio Read More Button Text', 'roof'),
        'dependency'   => array( 'portfolio_style', '!=', 'three' ),
        'attributes'     => array(
          'placeholder'  => 'Button text'
        ),
      ),

      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Enable/Disable Options', 'roof')
      ),
      array(
        'id'      => 'portfolio_pagination',
        'type'    => 'switcher',
        'title'   => esc_html__('Pagination', 'roof'),
        'label'   => esc_html__('If you need pagination in portfolio pages, please turn this ON.', 'roof'),
        'default'   => true,
      ),
      array(
        "type"        =>'text',
        "title"     =>__('Limit', 'roof'),
        "id"  => "portfolio_limit",
        "info" => __( "Enter the number of items to show.", 'roof'),
      ),

      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Single Portfolio', 'roof')
      ),
      array(
        'id'      => 'portfolio_single_pagination',
        'type'    => 'switcher',
        'title'   => esc_html__('Next & Prev Navigation', 'roof'),
        'label'   => esc_html__('If you don\'t want next and previous navigation in portfolio single pages, please turn this OFF.', 'roof'),
        'default'   => true,
      ),
      // Portfolio Listing

    ),
  );

  // ------------------------------
  // Team Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'team_section',
    'title'    => esc_html__('Team', 'roof'),
    'icon'     => 'fa fa-users',
    'fields' => array(

      // Team Start
      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Team Single', 'roof')
      ),
      array(
        'id'      => 'team_top_spacing',
        'type'    => 'text',
        'title'   => esc_html__('Top Spacing', 'roof'),
        'info'   => esc_html__('Enter value in px, for team single pages top value.', 'roof'),
        'default' => '60px',
      ),
      array(
        'id'      => 'team_bottom_spacing',
        'type'    => 'text',
        'title'   => esc_html__('Bottom Spacing', 'roof'),
        'info'   => esc_html__('Enter value in px, for team single pages bottom value.', 'roof'),
        'default' => '0px',
      ),
      // Team End

    ),
  );

  // ------------------------------
  // Blog Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'blog_section',
    'title'    => esc_html__('Blog', 'roof'),
    'icon'     => 'fa fa-edit',
    'sections' => array(

      // blog general section
      array(
        'name'     => 'blog_general_tab',
        'title'    => esc_html__('General', 'roof'),
        'icon'     => 'fa fa-cog',
        'fields'   => array(

          // Layout
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Layout', 'roof')
          ),
          array(
            'id'             => 'blog_listing_style',
            'type'           => 'select',
            'title'          => esc_html__('Blog Listing Style', 'roof'),
            'options'        => array(
              'style-one' => esc_html__('List (Default)', 'roof'),
              'style-two' => esc_html__('Grid', 'roof'),
              'style-three' => esc_html__('Grid Simple', 'roof'),
            ),
            'default_option' => 'Select blog style',
            'help'          => esc_html__('This style will apply, default blog pages - Like : Archive, Category, Tags, Search & Author. If this settings will not apply your blog page, please set that page as a post page in Settings > Readings.', 'roof'),
          ),
          array(
            'id'             => 'blog_listing_columns',
            'type'           => 'select',
            'title'          => esc_html__('Blog Listing Columns', 'roof'),
            'options'        => array(
              'roof-blog-col-1' => esc_html__('Column One', 'roof'),
              'roof-blog-col-2' => esc_html__('Column Two', 'roof'),
              'roof-blog-col-3' => esc_html__('Column Three', 'roof'),
              'roof-blog-col-4' => esc_html__('Column Four', 'roof'),
            ),
            'default_option' => 'Select blog column',
            'dependency'     => array('blog_listing_style', 'any', 'style-two,style-three'),
          ),
          array(
            'id'             => 'blog_sidebar_position',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Position', 'roof'),
            'options'        => array(
              'sidebar-right' => esc_html__('Right', 'roof'),
              'sidebar-left' => esc_html__('Left', 'roof'),
              'sidebar-hide' => esc_html__('Hide', 'roof'),
            ),
            'default_option' => 'Select sidebar position',
            'help'          => esc_html__('This style will apply, default blog pages - Like : Archive, Category, Tags, Search & Author.', 'roof'),
            'info'          => esc_html__('Default option : Right', 'roof'),
          ),
          array(
            'id'             => 'blog_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'roof'),
            'options'        => roof_vt_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'roof'),
            'dependency'     => array('blog_sidebar_position', '!=', 'sidebar-hide'),
            'info'          => esc_html__('Default option : Main Widget Area', 'roof'),
          ),
          // Layout
          // Global Options
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Global Options', 'roof')
          ),
          array(
            'id'         => 'theme_exclude_categories',
            'type'       => 'checkbox',
            'title'      => esc_html__('Exclude Categories', 'roof'),
            'info'      => esc_html__('Select categories you want to exclude from blog page.', 'roof'),
            'options'    => 'categories',
          ),
          array(
            'id'      => 'theme_blog_excerpt',
            'type'    => 'text',
            'title'   => esc_html__('Excerpt Length', 'roof'),
            'info'   => esc_html__('Blog short content length, in blog listing pages.', 'roof'),
            'default' => '55',
          ),
          array(
            'id'             => 'blog_share_expand',
            'type'           => 'select',
            'title'          => esc_html__('Social Share Expand Position', 'roof'),
            'options'        => array(
              'open-bottom' => esc_html__('Bottom', 'roof'),
              'open-right' => esc_html__('Right', 'roof'),
            ),
            'default_option' => 'Select Share Expand Position',
            'help'          => esc_html__('This style will apply, default blog pages - Like : Archive, Category, Tags, Search & Author.', 'roof'),
            'info'          => esc_html__('Default option : Bottom', 'roof'),
            'default'       => 'open-right',
          ),
          array(
            'id'      => 'theme_metas_hide',
            'type'    => 'checkbox',
            'title'   => esc_html__('Meta\'s to hide', 'roof'),
            'info'    => esc_html__('Check items you want to hide from blog/post meta field.', 'roof'),
            'class'      => 'horizontal',
            'options'    => array(
              'category'   => esc_html__('Category', 'roof'),
              'date'    => esc_html__('Date', 'roof'),
              'author'     => esc_html__('Author', 'roof'),
              'comments'      => esc_html__('Comments', 'roof'),
              'share'      => esc_html__('Share', 'roof'),
            ),
            // 'default' => '30',
          ),
          // End fields

        )
      ),

      // blog single section
      array(
        'name'     => 'blog_single_tab',
        'title'    => esc_html__('Single', 'roof'),
        'icon'     => 'fa fa-sticky-note',
        'fields'   => array(

          // Start fields
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Enable / Disable', 'roof')
          ),
          array(
            'id'    => 'single_featured_image',
            'type'  => 'switcher',
            'title' => esc_html__('Featured Image', 'roof'),
            'info' => esc_html__('If need to hide featured image from single blog post page, please turn this OFF.', 'roof'),
            'default' => true,
          ),
          array(
            'id'    => 'single_author_info',
            'type'  => 'switcher',
            'title' => esc_html__('Author Info', 'roof'),
            'info' => esc_html__('If need to hide author info on single blog page, please turn this OFF.', 'roof'),
            'default' => true,
          ),
          array(
            'id'    => 'single_share_option',
            'type'  => 'switcher',
            'title' => esc_html__('Share Option', 'roof'),
            'info' => esc_html__('If need to hide share option on single blog page, please turn this OFF.', 'roof'),
            'default' => true,
          ),
          array(
            'id'    => 'single_comment_form',
            'type'  => 'switcher',
            'title' => esc_html__('Comment Area/Form', 'roof'),
            'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this OFF.', 'roof'),
            'default' => true,
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Sidebar', 'roof')
          ),
          array(
            'id'             => 'single_sidebar_position',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Position', 'roof'),
            'options'        => array(
              'sidebar-right' => esc_html__('Right', 'roof'),
              'sidebar-left' => esc_html__('Left', 'roof'),
              'sidebar-hide' => esc_html__('Hide', 'roof'),
            ),
            'default_option' => 'Select sidebar position',
            'info'          => esc_html__('Default option : Right', 'roof'),
          ),
          array(
            'id'             => 'single_blog_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'roof'),
            'options'        => roof_vt_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'roof'),
            'dependency'     => array('single_sidebar_position', '!=', 'sidebar-hide'),
            'info'          => esc_html__('Default option : Main Widget Area', 'roof'),
          ),
          // End fields

        )
      ),

    ),
  );

if (class_exists( 'WooCommerce' )){
  // ------------------------------
  // WooCommerce Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'woocommerce_section',
    'title'    => esc_html__('WooCommerce', 'roof'),
    'icon'     => 'fa fa-shopping-cart',
    'fields' => array(

      // Start fields
      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Layout', 'roof')
      ),
      array(
        'id'             => 'woo_product_columns',
        'type'           => 'select',
        'title'          => esc_html__('Product Column', 'roof'),
        'options'        => array(
          3 => esc_html__('Three Column', 'roof'),
          4 => esc_html__('Four Column', 'roof'),
        ),
        'default_option' => esc_html__('Select Product Columns', 'roof'),
        'help'          => esc_html__('This style will apply, default woocommerce listings pages. Like, shop and archive pages.', 'roof'),
      ),
      array(
        'id'             => 'woo_sidebar_position',
        'type'           => 'select',
        'title'          => esc_html__('Sidebar Position', 'roof'),
        'options'        => array(
          'right-sidebar' => esc_html__('Right', 'roof'),
          'left-sidebar' => esc_html__('Left', 'roof'),
          'sidebar-hide' => esc_html__('Hide', 'roof'),
        ),
        'default_option' => esc_html__('Select sidebar position', 'roof'),
        'info'          => esc_html__('Default option : Right', 'roof'),
      ),
      array(
        'id'             => 'woo_widget',
        'type'           => 'select',
        'title'          => esc_html__('Sidebar Widget', 'roof'),
        'options'        => roof_vt_registered_sidebars(),
        'default_option' => esc_html__('Select Widget', 'roof'),
        'dependency'     => array('woo_sidebar_position', '!=', 'sidebar-hide'),
        'info'          => esc_html__('Default option : Shop Page', 'roof'),
      ),

      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Listing', 'roof')
      ),
      array(
        'id'      => 'theme_woo_limit',
        'type'    => 'text',
        'title'   => esc_html__('Product Limit', 'roof'),
        'info'   => esc_html__('Enter the number value for per page products limit.', 'roof'),
      ),
      // End fields

      // Start fields
      array(
        'type'    => 'notice',
        'class'   => 'info cs-vt-heading',
        'content' => esc_html__('Single Product', 'roof')
      ),
      array(
        'id'             => 'woo_related_limit',
        'type'           => 'text',
        'title'          => esc_html__('Related Products Limit', 'roof'),
      ),
      array(
        'id'    => 'woo_single_upsell',
        'type'  => 'switcher',
        'title' => esc_html__('You May Also Like', 'roof'),
        'info' => esc_html__('If you don\'t want \'You May Also Like\' products in single product page, please turn this ON.', 'roof'),
        'default' => false,
      ),
      array(
        'id'    => 'woo_single_related',
        'type'  => 'switcher',
        'title' => esc_html__('Related Products', 'roof'),
        'info' => esc_html__('If you don\'t want \'Related Products\' in single product page, please turn this ON.', 'roof'),
        'default' => false,
      ),
      // End fields

    ),
  );
}

  // ------------------------------
  // Extra Pages
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_extra_pages',
    'title'    => esc_html__('Extra Pages', 'roof'),
    'icon'     => 'fa fa-clone',
    'sections' => array(

      // error 404 page
      array(
        'name'     => 'error_page_section',
        'title'    => esc_html__('404 Page', 'roof'),
        'icon'     => 'fa fa-exclamation-triangle',
        'fields'   => array(

          // Start 404 Page
          array(
            'id'    => 'error_heading',
            'type'  => 'text',
            'title' => esc_html__('404 Page Heading', 'roof'),
            'info'  => esc_html__('Enter 404 page heading.', 'roof'),
          ),
          array(
            'id'    => 'error_page_content',
            'type'  => 'textarea',
            'title' => esc_html__('404 Page Content', 'roof'),
            'info'  => esc_html__('Enter 404 page content.', 'roof'),
            'shortcode' => true,
          ),
          // End 404 Page

        ) // end: fields
      ), // end: fields section

      // maintenance mode page
      array(
        'name'     => 'maintenance_mode_section',
        'title'    => esc_html__('Maintenance Mode', 'roof'),
        'icon'     => 'fa fa-hourglass-half',
        'fields'   => array(

          // Start Maintenance Mode
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => __('If you turn this ON : Only Logged in users will see your pages. All other visiters will see, selected page of : <strong>Maintenance Mode Page</strong>', 'roof')
          ),
          array(
            'id'             => 'enable_maintenance_mode',
            'type'           => 'switcher',
            'title'          => esc_html__('Maintenance Mode', 'roof'),
            'default'        => false,
          ),
          array(
            'id'             => 'maintenance_mode_page',
            'type'           => 'select',
            'title'          => esc_html__('Maintenance Mode Page', 'roof'),
            'options'        => 'pages',
            'default_option' => esc_html__('Select a page', 'roof'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          array(
            'id'             => 'maintenance_mode_bg',
            'type'           => 'background',
            'title'          => esc_html__('Page Background', 'roof'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          // End Maintenance Mode

        ) // end: fields
      ), // end: fields section

    )
  );

  // ------------------------------
  // Advanced
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_advanced',
    'title'  => esc_html__('Advanced', 'roof'),
    'icon'   => 'fa fa-cog'
  );

  // ------------------------------
  // Misc Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'misc_section',
    'title'    => esc_html__('Misc', 'roof'),
    'icon'     => 'fa fa-recycle',
    'sections' => array(

      // custom sidebar section
      array(
        'name'     => 'custom_sidebar_section',
        'title'    => esc_html__('Custom Sidebar', 'roof'),
        'icon'     => 'fa fa-reorder',
        'fields'   => array(

          // start fields
          array(
            'id'              => 'custom_sidebar',
            'title'           => esc_html__('Sidebars', 'roof'),
            'desc'            => esc_html__('Go to Appearance -> Widgets after create sidebars', 'roof'),
            'type'            => 'group',
            'fields'          => array(
              array(
                'id'          => 'sidebar_name',
                'type'        => 'text',
                'title'       => esc_html__('Sidebar Name', 'roof'),
              ),
              array(
                'id'          => 'sidebar_desc',
                'type'        => 'text',
                'title'       => esc_html__('Custom Description', 'roof'),
              )
            ),
            'accordion'       => true,
            'button_title'    => esc_html__('Add New Sidebar', 'roof'),
            'accordion_title' => esc_html__('New Sidebar', 'roof'),
              'default'             => array(
              array(
                'sidebar_name'          => 'About Sidebar',
                'sidebar_desc'        => 'Widget to show about page sidebar',
              ),
              array(
                'sidebar_name'          => 'Services Sidebar',
                'sidebar_desc'        => 'Widget to show services page sidebar',
              ),
              )
          ),
          // end fields

        )
      ),
      // custom sidebar section

      // Custom CSS/JS
      array(
        'name'        => 'custom_css_js_section',
        'title'       => esc_html__('Custom Codes', 'roof'),
        'icon'        => 'fa fa-code',

        // begin: fields
        'fields'      => array(

          // Start Custom CSS/JS
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Custom CSS', 'roof')
          ),
          array(
            'id'             => 'theme_custom_css',
            'type'           => 'textarea',
            'attributes' => array(
              'rows'     => 10,
              'placeholder'     => esc_html__('Enter your CSS code here...', 'roof'),
            ),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Custom JS', 'roof')
          ),
          array(
            'id'             => 'theme_custom_js',
            'type'           => 'textarea',
            'attributes' => array(
              'rows'     => 10,
              'placeholder'     => esc_html__('Enter your JS code here...', 'roof'),
            ),
          ),
          // End Custom CSS/JS

        ) // end: fields
      ),

      // Translation
      array(
        'name'        => 'theme_translation_section',
        'title'       => esc_html__('Translation', 'roof'),
        'icon'        => 'fa fa-language',

        // begin: fields
        'fields'      => array(

          // Start Translation
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Common Texts', 'roof')
          ),
          array(
            'id'          => 'read_more_text',
            'type'        => 'text',
            'title'       => esc_html__('Read More Text', 'roof'),
          ),
          array(
            'id'          => 'view_more_text',
            'type'        => 'text',
            'title'       => esc_html__('View More Text', 'roof'),
          ),
          array(
            'id'          => 'share_text',
            'type'        => 'text',
            'title'       => esc_html__('Share Text', 'roof'),
          ),
          array(
            'id'          => 'tags_text',
            'type'        => 'text',
            'title'       => esc_html__('Tags Text', 'roof'),
          ),
          array(
            'id'          => 'share_on_text',
            'type'        => 'text',
            'title'       => esc_html__('Share On Tooltip Text', 'roof'),
          ),
          array(
            'id'          => 'author_text',
            'type'        => 'text',
            'title'       => esc_html__('Author Text', 'roof'),
          ),
          array(
            'id'          => 'posted_by_text',
            'type'        => 'text',
            'title'       => esc_html__('Posted by Text', 'roof'),
          ),
          array(
            'id'          => 'post_comment_text',
            'type'        => 'text',
            'title'       => esc_html__('Post Comment Text [Submit Button]', 'roof'),
          ),
          array(
            'id'          => 'allproject_text',
            'type'        => 'text',
            'title'       => esc_html__('All Projects - Portfolio', 'roof'),
          ),
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('WooCommerce', 'roof')
          ),
          array(
            'id'          => 'add_to_cart_text',
            'type'        => 'text',
            'title'       => esc_html__('Add to Cart Text', 'roof'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Single Portfolio Pagination', 'roof')
          ),
          array(
            'id'          => 'prev_port',
            'type'        => 'text',
            'title'       => esc_html__('Prev Project Text', 'roof'),
          ),
          array(
            'id'          => 'next_port',
            'type'        => 'text',
            'title'       => esc_html__('Next Project Text', 'roof'),
          ),
          // End Translation

        ) // end: fields
      ),

    ),
  );

  // ------------------------------
  // backup                       -
  // ------------------------------
  $options[]   = array(
    'name'     => 'backup_section',
    'title'    => 'Backup',
    'icon'     => 'fa fa-shield',
    'fields'   => array(

      array(
        'type'    => 'notice',
        'class'   => 'warning',
        'content' => 'You can save your current options. Download a Backup and Import.',
      ),

      array(
        'type'    => 'backup',
      ),

    )
  );

  return $options;

}
add_filter( 'cs_framework_options', 'roof_vt_options' );