<?php
/*
 * All Metabox related options for Roof theme.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

function roof_vt_metabox_options( $options ) {

  $options      = array();

  // -----------------------------------------
  // Portfolio Metabox Options                    -
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'portfolio_type_metabox',
    'title'     => esc_html__('Portfolio Section', 'roof'),
    'post_type' => 'portfolio',
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(

      // Title Section
      array(
        'name'   => 'masonry_view_section',
        'fields' => array(

          array(
            'id'    => 'disable_gallery_featured',
            'type'  => 'switcher',
            'title' => esc_html__('Disable featured image & Gallery in Frontend', 'roof'),
          ),

          array(
            'type' => 'select',
            'title' => esc_html__( 'Portfolio Masonry Image Size', 'roof' ),
            'options' => array(
              'default'     => 'Default',
              '2x-width'      => '2X Width',
              '2x-width-height' => '2X Width & Height',
            ),
            'id' => 'masonry_img_size',
            'info' => esc_html__( 'Select your masonry image size.', 'roof' ),
          ),
          array(
            'id'    => 'include_gallery',
            'type'  => 'switcher',
            'title' => esc_html__('Include Gallery Images', 'roof'),
          ),
          array(
            'id'          => 'gallery_portfolio',
            'type'        => 'gallery',
            'title'       => esc_html__('Add Gallery', 'roof'),
            'add_title'   => esc_html__('Add Image(s)', 'roof'),
            'edit_title'  => esc_html__('Edit Image(s)', 'roof'),
            'clear_title' => esc_html__('Clear Image(s)', 'roof'),
            'dependency' => array('include_gallery', '==', true),
          ),

        ), // End : Fields

      ),
  ),
);

  // -----------------------------------------
  // Page Metabox Options                    -
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'page_type_metabox',
    'title'     => esc_html__('Page Custom Options', 'roof'),
    'post_type' => array('post', 'page', 'portfolio', 'product', 'team'),
    'context'   => 'normal',
    'priority'  => 'default',
    'sections'  => array(

      // Title Section
      array(
        'name'  => 'page_topbar_section',
        'title' => esc_html__('Top Bar', 'roof'),
        'icon'  => 'fa fa-minus',

        // Fields Start
        'fields' => array(

          array(
            'id'           => 'topbar_options',
            'type'         => 'image_select',
            'title'        => esc_html__('Topbar', 'roof'),
            'options'      => array(
              'default'     => ROOF_CS_IMAGES .'/topbar-default.png',
              'custom'      => ROOF_CS_IMAGES .'/topbar-custom.png',
              'hide_topbar' => ROOF_CS_IMAGES .'/topbar-hide.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'hide_topbar_select',
            ),
            'radio'     => true,
            'default'   => 'default',
          ),
          array(
            'id'          => 'top_left',
            'type'        => 'textarea',
            'title'       => esc_html__('Top Left', 'roof'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
            'shortcode'       => true,
          ),
          array(
            'id'          => 'top_right',
            'type'        => 'textarea',
            'title'       => esc_html__('Top Right', 'roof'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
            'shortcode'       => true,
          ),
          array(
            'id'         => 'topbar_left_width',
            'type'       => 'text',
            'title'      => esc_html__('Top Left Width in %', 'roof'),
            'attributes' => array(
              'placeholder' => '50%'
            ),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
          ),
          array(
            'id'         => 'topbar_right_width',
            'type'       => 'text',
            'title'      => esc_html__('Top Right Width in %', 'roof'),
            'attributes' => array(
              'placeholder' => '50%'
            ),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
          ),
          array(
            'id'    => 'topbar_bg',
            'type'  => 'color_picker',
            'title' => esc_html__('Topbar Background Color', 'roof'),
            'dependency'  => array('hide_topbar_select', '==', 'custom'),
          ),

        ), // End : Fields

      ), // Title Section

      // Header
      array(
        'name'  => 'header_section',
        'title' => esc_html__('Header', 'roof'),
        'icon'  => 'fa fa-bars',
        'fields' => array(

          array(
            'id'           => 'select_header_design',
            'type'         => 'image_select',
            'title'        => esc_html__('Select Header Design', 'roof'),
            'options'      => array(
              'default'     => ROOF_CS_IMAGES .'/hs-0.png',
              'style_one'   => ROOF_CS_IMAGES .'/hs-1.png',
              'style_two'   => ROOF_CS_IMAGES .'/hs-2.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'header_design',
            ),
            'radio'     => true,
            'default'   => 'default',
            'info'      => esc_html__('Select your header design, following options will may differ based on your selection of header design.', 'roof'),
          ),
          array(
            'id'              => 'header_address_info',
            'title'           => esc_html__('Header Content', 'roof'),
            'desc'            => esc_html__('Add your header content here. Example : Address Details', 'roof'),
            'type'            => 'textarea',
            'shortcode'       => true,
            'dependency' => array('header_design', '==', 'style_one'),
          ),
          array(
            'id'              => 'header_social_icons',
            'title'           => esc_html__('Header Social Icons', 'roof'),
            'desc'            => esc_html__('Add your header social icons here.', 'roof'),
            'type'            => 'textarea',
            'shortcode'       => true,
          ),

          array(
            'id'    => 'transparency_header',
            'type'  => 'switcher',
            'title' => esc_html__('Transparent Header', 'roof'),
            'info' => esc_html__('Use Transparent Method', 'roof'),
            'dependency' => array('header_design', '==', 'style_two'),
          ),
          array(
            'id'    => 'menubar_width',
            'type'  => 'switcher',
            'title' => esc_html__('Full Width Menu-bar', 'roof'),
            'info' => esc_html__('Turn On if you want your Menu Bar as Fullwidth.', 'roof'),
            'default' => true,
            'dependency' => array('header_design', '==', 'style_one'),
          ),
          array(
            'id'    => 'transparent_menu_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Menu Color', 'roof'),
            'info' => esc_html__('Pick your menu color. This color will only apply for non-sticky header mode.', 'roof'),
            'dependency'   => array('transparency_header', '==', 'true'),
          ),
          array(
            'id'    => 'transparent_menu_hover_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Menu Hover Color', 'roof'),
            'info' => esc_html__('Pick your menu hover color. This color will only apply for non-sticky header mode.', 'roof'),
            'dependency'   => array('transparency_header', '==', 'true'),
          ),
          array(
            'id'             => 'choose_menu',
            'type'           => 'select',
            'title'          => esc_html__('Choose Menu', 'roof'),
            'desc'          => esc_html__('Choose custom menus for this page.', 'roof'),
            'options'        => 'menus',
            'default_option' => esc_html__('Select your menu', 'roof'),
          ),

          // Enable & Disable
          array(
            'type'    => 'notice',
            'class'   => 'info cs-vt-heading',
            'content' => esc_html__('Enable & Disable', 'roof'),
            'dependency' => array('header_design', '!=', 'default'),
          ),
          array(
            'id'    => 'sticky_header',
            'type'  => 'switcher',
            'title' => esc_html__('Sticky Header', 'roof'),
            'info' => esc_html__('Turn On if you want your naviagtion bar on sticky.', 'roof'),
            'default' => true,
            'dependency' => array('header_design', '!=', 'default'),
          ),
        ),
      ),
      // Header

      // Banner & Title Area
      array(
        'name'  => 'banner_title_section',
        'title' => esc_html__('Banner & Title Area', 'roof'),
        'icon'  => 'fa fa-bullhorn',
        'fields' => array(

          array(
            'id'        => 'banner_type',
            'type'      => 'select',
            'title'     => esc_html__('Choose Banner Type', 'roof'),
            'options'   => array(
              'default-title'    => 'Default Title',
              'revolution-slider' => 'Shortcode [Rev Slider]',
              'hide-title-area'   => 'Hide Title/Banner Area',
            ),
          ),
          array(
            'id'    => 'page_revslider',
            'type'  => 'textarea',
            'title' => esc_html__('Revolution Slider or Any Shortcodes', 'roof'),
            'desc' => esc_html__('Enter any shortcodes that you want to show in this page title area. <br />Eg : Revolution Slider shortcode.', 'roof'),
            'attributes' => array(
              'placeholder' => esc_html__('Enter your shortcode...', 'roof'),
            ),
            'dependency'   => array('banner_type', '==', 'revolution-slider'),
          ),
          array(
            'id'    => 'page_custom_title',
            'type'  => 'text',
            'title' => esc_html__('Custom Title', 'roof'),
            'attributes' => array(
              'placeholder' => esc_html__('Enter your custom title...', 'roof'),
            ),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'        => 'title_area_spacings',
            'type'      => 'select',
            'title'     => esc_html__('Title Area Spacings', 'roof'),
            'options'   => array(
              'padding-none' => esc_html__('Default Spacing', 'roof'),
              'padding-xs' => esc_html__('Extra Small Padding', 'roof'),
              'padding-sm' => esc_html__('Small Padding', 'roof'),
              'padding-md' => esc_html__('Medium Padding', 'roof'),
              'padding-lg' => esc_html__('Large Padding', 'roof'),
              'padding-xl' => esc_html__('Extra Large Padding', 'roof'),
              'padding-no' => esc_html__('No Padding', 'roof'),
              'padding-custom' => esc_html__('Custom Padding', 'roof'),
            ),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'    => 'title_top_spacings',
            'type'  => 'text',
            'title' => esc_html__('Top Spacing', 'roof'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('banner_type|title_area_spacings', '==|==', 'default-title|padding-custom'),
          ),
          array(
            'id'    => 'title_bottom_spacings',
            'type'  => 'text',
            'title' => esc_html__('Bottom Spacing', 'roof'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('banner_type|title_area_spacings', '==|==', 'default-title|padding-custom'),
          ),
          array(
            'id'    => 'title_area_bg',
            'type'  => 'background',
            'title' => esc_html__('Background', 'roof'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),
          array(
            'id'    => 'titlebar_bg_overlay_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Overlay Color', 'roof'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),

        ),
      ),
      // Banner & Title Area

      // Content Section
      array(
        'name'  => 'page_content_options',
        'title' => esc_html__('Content Options', 'roof'),
        'icon'  => 'fa fa-file',

        'fields' => array(

          array(
            'id'        => 'content_spacings',
            'type'      => 'select',
            'title'     => esc_html__('Content Spacings', 'roof'),
            'options'   => array(
              'padding-none' => esc_html__('Default Spacing', 'roof'),
              'padding-xs' => esc_html__('Extra Small Padding', 'roof'),
              'padding-sm' => esc_html__('Small Padding', 'roof'),
              'padding-md' => esc_html__('Medium Padding', 'roof'),
              'padding-lg' => esc_html__('Large Padding', 'roof'),
              'padding-xl' => esc_html__('Extra Large Padding', 'roof'),
              'padding-cnt-no' => esc_html__('No Padding', 'roof'),
              'padding-custom' => esc_html__('Custom Padding', 'roof'),
            ),
            'desc' => esc_html__('Content area top and bottom spacings.', 'roof'),
          ),
          array(
            'id'    => 'content_top_spacings',
            'type'  => 'text',
            'title' => esc_html__('Top Spacing', 'roof'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('content_spacings', '==', 'padding-custom'),
          ),
          array(
            'id'    => 'content_bottom_spacings',
            'type'  => 'text',
            'title' => esc_html__('Bottom Spacing', 'roof'),
            'attributes'  => array( 'placeholder' => '100px' ),
            'dependency'  => array('content_spacings', '==', 'padding-custom'),
          ),

        ), // End Fields
      ), // Content Section

      // Enable & Disable
      array(
        'name'  => 'hide_show_section',
        'title' => esc_html__('Enable & Disable', 'roof'),
        'icon'  => 'fa fa-toggle-on',
        'fields' => array(

          array(
            'id'    => 'hide_header',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Header', 'roof'),
            'label' => esc_html__('Yes, Please do it.', 'roof'),
          ),
          array(
            'id'    => 'hide_breadcrumbs',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Breadcrumbs', 'roof'),
            'label' => esc_html__('Yes, Please do it.', 'roof'),
          ),
          array(
            'id'    => 'hide_footer',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Footer', 'roof'),
            'label' => esc_html__('Yes, Please do it.', 'roof'),
          ),

        ),
      ),
      // Enable & Disable

    ),
  );

  // -----------------------------------------
  // Page Layout
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'page_layout_options',
    'title'     => esc_html__('Page Layout', 'roof'),
    'post_type' => 'page',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(

      array(
        'name'   => 'page_layout_section',
        'fields' => array(

          array(
            'id'        => 'page_layout',
            'type'      => 'image_select',
            'options'   => array(
              'full-width'    => ROOF_CS_IMAGES . '/page-1.png',
              'extra-width'   => ROOF_CS_IMAGES . '/page-2.png',
              'left-sidebar'  => ROOF_CS_IMAGES . '/page-3.png',
              'right-sidebar' => ROOF_CS_IMAGES . '/page-4.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'page_layout',
            ),
            'default'    => 'full-width',
            'radio'      => true,
            'wrap_class' => 'text-center',
          ),
          array(
            'id'            => 'page_sidebar_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'roof'),
            'options'        => roof_vt_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'roof'),
            'dependency'   => array('page_layout', 'any', 'left-sidebar,right-sidebar'),
          ),

        ),
      ),

    ),
  );

  // -----------------------------------------
  // Testimonial
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'testimonial_options',
    'title'     => esc_html__('Testimonial Client', 'roof'),
    'post_type' => 'testimonial',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(

      array(
        'name'   => 'testimonial_option_section',
        'fields' => array(

          array(
            'id'      => 'testi_name',
            'type'    => 'text',
            'title'   => esc_html__('Name', 'roof'),
            'info'    => esc_html__('Enter client name', 'roof'),
          ),
          array(
            'id'      => 'testi_name_link',
            'type'    => 'text',
            'title'   => esc_html__('Name Link', 'roof'),
            'info'    => esc_html__('Enter client name link, if you want', 'roof'),
          ),
          array(
            'id'      => 'testi_pro',
            'type'    => 'text',
            'title'   => esc_html__('Profession', 'roof'),
            'info'    => esc_html__('Enter client profession', 'roof'),
          ),
          array(
            'id'      => 'testi_pro_link',
            'type'    => 'text',
            'title'   => esc_html__('Profession Link', 'roof'),
            'info'    => esc_html__('Enter client profession link', 'roof'),
          ),

        ),
      ),

    ),
  );

  // -----------------------------------------
  // Team
  // -----------------------------------------
  $options[]    = array(
    'id'        => 'team_options',
    'title'     => esc_html__('Job Position', 'roof'),
    'post_type' => 'team',
    'context'   => 'side',
    'priority'  => 'default',
    'sections'  => array(

      array(
        'name'   => 'team_option_section',
        'fields' => array(

          array(
            'id'      => 'team_job_position',
            'type'    => 'text',
            'attributes' => array(
              'placeholder' => esc_html__('Eg : Financial Manager', 'roof'),
            ),
            'info'    => esc_html__('Enter this employee job position, in your company.', 'roof'),
          ),
          array(
            'id'      => 'team_custom_link',
            'type'    => 'text',
            'title'    => esc_html__('Custom Link', 'roof'),
            'attributes' => array(
              'placeholder' => esc_html__('http://', 'roof'),
            ),
            'info'    => esc_html__('Enter your custom link, if you don\'t want to show this page.', 'roof'),
          ),
          // Start fields
          array(
            'id'                  => 'social_icons',
            'type'                => 'group',
            'title'    => esc_html__('Social Icons', 'roof'),
            'button_title'       => 'Add New Icon',
            'accordion_title'    => 'Adding New Icon',
            'accordion'          => true,
            'fields'              => array(
              array(
                'id'              => 'icon',
                'type'            => 'icon',
                'title'           => esc_html__('Select your icon', 'roof'),
              ),
              array(
                'id'              => 'icon_link',
                'type'            => 'text',
                'title'           => esc_html__('Enter your icon link', 'roof'),
              ),

            ),

          ),

        ),
      ),

    ),
  );

  return $options;

}
add_filter( 'cs_metabox_options', 'roof_vt_metabox_options' );