<?php
/*
 * Codestar Framework - Custom Style
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

/* All Dynamic CSS Styles */
if ( ! function_exists( 'roof_dynamic_styles' ) ) {
  function roof_dynamic_styles() {

    // Typography
    $roof_vt_get_typography  = roof_vt_get_typography();

    $all_element_color  = cs_get_customize_option( 'all_element_colors' );

    // Logo
    $brand_logo_top     = cs_get_option( 'brand_logo_top' );
    $brand_logo_bottom  = cs_get_option( 'brand_logo_bottom' );

    // Layout
    $bg_type = cs_get_option('theme_layout_bg_type');
    $bg_pattern = cs_get_option('theme_layout_bg_pattern');
    $bg_image = cs_get_option('theme_layout_bg');
    $bg_overlay_color = cs_get_option('theme_bg_overlay_color');

    // Footer
    $footer_bg_color  = cs_get_customize_option( 'footer_bg_color' );
    $footer_heading_color  = cs_get_customize_option( 'footer_heading_color' );
    $footer_text_color  = cs_get_customize_option( 'footer_text_color' );
    $footer_link_color  = cs_get_customize_option( 'footer_link_color' );
    $footer_link_hover_color  = cs_get_customize_option( 'footer_link_hover_color' );

  ob_start();

global $post;
$roof_id    = ( isset( $post ) ) ? $post->ID : 0;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

/* Layout - Theme Options - Background */
if ($bg_type === 'bg-image') {

  $layout_boxed = ( ! empty( $bg_image['image'] ) ) ? 'background-image: url('. $bg_image['image'] .');' : '';
  $layout_boxed .= ( ! empty( $bg_image['repeat'] ) ) ? 'background-repeat: '. $bg_image['repeat'] .';' : '';
  $layout_boxed .= ( ! empty( $bg_image['position'] ) ) ? 'background-position: '. $bg_image['position'] .';' : '';
  $layout_boxed .= ( ! empty( $bg_image['attachment'] ) ) ? 'background-attachment: '. $bg_image['attachment'] .';' : '';
  $layout_boxed .= ( ! empty( $bg_image['size'] ) ) ? 'background-size: '. $bg_image['size'] .';' : '';
  $layout_boxed .= ( ! empty( $bg_image['color'] ) ) ? 'background-color: '. $bg_image['color'] .';' : '';

echo <<<CSS
  .no-class {}
  .layout-boxed {
    {$layout_boxed}
  }
CSS;
}
if ($bg_type === 'bg-pattern') {
$custom_bg_pattern = cs_get_option('custom_bg_pattern');
$layout_boxed = ( $bg_pattern === 'custom-pattern' ) ? 'background-image: url('. $custom_bg_pattern .');' : 'background-image: url('. ROOF_IMAGES . '/patterns/'. $bg_pattern .'.png);';

echo <<<CSS
  .no-class {}
  .layout-boxed {
    {$layout_boxed}
  }
CSS;
}

/* Primary Colors */
if ($all_element_color) {
echo <<<CSS
  ::selection {background: {$all_element_color};}
  ::-webkit-selection {background: {$all_element_color};}
  ::-moz-selection {background: {$all_element_color};}
  ::-o-selection {background: {$all_element_color};}
  ::-ms-selection {background: {$all_element_color};}
  .roof-btn,
  .roof-btn-orange-border:hover,
  .roof-btn-orange-border:focus,
  .roof-btn-gray-border:hover,
  .roof-btn-gray-border:focus,
  .roof-social.style-one span:hover,
  input[type="submit"],
  .slider.slider-horizontal .tooltip-inner,
  .slider-handle:before,
  .header-style-three .roof-social a:hover,
  .menu-style-two .roof-social a:hover,
  .menu-spacer-two .navbar-nav > li > a:after,
  .menu-spacer-two .navbar-nav > li.active > a:after,
  .roof-consult, .roof-consult p,
  .expert-item.hover,
  .filters-nav > li > a.active,
  .filters-nav > li > a.active:hover,
  .location-pointers a,
  .mate-info .roof-social a:hover,
  .mate-designation:after,
  .widget-sidebar-nav ul > li > a:hover,
  .widget-sidebar-nav ul > li.active > a,
  .widget_tag_cloud a:hover,
  .widget_tag_cloud a:focus,
  .square-bullets li:before,
  .detail-title:after,
  .history-title a:hover .history-year:after,
  .history-title a:focus .history-year:after,
  .roof-pagination a:hover,
  .roof-pagination a:focus,
  .roof-pagination span,
  .roof-blog-tags ul li a:hover,
  .roof-blog-tags ul li a:focus,
  .woocommerce nav.woocommerce-pagination ul li a:focus,
  .woocommerce nav.woocommerce-pagination ul li a:hover,
  .woocommerce nav.woocommerce-pagination ul li span.current,
  .woocommerce nav.woocommerce-pagination ul li span,
  .woocommerce #respond input#submit.alt,
  .woocommerce-cart table.cart input.button,
  .woocommerce a.button.alt, .woocommerce button.button.alt,
  .woocommerce input.button.alt,
  .woocommerce #review_form #respond .form-submit input,
  .woocommerce #respond input#submit,
  .woocommerce a.button,
  .woocommerce button.button,
  .woocommerce input.button,
  .woocommerce a.remove:hover:before,
  .woocommerce a.remove:hover:after,
  .woocommerce .cart_totals .shipping button[type="submit"]:hover,
  .woocommerce .cart_totals .shipping button[type="submit"]:focus,
  .woocommerce .wc-proceed-to-checkout .button.alt:hover,
  .woocommerce .wc-proceed-to-checkout .button.alt:focus,
  .estimation-item.service .checkbox-icon-wrap input[type="checkbox"]:checked + .checkbox-icon,
  .roof-back-top a:hover,
  .wp-pagenavi a:hover,
  .wp-pagenavi span.current,
  .roof-sidenav .current-menu-item a,
  .portfolio-controls a.portfolio-control-link:hover {background-color: {$all_element_color};}
   .plan-item.hover .plan-price, .plan-item.hover a.roof-btn-black {background-color: {$all_element_color} !important;}

  a:hover,
  a:focus,
  i.roof-counter-icon,
  .checkbox-icon-wrap input[type="checkbox"]:checked + .checkbox-icon:before,
  .navbar-nav > li:hover > a,
  .roof-menu .navbar-nav > li > a:hover,
  .roof-menu .navbar-nav > li > a:focus,
  .navbar-nav .open > a,
  .nav .open > a:focus,
  .navbar-nav .open > a:hover,
  .navbar-nav > li.active > a,
  .dropdown-menu > li > a:hover,
  .dropdown-menu > li > a:focus,
  .dropdown-menu > li.open > a,
  .dropdown-menu > li.open > a:focus,
  .dropdown-menu > li.open > a:hover,
  .dropdown-menu > li.active > a,
  .dropdown-menu > .active > a,
  .dropdown-menu > .active > a:focus,
  .dropdown-menu > .active > a:hover,
  .contact-item .contact-info p a:hover,
  .roof-menu.menu-style-two .navbar-nav > li:hover > a,
  .roof-menu.menu-style-two .navbar-nav > li.active > a,
  .read-more a:hover,
  .expert-item.first a:hover,
  .work-info .work-title a:hover,
  .work-info .work-category a:hover,
  .roof-footer a:hover,
  .roof-footer .roof-social a:hover,
  .post-item .post-author span a:hover,
  .roof-copyright a:hover,
  .certifications-style-two .certification-title a:hover,
  .breadcrumb li a:hover,
  .roof-open-positions table a:hover,
  .works-style-three .work-info .work-title a:hover,
  .works-style-three .work-info .work-category a:hover,
  .right-info .info-sub-label a:hover,
  .widget_categories ul li a:hover,
  .blog-meta a:hover,
  .roof-more-posts .pull-right a:hover,
  .product_meta a:hover,
  .roof-forms .lost-password:hover,
  .roof-contact-wrap .contact-info ul li a:hover,
  .woocommerce form .lost_password a:hover,
  .header-style-three .roof-menu .navbar-nav > li:hover > a,
  .header-style-three .roof-menu .navbar-nav > li.active > a,
  .cpation-wrap .cpation-sub-title,
  .testimonial-style-two .quote-client a,
  .roof-questions .view-more a,
  .partner-info .partner-website a,
  .work-info-item .icons,
  .blog-link .blog-date,
  .blog-link.share.hover .link-inner,
  .blog-link.share.hover .link-inner > .link-title,
  .share-links a:hover, .share-links a:hover .link-title,
  .blog-meta .meta-author a,
  .woocommerce .star-rating span,
  .woocommerce p.stars.selected a.active:before,
  .woocommerce p.stars:hover a:before,
  .roof-404-error .error-sub-title span,
  .roof-contact-wrap .website-link a,
  .roof-footer .roof-social a:hover i,
  .post-item .post-author a,
  .roof-menu ul.navbar-nav li.current-menu-parent > a,
  .mean-container .mean-nav .current-menu-parent>a,
  .mean-container li.current-menu-item.active a,
  .mean-container .mean-nav ul li a:hover
   {color: {$all_element_color};}

  .roof-btn-orange-border,
  .mate-info .roof-social a:hover,
  .widget_tag_cloud a:hover, .widget_tag_cloud a:focus,
  .roof-pagination a:hover, .roof-pagination a:focus,
  .roof-pagination span,
  .roof-blog-tags ul li a:hover,
  .roof-blog-tags ul li a:focus,
  .woocommerce nav.woocommerce-pagination ul li a:focus,
  .woocommerce nav.woocommerce-pagination ul li a:hover,
  .woocommerce nav.woocommerce-pagination ul li span.current,
  .woocommerce nav.woocommerce-pagination ul li span,
  .estimation-item.service .checkbox-icon-wrap input[type="checkbox"]:checked + .checkbox-icon,
  .wp-pagenavi a:hover,
  .wp-pagenavi span.current {border-color: {$all_element_color};}

  .slider .tooltip.bottom .tooltip-arrow {border-bottom-color: {$all_element_color};}
  .testimonial-wrap:after {border-left-color: {$all_element_color};}
CSS;
}

// Button Hover Colors
$button_hover_colors  = cs_get_customize_option( 'button_hover_colors' );
if ($button_hover_colors) {
echo <<<CSS
  .no-class {}
  .roof-btn:hover,
  .roof-btn:focus,
  input[type="submit"]:hover,
  input[type="submit"]:focus,
  .woocommerce #respond input#submit.alt:hover,
  .woocommerce #respond input#submit.alt:focus,
  .woocommerce a.button.alt:hover,
  .woocommerce a.button.alt:focus,
  .woocommerce button.button.alt:hover,
  .woocommerce button.button.alt:focus,
  .woocommerce input.button.alt:hover,
  .woocommerce input.button.alt:focus,
  .woocommerce #review_form #respond .form-submit input:hover,
  .woocommerce #review_form #respond .form-submit input:focus,
  .woocommerce #respond input#submit:hover,
  .woocommerce a.button:hover,
  .woocommerce button.button:hover,
  .woocommerce input.button:hover,
  .woocommerce #respond input#submit:focus,
  .woocommerce a.button:focus,
  .woocommerce button.button:focus,
  .woocommerce input.button:focus,
  .request-quote input[type="submit"]:hover, 
  .request-quote input[type="submit"]:focus {background-color: {$button_hover_colors};}
CSS;
}

/* Top Bar - Customizer - Background */
$topbar_bg_color  = cs_get_customize_option( 'topbar_bg_color' );
if ($topbar_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar,
  .roof-top-bar.top-bar-style-two {
    background-color: {$topbar_bg_color};
  }
CSS;
}
$topbar_text_color  = cs_get_customize_option( 'topbar_text_color' );
if ($topbar_text_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar.top-bar-style-two {
    color: {$topbar_text_color};
  }
CSS;
}

$topbar_link_color  = cs_get_customize_option( 'topbar_link_color' );
if ($topbar_link_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar.top-bar-style-two a {
    color: {$topbar_link_color};
  }
CSS;
}
$topbar_link_hover_color  = cs_get_customize_option( 'topbar_link_hover_color' );
if ($topbar_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar .navbar-nav > li > a:hover {
    color: {$topbar_link_hover_color};
  }
CSS;
}
$country_link_color  = cs_get_customize_option( 'country_link_color' );
if ($country_link_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar.top-bar-style-two .country-menu a,
  .roof-top-bar.top-bar-style-two .country-menu .dropdown-menu a {
    color: {$country_link_color};
  }
CSS;
}
$country_link_hover_color  = cs_get_customize_option( 'country_link_hover_color' );
if ($country_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar.top-bar-style-two .country-menu a:hover,
  .roof-top-bar.top-bar-style-two .country-menu .dropdown-menu a:hover {
    color: {$country_link_hover_color};
  }
CSS;
}
$country_bg_color  = cs_get_customize_option( 'country_bg_color' );
if ($country_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar .navbar-nav > li.country-menu > a,
  .roof-top-bar.top-bar-style-two .navbar-nav > li.country-menu > a,
  .roof-top-bar.top-bar-style-two .navbar-nav > li.country-menu .dropdown-menu a {
    background-color: {$country_bg_color};
  }
CSS;
}
$country_border_color  = cs_get_customize_option( 'country_border_color' );
if ($country_border_color) {
echo <<<CSS
  .no-class {}
  .roof-top-bar .navbar-nav > li.country-menu > ul > li > a {
    border-color: {$country_border_color};
  }
CSS;
}

/* Header - Customizer */
$menu_bg_color  = cs_get_customize_option( 'menu_bg_color' );
if ($menu_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-menu.menu-style-two,
  .roof-header.header-style-three, .mean-container .mean-bar {
    background-color: {$menu_bg_color};
  }
CSS;
}
$menu_link_color  = cs_get_customize_option( 'menu_link_color' );
if ($menu_link_color) {
echo <<<CSS
  .no-class {}
  .header-style-three .roof-menu .navbar-nav > li > a,
  .roof-menu.menu-style-two .navbar-nav > li > a,
  .mean-container .mean-nav ul li a {
    color: {$menu_link_color};
  }
  .mean-expand::before, .mean-expand::after,
  .mean-container a.meanmenu-reveal span {
    background: {$menu_link_color};
  }
CSS;
}

$menu_link_hover_color  = cs_get_customize_option( 'menu_link_hover_color' );
if($menu_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-menu.menu-style-two .navbar-nav > li:hover > a,
  .roof-menu.menu-style-two .navbar-nav > li.active > a,
  .header-style-three .roof-menu .navbar-nav > li:hover > a,
  .header-style-three .roof-menu .navbar-nav > li.active > a,
  .roof-menu .navbar-nav > li > a:hover,
  .roof-menu .navbar-nav > li > a:active,
  .roof-menu ul.navbar-nav li.current-menu-parent > a,
  .mean-container .mean-nav .current-menu-parent>a,
  .mean-container li.current-menu-item.active a,
  .mean-container .mean-nav ul li a:hover {
    color: {$menu_link_hover_color};
  }
CSS;
}
$submenu_bg_color  = cs_get_customize_option( 'submenu_bg_color' );
if($submenu_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .dropdown-menu {
    background-color: {$submenu_bg_color};
  }
CSS;
}
$submenu_border_color  = cs_get_customize_option( 'submenu_border_color' );
if($submenu_border_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .dropdown-menu > li > a {
    border-color: {$submenu_border_color};
  }
CSS;
}
$submenu_link_color  = cs_get_customize_option( 'submenu_link_color' );
if($submenu_link_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .dropdown-menu > li > a {
    color: {$submenu_link_color};
  }
CSS;
}
$submenu_link_hover_color  = cs_get_customize_option( 'submenu_link_hover_color' );
if($submenu_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .dropdown-menu > li > a:hover {
    color: {$submenu_link_hover_color};
  }
CSS;
}
$topbar_social_color  = cs_get_customize_option( 'topbar_social_color' );
if($topbar_social_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .roof-social i {
    color: {$topbar_social_color};
  }
CSS;
}
$topbar_social_bg_color  = cs_get_customize_option( 'topbar_social_bg_color' );
if($topbar_social_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .roof-social a,
  .roof-menu .roof-social span {
    background-color: {$topbar_social_bg_color};
  }
CSS;
}
$topbar_social_bg_hover_color  = cs_get_customize_option( 'topbar_social_bg_hover_color' );
if($topbar_social_bg_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-menu .roof-social span:hover,
  .menu-style-two .roof-social a:hover {
    background-color: {$topbar_social_bg_hover_color};
  }
CSS;
}
// Metabox - Header Transparent
if ($roof_meta) {
  $transparent_header = $roof_meta['transparency_header'];

} else {
  $transparent_header = '';
}

$header_bg_color  = cs_get_customize_option( 'header_bg_color' ); 
$trans_header_color = cs_get_customize_option('trans_header_color');

  if($trans_header_color) {
echo <<<CSS
  .no-class {}
  .roof-header.roof-style-two {
    background-color: {$trans_header_color};
  }
CSS;
  }

  if($header_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-header.roof-style-one {
    background-color: {$header_bg_color};
  }
CSS;
  }


// Metabox - Header Transparent
if ($roof_meta) {
  $transparent_header = $roof_meta['transparency_header'];
  $transparent_menu_color = $roof_meta['transparent_menu_color'];
  $transparent_menu_hover = $roof_meta['transparent_menu_hover_color'];
} else {
  $transparent_header = '';
  $transparent_menu_color = '';
  $transparent_menu_hover = '';
}
if ($transparent_header) {
echo <<<CSS
  .no-class {}
  .roof-header-two .roof-navigation .navbar-nav > li > a,
  .roof-navigation .navbar-nav > li > a,
  .roof-header-two #search-trigger-two i,
  .roof-header-two #cart-trigger i{
    color: {$transparent_menu_color};
  }

  .roof-header-two .roof-navigation .navbar-nav > li > a:hover,
  .roof-navigation .navbar-nav > li > a:hover,
  .roof-navigation .navbar-nav > li.current_page_item > a,
  .roof-header-two .roof-navigation .navbar-nav > li.current-menu-parent > a{
    color: {$transparent_menu_hover};
  }
CSS;
}

$submenu_bg_color  = cs_get_customize_option( 'submenu_bg_color' );
$submenu_bg_hover_color  = cs_get_customize_option( 'submenu_bg_hover_color' );
$submenu_border_color  = cs_get_customize_option( 'submenu_border_color' );
$submenu_link_color  = cs_get_customize_option( 'submenu_link_color' );
$submenu_link_hover_color  = cs_get_customize_option( 'submenu_link_hover_color' );
if ($submenu_bg_color || $submenu_bg_hover_color || $submenu_border_color || $submenu_link_color || $submenu_link_hover_color) {
echo <<<CSS
  .no-class {}
  .dropdown-menu > li > a {
    border-color: {$submenu_border_color};
    color: {$submenu_link_color};
  }
  .dropdown-menu > li > a:focus,
  .dropdown-menu > li > a:hover,
  .dropdown-menu > .active > a,
  .dropdown-menu > .active > a:focus,
  .dropdown-menu > .active > a:hover,
  .mean-container .mean-nav ul.sub-menu > li:hover,
  .mean-container .mean-nav ul.sub-menu > li.current-menu-item,
  .mean-container .mean-nav ul.sub-menu > li a:hover {
    background-color: {$submenu_bg_hover_color};
    color: {$submenu_link_hover_color};
  }
  .dropdown-menu,
  .mean-container .mean-nav ul.sub-menu li a {
    background-color: {$submenu_bg_color};
  }
  .mean-container .mean-nav ul.sub-menu li a {
    color: {$submenu_link_color};
  }
  .mean-container .mean-nav ul li li a,
  .mean-container .mean-nav ul li li li a,
  .mean-container .mean-nav ul li li li li a,
  .mean-container .mean-nav ul li li li li li a {
    border-top-color: {$submenu_border_color};
  }
CSS;
}

/* Mobile Menu - Customizer */
$mobile_menu_toggle_color = cs_get_customize_option('mobile_menu_toggle_color');
$mobile_menu_bg_color  = cs_get_customize_option( 'mobile_menu_bg_color' );
$mobile_menu_bg_hover_color  = cs_get_customize_option( 'mobile_menu_bg_hover_color' );
$mobile_menu_link_color  = cs_get_customize_option( 'mobile_menu_link_color' );
$mobile_menu_link_hover_color  = cs_get_customize_option( 'mobile_menu_link_hover_color' );
$mobile_menu_border_color  = cs_get_customize_option( 'mobile_menu_border_color' );
$mobile_menu_expand_color  = cs_get_customize_option( 'mobile_menu_expand_color' );
$mobile_menu_expand_hover_color  = cs_get_customize_option( 'mobile_menu_expand_hover_color' );
$mobile_menu_expand_bg_color  = cs_get_customize_option( 'mobile_menu_expand_bg_color' );
$mobile_menu_expand_bg_hover_color  = cs_get_customize_option( 'mobile_menu_expand_bg_hover_color' );
if ($mobile_menu_toggle_color) {
echo <<<CSS
  .no-class {}
  .mean-container a.meanmenu-reveal span,
  .mean-container a.meanmenu-reveal span:before,
  .mean-container a.meanmenu-reveal span:after,
  .hanor-transparent-header .mean-container a.meanmenu-reveal span:before,
  .hanor-transparent-header .mean-container a.meanmenu-reveal span:after,
  .hanor-transparent-header .mean-container a.meanmenu-reveal span,
  .mean-container a.meanmenu-reveal.meanclose span:before {
    background: {$mobile_menu_toggle_color};
  }
CSS;
}
if ($mobile_menu_bg_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav {
    background-color: {$mobile_menu_bg_color};
  }
CSS;
}
if($mobile_menu_bg_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-header .mean-container .dropdown-nav > li:hover > a,
  .roof-header .mean-container .dropdown-nav > li:focus > a,
  .mean-container .mean-nav ul li:hover > a,
  .mean-container .mean-nav ul li:focus > a {
    background-color: {$mobile_menu_bg_hover_color};
  }
CSS;
}
if($mobile_menu_link_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li a {
    color: {$mobile_menu_link_color};
  }
CSS;
}
if($mobile_menu_link_hover_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li a:hover,
  .mean-container .mean-nav ul li a:focus,
  .roof-header .mean-container .dropdown-nav > li.active > a,
  .mean-container ul li.current-menu-ancestor > a,
  .mean-container .mean-nav .current-menu-parent>a,
  .mean-container li.current-menu-item.active a {
    color: {$mobile_menu_link_hover_color};
  }
CSS;
}
if($mobile_menu_border_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li li a, .mean-container .mean-nav ul li a {
    border-color: {$mobile_menu_border_color};
  }
CSS;
}
if($mobile_menu_expand_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li a.mean-expand:before,
  .mean-container .mean-nav ul li a.mean-expand:after {
    background: {$mobile_menu_expand_color};
  }
CSS;
}
if($mobile_menu_expand_hover_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li a.mean-expand:hover:before,
  .mean-container .mean-nav ul li a.mean-expand:hover:after,
  .mean-container .mean-nav ul li a.mean-expand:focus:before,
  .mean-container .mean-nav ul li a.mean-expand:focus:after,
  .mean-container .mean-nav ul li:hover > a.mean-expand:before,
  .mean-container .mean-nav ul li:hover > a.mean-expand:after,
  .mean-container .mean-nav ul li:focus > a.mean-expand:before,
  .mean-container .mean-nav ul li:focus > a.mean-expand:after,
  .roof-header .mean-container .dropdown-nav > li:hover > a.mean-expand:before,
  .roof-header .mean-container .dropdown-nav > li:hover > a.mean-expand:after,
  .roof-header .mean-container .dropdown-nav > li:focus > a.mean-expand:before,
  .roof-header .mean-container .dropdown-nav > li:focus > a.mean-expand:after {
    background: {$mobile_menu_expand_hover_color};
  }
CSS;
}
if($mobile_menu_expand_bg_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li a.mean-expand {
    background-color: {$mobile_menu_expand_bg_color};
  }
CSS;
}
if($mobile_menu_expand_bg_hover_color) {
echo <<<CSS
  .no-class {}
  .mean-container .mean-nav ul li a.mean-expand:hover,
  .mean-container .mean-nav ul li a.mean-expand:focus,
  .mean-container .mean-nav ul li:hover > a.mean-expand,
  .mean-container .mean-nav ul li:focus > a.mean-expand,
  .roof-header .mean-container .dropdown-nav > li:hover > a.mean-expand,
  .roof-header .mean-container .dropdown-nav > li:focus > a.mean-expand {
    background-color: {$mobile_menu_expand_bg_hover_color};
  }
CSS;
}

/* Title Area - Theme Options - Background */
$titlebar_bg = cs_get_option('titlebar_bg');
$title_heading_color  = cs_get_customize_option( 'titlebar_title_color' );
if ($titlebar_bg) {

  $title_area = ( ! empty( $titlebar_bg['image'] ) ) ? 'background-image: url('. $titlebar_bg['image'] .');' : '';
  $title_area .= ( ! empty( $titlebar_bg['repeat'] ) ) ? 'background-repeat: '. $titlebar_bg['repeat'] .';' : '';
  $title_area .= ( ! empty( $titlebar_bg['position'] ) ) ? 'background-position: '. $titlebar_bg['position'] .';' : '';
  $title_area .= ( ! empty( $titlebar_bg['attachment'] ) ) ? 'background-attachment: '. $titlebar_bg['attachment'] .';' : '';
  $title_area .= ( ! empty( $titlebar_bg['size'] ) ) ? 'background-size: '. $titlebar_bg['size'] .';' : '';
  $title_area .= ( ! empty( $titlebar_bg['color'] ) ) ? 'background-color: '. $titlebar_bg['color'] .';' : '';

echo <<<CSS
  .no-class {}
  .roof-page-title {
    {$title_area}
  }
CSS;
}
if ($title_heading_color) {
echo <<<CSS
  .no-class {}
  .roof-page-title .page-title {
    color: {$title_heading_color};
  }
CSS;
}

// Breadcrubms
$breadcrumbs_text_color  = cs_get_customize_option( 'breadcrumbs_text_color' );
$breadcrumbs_link_color  = cs_get_customize_option( 'breadcrumbs_link_color' );
$breadcrumbs_link_hover_color  = cs_get_customize_option( 'breadcrumbs_link_hover_color' );

if ($breadcrumbs_text_color) {
echo <<<CSS
  .no-class {}
  .breadcrumb,
  .breadcrumb li:before {
    color: {$breadcrumbs_text_color};
  }
CSS;
}
if ($breadcrumbs_link_color) {
echo <<<CSS
  .no-class {}
  .breadcrumb > li > a {
    color: {$breadcrumbs_link_color};
  }
CSS;
}
if ($breadcrumbs_link_hover_color) {
echo <<<CSS
  .no-class {}
  .breadcrumb > li > a:hover {
    color: {$breadcrumbs_link_hover_color};
  }
CSS;
}

// Content Colors
$body_color  = cs_get_customize_option( 'body_color' );
if ($body_color) {
echo <<<CSS
  .no-class {}
  body,
  p,
  .roof-primary p,
  .blog-meta span,
  .blog-links-wrap .link-title,
  .roof-main-wrap .roof-content-side p,
  .roof-main-wrap .roof-content-side .partner-address,
  input[type="text"],
  input[type="email"],
  input[type="password"],
  input[type="tel"],
  input[type="search"],
  input[type="date"],
  input[type="time"],
  input[type="datetime-local"],
  input[type="month"],
  input[type="url"],
  input[type="number"],
  textarea, select,
  .form-control,
  .tooltip,
  .tooltip-inner,
  .panel-title a:before,
  .testimonial-style-two .quote-client,
  .benefit-info p,
  .plan-sub-title,
  .blog-info p,
  .author-content .author-pro,
  .price-filter .range-value,
  .price-filter .range-value output,
  .woocommerce .cart_totals .shipping span,
  .woocommerce-checkout form.woocomerce-form.woocommerce-form-login.login p:first-child,
  .woocommerce form .wpcf7-list-item-label,
  .woocommerce .woocommerce-checkout-review-order table.shop_table .cart_item th,
  .woocommerce .woocommerce-checkout-review-order table.shop_table .cart_item td,
  .roof-estimation-wrap .section-title-wrap p,
  .roof-copyright,
  .roof-about .section-title-wrap p,
  .testimonial-style-three .roof-carousel p,
  .mate-designation,
  .roof-status,
  .request-quote input[type="submit"],
  .square-bullets,
  .description-box-element p,
  .partner-info .partner-address,
  .roof-open-positions table,
  .plan-item.hover .plan-info ul li i,
  .plan-info ul,
  .works-style-three .work-info,
  .works-style-three .work-info .work-category,
  .widget_categories ul li a:after,
  .widget_product_categories ul li a:after,
  .blog-link .blog-date,
  .blog-link .link-title,
  .blog-link.share.hover .link-inner,
  .woocommerce-Price-amount,
  .blog-link.share.hover .link-inner > .link-title,
  .woocommerce .product_meta,
  .woocommerce .woocommerce-result-count,
  .woocommerce-page .woocommerce-result-count,
  .woocommerce .woocommerce-ordering select,
  .woocommerce .cart_totals table.shop_table th,
  .woocommerce form .form-row input.input-text,
  .woocommerce form .form-row select,
  .woocommerce form .form-row textarea,
  .roof-widget select,
  .woocommerce form.woocommerce-checkout .form-row label,
  form label,
  .woocommerce .woocommerce-checkout-review-order table.shop_table th,
  .woocommerce-error, .woocommerce-info, .woocommerce-message,
  .woocommerce .woocommerce-table--order-details tfoot tr th,
  .woocommerce .woocommerce-table--order-details tfoot tr td,
  table.woocommerce-table.woocommerce-table--customer-details.shop_table.customer_details tbody tr th,
  table.woocommerce-table.woocommerce-table--customer-details.shop_table.customer_details tbody tr td,
  .roof-comments-area .roof-comments-meta .comments-date {color: {$body_color};}
CSS;
}
$body_links_color  = cs_get_customize_option( 'body_links_color' );
if ($body_links_color) {
echo <<<CSS
  .no-class {}
  .blog-meta a,
  .roof-main-wrap .roof-content-side a,
  .roof-social a,
  .roof-social span,
  .testimonial-style-two .quote-client a,
  .entry-content .comment-list .comment-reply-link,
  .roof-footer .roof-social a, .style-two.roof-social a, .roof-footer .roof-social span, .style-two.roof-social span,
  .roof-footer .roof-social,
  .roof-copyright a,
  .blog-meta a,
  .mate-info .roof-social a,
  .emergency-number .emergency-title a,
  .emergency-number .emergency-title a,
  .roof-questions .view-more a,
  .roof-description-share ul li a,
  .partner-info .partner-website a,
  .roof-open-positions table a,
  .works-style-three .work-info .work-title a,
  .works-style-three .work-info .work-category a,
  .widget_categories ul li a,
  .widget_product_categories ul li a,
  .woocommerce ul.products li.product h3 a,
  .product_meta a,
  .woocommerce-product-rating .woocommerce-review-link,
  .woocommerce-account .woocommerce .woocommerce-MyAccount-navigation ul li a,
  .roof-widget .post-title a,
  .logged-in-as a,
  .blog-meta .meta-author a {color: {$body_links_color};}
CSS;
}
$body_link_hover_color  = cs_get_customize_option( 'body_link_hover_color' );
if ($body_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-social a:hover,
  .roof-social span:hover,
  .roof-main-wrap .roof-content-side a:hover,
  .roof-main-wrap .roof-content-side a:focus,
  .testimonial-style-two .quote-client a:hover,
  .entry-content .comment-list .comment-reply-link:hover,
  .entry-content .comment-list .comment-reply-link:focus,
  .roof-copyright a:focus,
  .blog-meta a:hover,
  .mate-info .roof-social a:hover,
  .emergency-number .emergency-title a:hover,
  .emergency-number .emergency-title a:focus,
  .roof-questions .view-more a:hover,
  .partner-info .partner-website a:hover
  .roof-open-positions table a:hover,
  .woocommerce ul.products li.product h3 a:hover,
  .share-links a:hover, .share-links a:hover .link-title,
  .product_meta a:hover,
  .roof-widget .post-title a:hover,
  .logged-in-as a:hover,
  .woocommerce-account .woocommerce .woocommerce-MyAccount-navigation ul .is-active a,
  .woocommerce-account .woocommerce .woocommerce-MyAccount-navigation ul li a:hover,
  .blog-meta .meta-author a:hover {color: {$body_link_hover_color};}
CSS;
}
$sidebar_content_color  = cs_get_customize_option( 'sidebar_content_color' );
if ($sidebar_content_color) {
echo <<<CSS
  .no-class {}
  .roof-secondary p,
  .roof-secondary .recent-post .post-time,
  .roof-widget .woocommerce-Price-amount,
  .widget_layered_nav .count,
  .roof-widget select,
  .roof-widget .product-categories .count,
  .roof-widget .product_list_widget .reviewer,
  .widget_shopping_cart_content .quantity,
  .roof-widget .widget_shopping_cart_content .quantity .woocommerce-Price-amount,
  .roof-widget.widget_calendar tbody tr td, .roof-widget.widget_calendar caption,
  .roof-widget.widget_recent_comments span.comment-author-link,
  .roof-widget.widget_rss .rssSummary,
  .roof-widget.widget_rss cite,
  .roof-widget.widget_rss .rss-date,
  .roof-widget input[type="text"]  {color: {$sidebar_content_color};}
CSS;
}
$sidebar_link_color  = cs_get_customize_option( 'sidebar_link_color' );
if ($sidebar_link_color) {
echo <<<CSS
  .no-class {}
  .roof-secondary ul li a,
  .roof-secondary .tagcloud a,
  .roof-widget a,
  .woocommerce ul.cart_list li a,
  .woocommerce ul.product_list_widget li a,
  .widget-sidebar-nav ul > li> a {color: {$sidebar_link_color};}
CSS;
}
$sidebar_link_hover_color  = cs_get_customize_option( 'sidebar_link_hover_color' );
if ($sidebar_link_hover_color) {
echo <<<CSS
  .no-class {}
  .widget-sidebar-nav ul > li > a:hover,
  .widget-sidebar-nav ul > li.active > a,
  .roof-widget a:hover,
  .woocommerce ul.cart_list li a:hover,
  .woocommerce ul.product_list_widget li a:hover,
  .widget_tag_cloud a:hover, .widget_tag_cloud a:focus {color: {$sidebar_link_hover_color};}
CSS;
}
$sidebar_heading_color  = cs_get_customize_option( 'sidebar_heading_color' );
if ($sidebar_heading_color) {
echo <<<CSS
  .no-class {}
  .roof-secondary .widget-title {color: {$sidebar_heading_color};}
CSS;
}
$content_heading_color  = cs_get_customize_option( 'content_heading_color' );
if ($content_heading_color) {
echo <<<CSS
  .no-class {}
  .roof-main-wrap .roof-content-side h3,
  .roof-main-wrap .roof-content-side h2,
  .roof-main-wrap .roof-content-side h5,
  .roof-main-wrap .roof-content-side h6,
  .about-detail .about-info h5,
  .about-detail.about-style-two .about-info h5 span,
  .description-box-element h4,
  h3.blog-title,
  h3.comments-title,
  h3#reply-title,
  h1.product_title.entry-title,
  h4.related-product-title,
  .about-detail.about-style-two .about-info h5,
  .about-detail.about-style-two .about-info h5 span,
  .plan-item.hover .plan-sub-title {color: {$content_heading_color};}
CSS;
}

// Maintenance Mode
$maintenance_mode_bg  = cs_get_option( 'maintenance_mode_bg' );
if ($maintenance_mode_bg) {
  $maintenance_css = ( ! empty( $maintenance_mode_bg['image'] ) ) ? 'background-image: url('. $maintenance_mode_bg['image'] .');' : '';
  $maintenance_css .= ( ! empty( $maintenance_mode_bg['repeat'] ) ) ? 'background-repeat: '. $maintenance_mode_bg['repeat'] .';' : '';
  $maintenance_css .= ( ! empty( $maintenance_mode_bg['position'] ) ) ? 'background-position: '. $maintenance_mode_bg['position'] .';' : '';
  $maintenance_css .= ( ! empty( $maintenance_mode_bg['attachment'] ) ) ? 'background-attachment: '. $maintenance_mode_bg['attachment'] .';' : '';
  $maintenance_css .= ( ! empty( $maintenance_mode_bg['size'] ) ) ? 'background-size: '. $maintenance_mode_bg['size'] .';' : '';
  $maintenance_css .= ( ! empty( $maintenance_mode_bg['color'] ) ) ? 'background-color: '. $maintenance_mode_bg['color'] .';' : '';
echo <<<CSS
  .no-class {}
  .vt-maintenance-mode {
    {$maintenance_css}
  }
CSS;
}
/* Footer */
if ($footer_bg_color) {
echo <<<CSS
  .no-class {}
  .roof-footer {background: {$footer_bg_color};}
CSS;
}
if ($footer_heading_color) {
echo <<<CSS
  .no-class {}
  .roof-footer h4,
  .roof-social.style-two h6 {color: {$footer_heading_color};}
CSS;
}
if ($footer_text_color) {
echo <<<CSS
  .no-class {}
  .roof-footer,
  .roof-footer p,
  .roof-footer .product-title {color: {$footer_text_color};}
CSS;
}
if ($footer_link_color) {
echo <<<CSS
  .no-class {}
  .roof-footer a,
  .roof-social.style-two a i,
  .roof-footer ul.product_list_widget li a,
  .roof-footer .post-item .post-author span a,
  .roof-footer .post-item .post-author a {color: {$footer_link_color};}
CSS;
}
if ($footer_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-footer a:hover,
  .roof-social.style-two a i:hover,
  .roof-footer ul.product_list_widget li a:hover,
  .roof-footer .post-item .post-author a:hover,
  .roof-footer .post-item .post-author span a:hover {color: {$footer_link_hover_color};}
CSS;
}

/* Copyright */
$copyright_text_color  = cs_get_customize_option( 'copyright_text_color' );
$copyright_link_color  = cs_get_customize_option( 'copyright_link_color' );
$copyright_link_hover_color  = cs_get_customize_option( 'copyright_link_hover_color' );
$copyright_bg_color  = cs_get_customize_option( 'copyright_bg_color' );
$copyright_border_color  = cs_get_customize_option( 'copyright_border_color' );
if ($copyright_bg_color || $copyright_border_color) {
echo <<<CSS
  .no-class {}
  .roof-copyright {background: {$copyright_bg_color};}
CSS;
}
if ($copyright_text_color) {
echo <<<CSS
  .no-class {}
  .roof-copyright,
  .roof-copyright p {color: {$copyright_text_color};}
CSS;
}
if ($copyright_link_color) {
echo <<<CSS
  .no-class {}
  .roof-copyright a {color: {$copyright_link_color};}
CSS;
}
if ($copyright_link_hover_color) {
echo <<<CSS
  .no-class {}
  .roof-copyright a:hover,
  .roof-copyright .navbar-nav > li > a:hover {color: {$copyright_link_hover_color};}
CSS;
}

// Mobile Menu Breakpoint
$mobile_breakpoint = cs_get_option('mobile_breakpoint');
$breakpoint = $mobile_breakpoint ? $mobile_breakpoint : '992';

echo <<<CSS
  .no-class {}
@media (max-width: {$breakpoint}px) {
  .roof-brand {background-color: #fff !important;}
  .navigation-bar,
  .top-nav-icons,
  .roof-nav-search {display: none;}
  .mean-container .top-nav-icons,
  .mean-container .roof-logo,
  .mean-container .roof-nav-search {display: block;}
  .hav-mobile-logo .transparent-logo,
  .hav-mobile-logo .sticky-logo,
  .header-transparent .roof-logo.hav-mobile-logo.hav-transparent-logo .transparent-retina-logo,
  .header-transparent .is-sticky .roof-logo.hav-mobile-logo.hav-transparent-logo .retina-logo.sticky-logo,
  .roof-logo.hav-mobile-logo img.retina-logo,
  .dont-transparent .roof-logo.hav-transparent-logo.hav-mobile-logo .retina-logo,
  .header-transparent .roof-logo.hav-transparent-logo .transparent-retina-logo {display: none;}
  .roof-header .roof-navigation nav.roof-menu {display: none;}
  .roof-logo.hav-mobile-logo img.mobile-logo,
  .header-transparent .roof-logo.hav-transparent-logo .retina-logo {display: block;}
  .mean-container .container {width: 100%;}
  .roof-header-two .mean-container .roof-logo {
    position: absolute;
    top: 0;
    left: 0;
    z-index: 99999;
    padding: 0 20px;
  }
  .is-sticky .roof-logo {
    display: none;
  }
  .roof-style-one .sticky-wrapper {
    height: 0 !important;
  }
  .is-sticky .roof-header, .is-sticky .roof-header.header-style-three {
    background: transparent;
  }
  .is-sticky .roof-logo {
    display: none;
  }
  .mean-container .roof-nav-search {
    float: left;
    left: 0;right: auto;
    background-color: rgba(0,0,0,0.4);
  }
  .mean-container .roof-search-three {
    position: absolute;
    width: 100%;
    left: 0;top: 0;
    z-index: 9999;
  }
  .mean-container .roof-search-three input {
    position: absolute;
    left: 0;top: 0;
    background: rgba(0,0,0,0.4);
  }
  .roof-header-two .mean-container .top-nav-icons {
    position: absolute;
    left: 0;
    z-index: 999999;
  }
  .roof-header-two .roof-brand {padding-top: 20px;padding-bottom: 0;}
}
CSS;

  echo $roof_vt_get_typography;

  $output = ob_get_clean();
  return $output;

  }

}

/**
 * Custom Font Family
 */
if ( ! function_exists( 'roof_custom_font_load' ) ) {
  function roof_custom_font_load() {

    $font_family       = cs_get_option( 'font_family' );

    ob_start();

    if( ! empty( $font_family ) ) {

      foreach ( $font_family as $font ) {
        echo '@font-face{';

        echo 'font-family: "'. $font['name'] .'";';

        if( empty( $font['css'] ) ) {
          echo 'font-style: normal;';
          echo 'font-weight: normal;';
        } else {
          echo $font['css'];
        }

        echo ( ! empty( $font['ttf']  ) ) ? 'src: url('. esc_url($font['ttf']) .');' : '';
        echo ( ! empty( $font['eot']  ) ) ? 'src: url('. esc_url($font['eot']) .');' : '';
        echo ( ! empty( $font['svg']  ) ) ? 'src: url('. esc_url($font['svg']) .');' : '';
        echo ( ! empty( $font['woff'] ) ) ? 'src: url('. esc_url($font['woff']) .');' : '';
        echo ( ! empty( $font['otf']  ) ) ? 'src: url('. esc_url($font['otf']) .');' : '';

        echo '}';
      }

    }

    // Typography
    $output = ob_get_clean();
    return $output;
  }
}

/* Custom Styles */
if( ! function_exists( 'roof_vt_custom_css' ) ) {
  function roof_vt_custom_css() {
    wp_enqueue_style('roof-default-style', get_template_directory_uri() . '/style.css');
    $output  = roof_custom_font_load();
    $output .= roof_dynamic_styles();
    $output .= cs_get_option( 'theme_custom_css' );
    $custom_css = roof_compress_css_lines( $output );

    wp_add_inline_style( 'roof-default-style', $custom_css );
  }
}

/* Custom JS */
if( ! function_exists( 'roof_vt_custom_js' ) ) {
  function roof_vt_custom_js() {
    if ( ! wp_script_is( 'jquery', 'done' ) ) {
      wp_enqueue_script( 'jquery' );
    }
    $output = cs_get_option( 'theme_custom_js' );
    wp_add_inline_script( 'jquery-migrate', $output );
  }
  add_action( 'wp_enqueue_scripts', 'roof_vt_custom_js' );
}