<?php
/*
 * All customizer related options for Roof theme.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

if( ! function_exists( 'roof_vt_customizer' ) ) {
  function roof_vt_customizer( $options ) {

	$options        = array(); // remove old options

	// Primary Color
	$options[]      = array(
	  'name'        => 'elemets_color_section',
	  'title'       => esc_html__('Primary Color', 'roof'),
	  'settings'    => array(

	    // Fields Start
			array(
				'name'      => 'all_element_colors',
				'default'   => '#eeb313',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Elements Color', 'roof'),
					'description'    => esc_html__('This is theme primary color, means it\'ll affect all elements that have default color of our theme primary color.', 'roof'),
				),
			),
			array(
				'name'      => 'button_hover_colors',
				'default'   => '#d59f0e',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Button Hover Color', 'roof'),
					'description'    => esc_html__('This affect all button\' hover color.', 'roof'),
				),
			),
	    // Fields End

	  )
	);
	// Primary Color

	// Topbar Color
	$options[]      = array(
	  'name'        => 'topbar_color_section',
	  'title'       => esc_html__('01. Topbar Colors', 'roof'),
	  'settings'    => array(

	    // Fields Start
	    array(
				'name'          => 'topbar_bg_heading',
				'control'       => array(
					'type'        => 'cs_field',
					'options'     => array(
						'type'      => 'notice',
						'class'     => 'info',
						'content'   => esc_html__('Bar Color', 'roof'),
					),
				),
			),
			array(
				'name'      => 'topbar_bg_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Background Color', 'roof'),
				),
			),
			array(
				'name'          => 'topbar_text_heading',
				'control'       => array(
					'type'        => 'cs_field',
					'options'     => array(
						'type'      => 'notice',
						'class'     => 'info',
						'content'   => esc_html__('Common Color', 'roof'),
					),
				),
			),
			array(
				'name'      => 'topbar_text_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Text Color', 'roof'),
				),
			),
			array(
				'name'      => 'topbar_link_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Link Color', 'roof'),
				),
			),
			array(
				'name'      => 'topbar_link_hover_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Link Hover Color', 'roof'),
				),
			),
			array(
				'name'          => 'topbar_country_menu',
				'control'       => array(
					'type'        => 'cs_field',
					'options'     => array(
						'type'      => 'notice',
						'class'     => 'info',
						'content'   => esc_html__('Country Menu Color', 'roof'),
					),
				),
			),
			array(
				'name'      => 'country_link_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Country Menu Link Color', 'roof'),
				),
			),
			array(
				'name'      => 'country_link_hover_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Country Menu Link hover Color', 'roof'),
				),
			),
			array(
				'name'      => 'country_bg_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Country Menu Background Color', 'roof'),
				),
			),
			array(
				'name'      => 'country_border_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Country Menu border Color', 'roof'),
				),
			),
	    // Fields End

	  )
	);
	// Topbar Color

	// Header Color
	$options[]      = array(
	  'name'        => 'header_color_section',
	  'title'       => esc_html__('02. Header Colors', 'roof'),
	  'sections'    => array(

  	array(
      'name'          => 'normal_header_section',
      'title'         => esc_html__('Desktop Menu', 'roof'),
      'settings'      => array(

		    // Fields Start
				array(
					'name'          => 'header_main_menu_heading',
					'control'       => array(
						'type'        => 'cs_field',
						'options'     => array(
							'type'      => 'notice',
							'class'     => 'info',
							'content'   => esc_html__('Main Menu Colors', 'roof'),
						),
					),
				),
				array(
					'name'      => 'menu_bg_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Background Color', 'roof'),
					),
				),
				array(
					'name'      => 'menu_link_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Color', 'roof'),
					),
				),
				array(
					'name'      => 'menu_link_hover_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Hover Color', 'roof'),
					),
				),

				// Sub Menu Color
				array(
					'name'          => 'header_submenu_heading',
					'control'       => array(
						'type'        => 'cs_field',
						'options'     => array(
							'type'      => 'notice',
							'class'     => 'info',
							'content'   => esc_html__('Sub-Menu Colors', 'roof'),
						),
					),
				),
				array(
					'name'      => 'submenu_bg_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Background Color', 'roof'),
					),
				),
				array(
					'name'      => 'submenu_border_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Border Color', 'roof'),
					),
				),
				array(
					'name'      => 'submenu_link_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Color', 'roof'),
					),
				),
				array(
					'name'      => 'submenu_link_hover_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Hover Color', 'roof'),
					),
				),
				array(
					'name'          => 'topbar_social_heading',
					'control'       => array(
						'type'        => 'cs_field',
						'options'     => array(
							'type'      => 'notice',
							'class'     => 'info',
							'content'   => esc_html__('Social Icon Color', 'roof'),
						),
					),
				),
				array(
					'name'      => 'topbar_social_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Social Icon Color', 'roof'),
					),
				),
				array(
					'name'      => 'topbar_social_bg_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Social Icons background Color', 'roof'),
					),
				),
				array(
					'name'      => 'topbar_social_bg_hover_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Social Icons background hover Color', 'roof'),
					),
				),
		    // Fields End

	    )
	  ),

	  array(
      'name'          => 'normal_header_section',
      'title'         => esc_html__('Desktop Menu', 'roof'),
      'settings'      => array(

		    // Fields Start
				array(
					'name'          => 'header_main_menu_heading',
					'control'       => array(
						'type'        => 'cs_field',
						'options'     => array(
							'type'      => 'notice',
							'class'     => 'info',
							'content'   => esc_html__('Main Menu Colors', 'roof'),
						),
					),
				),
				array(
					'name'      => 'menu_bg_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Background Color', 'roof'),
					),
				),
				array(
					'name'      => 'menu_link_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Color', 'roof'),
					),
				),
				array(
					'name'      => 'menu_link_hover_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Hover Color', 'roof'),
					),
				),

				// Sub Menu Color
				array(
					'name'          => 'header_submenu_heading',
					'control'       => array(
						'type'        => 'cs_field',
						'options'     => array(
							'type'      => 'notice',
							'class'     => 'info',
							'content'   => esc_html__('Sub-Menu Colors', 'roof'),
						),
					),
				),
				array(
					'name'      => 'submenu_bg_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Background Color', 'roof'),
					),
				),
				array(
					'name'      => 'submenu_border_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Border Color', 'roof'),
					),
				),
				array(
					'name'      => 'submenu_link_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Color', 'roof'),
					),
				),
				array(
					'name'      => 'submenu_link_hover_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Link Hover Color', 'roof'),
					),
				),
				array(
					'name'          => 'topbar_social_heading',
					'control'       => array(
						'type'        => 'cs_field',
						'options'     => array(
							'type'      => 'notice',
							'class'     => 'info',
							'content'   => esc_html__('Social Icon Color', 'roof'),
						),
					),
				),
				array(
					'name'      => 'topbar_social_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Social Icon Color', 'roof'),
					),
				),
				array(
					'name'      => 'topbar_social_bg_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Social Icons background Color', 'roof'),
					),
				),
				array(
					'name'      => 'topbar_social_bg_hover_color',
					'control'   => array(
						'type'  => 'color',
						'label' => esc_html__('Social Icons background hover Color', 'roof'),
					),
				),
		    // Fields End

	    )
	  ),
	  array(
	      'name'          => 'mobile_menu_section',
	      'title'         => esc_html__('Mobile Menu', 'roof'),
	      'settings'      => array(
	      	array(
						'name'          => 'mobile_menu_heading',
						'control'       => array(
							'type'        => 'cs_field',
							'options'     => array(
								'type'      => 'notice',
								'class'     => 'info',
								'content'   => esc_html__('Mobile Menu Colors', 'roof'),
							),
						),
					),
					array(
						'name'      => 'mobile_menu_toggle_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Menu Toggle Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_bg_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Background Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_bg_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Background Hover Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_link_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Link Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_link_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Link Hover Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_border_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Border Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_expand_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Menu Expand Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_expand_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Menu Expand Hover Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_expand_bg_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Menu Expand Background Color', 'roof'),
						),
					),
					array(
						'name'      => 'mobile_menu_expand_bg_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Menu Expand Background Hover Color', 'roof'),
						),
					),
				)
      ),

	  // BG
	   array(
	      'name'          => 'bg_menu_section',
	      'title'         => esc_html__('Background Color', 'roof'),
	      'settings'      => array(
	      	array(
						'name'          => 'header_bg_color',
						'control'       => array(
							'type'        => 'cs_field',
							'options'     => array(
								'type'      => 'notice',
								'class'     => 'info',
								'content'   => esc_html__('Background Color', 'roof'),
							),
						),
					),
					array(
						'name'      => 'header_bg_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Normal Header Background Color', 'roof'),
						),
					),
					array(
						'name'      => 'trans_header_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Transparent Background Color', 'roof'),
						),
					),

				)
      ),

	  )
	);
	// Header Color

	// Title Bar Color
	$options[]      = array(
	  'name'        => 'titlebar_section',
	  'title'       => esc_html__('03. Title Bar Colors', 'roof'),
    'settings'      => array(

    	// Fields Start
    	array(
				'name'          => 'titlebar_colors_heading',
				'control'       => array(
					'type'        => 'cs_field',
					'options'     => array(
						'type'      => 'notice',
						'class'     => 'info',
						'content'   => __('<h2 style="margin: 0;text-align: center;">Title Colors</h2> <br /> This is common settings, if this settings not affect in your page. Please check your page metabox. You may set default settings there.', 'roof'),
					),
				),
			),
    	array(
				'name'      => 'titlebar_title_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Title Color', 'roof'),
				),
			),

			array(
				'name'          => 'titlebar_breadcrumbs_heading',
				'control'       => array(
					'type'        => 'cs_field',
					'options'     => array(
						'type'      => 'notice',
						'class'     => 'info',
						'content'   => esc_html__('Breadcrumbs Colors', 'roof'),
					),
				),
			),
    	array(
				'name'      => 'breadcrumbs_text_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Text Color', 'roof'),
				),
			),
			array(
				'name'      => 'breadcrumbs_link_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Link Color', 'roof'),
				),
			),
			array(
				'name'      => 'breadcrumbs_link_hover_color',
				'control'   => array(
					'type'  => 'color',
					'label' => esc_html__('Link Hover Color', 'roof'),
				),
			),
	    // Fields End

	  )
	);
	// Title Bar Color

	// Content Color
	$options[]      = array(
	  'name'        => 'content_section',
	  'title'       => esc_html__('04. Content Colors', 'roof'),
	  'description' => esc_html__('This is all about content area text and heading colors.', 'roof'),
	  'sections'    => array(

	  	array(
	      'name'          => 'content_text_section',
	      'title'         => esc_html__('Content Text', 'roof'),
	      'settings'      => array(

			    // Fields Start
			    array(
						'name'      => 'body_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Body & Content Color', 'roof'),
						),
					),
					array(
						'name'      => 'body_links_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Body Links Color', 'roof'),
						),
					),
					array(
						'name'      => 'body_link_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Body Links Hover Color', 'roof'),
						),
					),
					array(
						'name'          => 'sidebar_content_colors',
						'control'       => array(
							'type'        => 'cs_field',
							'options'     => array(
								'type'      => 'notice',
								'class'     => 'info',
								'content'   => esc_html__('Sidebar Colors', 'roof'),
							),
						),
					),
					array(
						'name'      => 'sidebar_content_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Sidebar Content Color', 'roof'),
						),
					),
					array(
						'name'      => 'sidebar_link_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Sidebar Link Color', 'roof'),
						),
					),
					array(
						'name'      => 'sidebar_link_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Sidebar Link Hover Color', 'roof'),
						),
					),
			    // Fields End
			  )
			),

			// Text Colors Section
			array(
	      'name'          => 'content_heading_section',
	      'title'         => esc_html__('Headings', 'roof'),
	      'settings'      => array(

	      	// Fields Start
					array(
						'name'      => 'content_heading_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Content Heading Color', 'roof'),
						),
					),
	      	array(
						'name'      => 'sidebar_heading_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Sidebar Heading Color', 'roof'),
						),
					),
			    // Fields End

      	)
      ),

	  )
	);
	// Content Color

	// Footer Color
	$options[]      = array(
	  'name'        => 'footer_section',
	  'title'       => esc_html__('05. Footer Colors', 'roof'),
	  'description' => esc_html__('This is all about footer settings. Make sure you\'ve enabled your needed section at : Roof > Theme Options > Footer ', 'roof'),
	  'sections'    => array(

			// Footer Widgets Block
	  	array(
	      'name'          => 'footer_widget_section',
	      'title'         => esc_html__('Widget Block', 'roof'),
	      'settings'      => array(

			    // Fields Start
					array(
			      'name'          => 'footer_widget_color_notice',
			      'control'       => array(
			        'type'        => 'cs_field',
			        'options'     => array(
			          'type'      => 'notice',
			          'class'     => 'info',
			          'content'   => esc_html__('Content Colors', 'roof'),
			        ),
			      ),
			    ),
					array(
						'name'      => 'footer_heading_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Widget Heading Color', 'roof'),
						),
					),
					array(
						'name'      => 'footer_text_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Widget Text Color', 'roof'),
						),
					),
					array(
						'name'      => 'footer_link_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Widget Link Color', 'roof'),
						),
					),
					array(
						'name'      => 'footer_link_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Widget Link Hover Color', 'roof'),
						),
					),
					array(
						'name'      => 'footer_bg_color',
						'default'   => '#222327',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Background Color', 'roof'),
						),
					),
			    // Fields End
			  )
			),
			// Footer Widgets Block

			// Footer Copyright Block
	  	array(
	      'name'          => 'footer_copyright_section',
	      'title'         => esc_html__('Copyright Block', 'roof'),
	      'settings'      => array(

			    // Fields Start
			    array(
			      'name'          => 'footer_copyright_active',
			      'control'       => array(
			        'type'        => 'cs_field',
			        'options'     => array(
			          'type'      => 'notice',
			          'class'     => 'info',
			          'content'   => __('Make sure you\'ve enabled copyright block in : <br /> <strong>Roof > Theme Options > Footer > Copyright Bar : Enable Copyright Block</strong>', 'roof'),
			        ),
			      ),
			    ),
					array(
						'name'      => 'copyright_text_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Text Color', 'roof'),
						),
					),
					array(
						'name'      => 'copyright_link_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Link Color', 'roof'),
						),
					),
					array(
						'name'      => 'copyright_link_hover_color',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Link Hover Color', 'roof'),
						),
					),
					array(
						'name'      => 'copyright_bg_color',
						'default'   => '#21252a',
						'control'   => array(
							'type'  => 'color',
							'label' => esc_html__('Background Color', 'roof'),
						),
					),

			  )
			),
			// Footer Copyright Block

	  )
	);
	// Footer Color

	return $options;

  }
  add_filter( 'cs_customize_options', 'roof_vt_customizer' );
}