<?php
/*
 * All Front-End Helper Functions
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

/* Exclude category from blog */
function roof_vt_excludeCat($query) {
	if ( $query->is_home ) {
		$exclude_cat_ids = cs_get_option('theme_exclude_categories');
		if($exclude_cat_ids) {
			foreach( $exclude_cat_ids as $exclude_cat_id ) {
				$exclude_from_blog[] = '-'. $exclude_cat_id;
			}
			$query->set('cat', implode(',', $exclude_from_blog));
		}
	}
	return $query;
}
add_filter('pre_get_posts', 'roof_vt_excludeCat');

/* Include Default value for dropdown in contact form7*/
function my_wpcf7_form_elements($html) {
    $text = 'Choose';
    $html = str_replace('---',  $text , $html);
    return $html;
}
add_filter('wpcf7_form_elements', 'my_wpcf7_form_elements');


/* Excerpt Length */
class RoofExcerpt {

  // Default length (by WordPress)
  public static $length = 55;

  // Output: roof_excerpt('short');
  public static $types = array(
    'short' => 25,
    'regular' => 55,
    'long' => 100
  );

  /**
   * Sets the length for the excerpt,
   * then it adds the WP filter
   * And automatically calls the_excerpt();
   *
   * @param string $new_length
   * @return void
   * @author Baylor Rae'
   */
  public static function length($new_length = 55) {
    RoofExcerpt::$length = $new_length;
    add_filter('excerpt_length', 'RoofExcerpt::new_length');
    RoofExcerpt::output();
  }

  // Tells WP the new length
  public static function new_length() {
    if( isset(RoofExcerpt::$types[RoofExcerpt::$length]) )
      return RoofExcerpt::$types[RoofExcerpt::$length];
    else
      return RoofExcerpt::$length;
  }

  // Echoes out the excerpt
  public static function output() {
    the_excerpt();
  }

}

// Custom Excerpt Length
function roof_excerpt($length = 55) {
  RoofExcerpt::length($length);
}

if ( ! function_exists( 'roof_new_excerpt_more' ) ) {
  function roof_new_excerpt_more( $more ) {
    return '[...]';
  }
  add_filter('excerpt_more', 'roof_new_excerpt_more');
}

/* Tag Cloud Widget - Remove Inline Font Size */
function roof_vt_tag_cloud($tag_string){
  return preg_replace("/style='font-size:.+pt;'/", '', $tag_string);
}
add_filter('wp_generate_tag_cloud', 'roof_vt_tag_cloud', 10, 3);

/* Password Form */
if( ! function_exists( 'roof_vt_password_form' ) ) {
  function roof_vt_password_form( $output ) {
    $output = str_replace( 'type="submit"', 'type="submit" class=""', $output );
    return $output;
  }
  add_filter('the_password_form' , 'roof_vt_password_form');
}

/* Maintenance Mode */
if( ! function_exists( 'roof_vt_maintenance_mode' ) ) {
  function roof_vt_maintenance_mode(){

    $maintenance_mode_page = cs_get_option( 'maintenance_mode_page' );
    $enable_maintenance_mode = cs_get_option( 'enable_maintenance_mode' );

    if ( isset($enable_maintenance_mode) && ! empty( $maintenance_mode_page ) && ! is_user_logged_in() ) {
      get_template_part('layouts/post/content', 'maintenance');
      exit;
    }

  }
  add_action( 'wp', 'roof_vt_maintenance_mode', 1 );
}

/* Widget Layouts */
if ( ! function_exists( 'roof_vt_footer_widgets' ) ) {
  function roof_vt_footer_widgets() {

    $output = '';
    $footer_widget_layout = cs_get_option('footer_widget_layout');

    if( $footer_widget_layout ) {

      switch ( $footer_widget_layout ) {
        case 1: $widget = array('piece' => 1, 'class' => 'col-md-12'); break;
        case 2: $widget = array('piece' => 2, 'class' => 'col-md-6'); break;
        case 3: $widget = array('piece' => 3, 'class' => 'col-md-4'); break;
        case 4: $widget = array('piece' => 4, 'class' => 'col-md-3 col-sm-6'); break;
        case 5: $widget = array('piece' => 3, 'class' => 'col-md-3', 'layout' => 'col-md-6', 'queue' => 1); break;
        case 6: $widget = array('piece' => 3, 'class' => 'col-md-3', 'layout' => 'col-md-6', 'queue' => 2); break;
        case 7: $widget = array('piece' => 3, 'class' => 'col-md-3', 'layout' => 'col-md-6', 'queue' => 3); break;
        case 8: $widget = array('piece' => 4, 'class' => 'col-md-2', 'layout' => 'col-md-6', 'queue' => 1); break;
        case 9: $widget = array('piece' => 4, 'class' => 'col-md-2', 'layout' => 'col-md-6', 'queue' => 4); break;
        default : $widget = array('piece' => 4, 'class' => 'col-md-3'); break;
      }

      for( $i = 1; $i < $widget["piece"]+1; $i++ ) {

        $widget_class = ( isset( $widget["queue"] ) && $widget["queue"] == $i ) ? $widget["layout"] : $widget["class"];

        $output .= '<div class="'. $widget_class .'">';
        ob_start();
        if (is_active_sidebar('footer-'. $i)) {
          dynamic_sidebar( 'footer-'. $i );
        }
        $output .= ob_get_clean();
        $output .= '</div>';

      }
    }

    return $output;

  }
}

if( ! function_exists( 'roof_vt_top_bar' ) ) {
  function roof_vt_top_bar() {

    $out     = '';

    if ( ( cs_get_option( 'top_left' ) || cs_get_option( 'top_right' ) ) ) {
      $out .= '<div class="roof-topbar"><div class="container"><div class="row">';
      $out .= roof_vt_top_bar_modules( 'left' );
      $out .= roof_vt_top_bar_modules( 'right' );
      $out .= '</div></div></div>';
    }

    return $out;
  }
}

/* WP Link Pages */
if ( ! function_exists( 'roof_wp_link_pages' ) ) {
  function roof_wp_link_pages() {
    $defaults = array(
      'before'           => '<div class="wp-link-pages">' . esc_html__( 'Pages:', 'roof' ),
      'after'            => '</div>',
      'link_before'      => '<span>',
      'link_after'       => '</span>',
      'next_or_number'   => 'number',
      'separator'        => ' ',
      'pagelink'         => '%',
      'echo'             => 1
    );
    wp_link_pages( $defaults );
  }
}

/* Share Options */
if ( ! function_exists( 'roof_wp_share_option' ) ) {
  function roof_wp_share_option() {

    global $post;
    $page_url = get_permalink($post->ID );
    $title = $post->post_title;
    $share_text = cs_get_option('share_text');
    $share_text = $share_text ? $share_text : esc_html__( 'Share', 'roof' );
    $share_on_text = cs_get_option('share_on_text');
    $share_on_text = $share_on_text ? $share_on_text : esc_html__( 'Share On', 'roof' );
    $blog_share_expand = cs_get_option('blog_share_expand');

    if($blog_share_expand === 'open-right'){
      $share_class = 'style-two';
    } else {
      $share_class = '';
    }
    ?>

    <div class="link-inner">
      <i class="icon-share icons"></i>
      <h6 class="link-title"><?php echo esc_attr($share_text); ?></h6>
    </div>
    <div class="share-links <?php echo esc_attr($share_class); ?>">
        <a href="//twitter.com/intent/tweet?text=<?php print(urlencode($title)); ?>&url=<?php print(urlencode($page_url)); ?>" class="icon-fa-twitter" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Twitter', 'roof'); ?>" target="_blank"><i class="fa fa-twitter"></i><h6 class="link-title"><?php echo esc_attr('Twitter', 'roof'); ?></h6></a>

        <a href="//www.facebook.com/sharer/sharer.php?u=<?php print(urlencode($page_url)); ?>&amp;t=<?php print(urlencode($title)); ?>" class="icon-fa-facebook" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Facebook', 'roof'); ?>" target="_blank"><i class="fa fa-facebook"></i><h6 class="link-title"><?php echo esc_attr('Facebook', 'roof'); ?></h6></a>

        <a href="//www.linkedin.com/shareArticle?mini=true&amp;url=<?php print(urlencode($page_url)); ?>&amp;title=<?php print(urlencode($title)); ?>" class="icon-fa-linkedin" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $share_on_text .' '); echo esc_attr('Linkedin', 'roof'); ?>" target="_blank"><i class="fa fa-linkedin"></i><h6 class="link-title"><?php echo esc_attr('Linkedin', 'roof'); ?></h6></a>

    </div>

<?php
  }
}

/* Single Gallery Pagination */
if ( ! function_exists( 'roof_single_portfolio_navigation' ) ) {
  function roof_single_portfolio_navigation() {
      $prev_post = get_previous_post();
      $next_post = get_next_post();
      $gallery_home_link = cs_get_option('gallery_home_link');
      $roof_prev_galry = cs_get_option('prev_port');
      $roof_next_galry = cs_get_option('next_port');
      $roof_prev_galry = ($roof_prev_galry) ? $roof_prev_galry : esc_html__('Previous', 'roof');
      $roof_next_galry = ($roof_next_galry) ? $roof_next_galry : esc_html__('Next', 'roof');
      ?>
      <div class="portfolio-controls">
        <div class="row align-items-center">
          <div class="col-md-6">
        <?php if($prev_post) {
            echo '<a href="' . esc_url(get_permalink($prev_post->ID)) . '" class="portfolio-control-link">';
              echo'<span class="control-link-info">
                <i class="fa fa-angle-double-left" aria-hidden="true"></i> <span class="control-link">'.esc_html($roof_prev_galry).'</span>
              </span>
            </a>';
         }
          echo '</div>';
        if($next_post) {
          echo'<div class="col-md-6 textright">
            <a href="'. esc_url(get_permalink($next_post->ID)) .'" class="portfolio-control-link">
              <span class="control-link-info">
                <span class="control-link">'.esc_html($roof_next_galry).'</span> <i class="fa fa-angle-double-right" aria-hidden="true"></i>
              </span>';
            echo'</a>
          </div>';
        } ?>
        </div>
      </div>
  <?php
  }
}

/* Exclude category from blog */
if( ! function_exists( 'roof_excludeCat' ) ) {
  function roof_excludeCat($query) {
    if ( $query->is_home ) {
      $exclude_cat_ids = cs_get_option('theme_exclude_categories');
      if($exclude_cat_ids) {
        foreach( $exclude_cat_ids as $exclude_cat_id ) {
          $exclude_from_blog[] = '-'. $exclude_cat_id;
        }
        $query->set('cat', implode(',', $exclude_from_blog));
      }
    }
    return $query;
  }
  add_filter('pre_get_posts', 'roof_excludeCat');
}

/* Metas (Date & Share)*/
if ( ! function_exists( 'roof_post_meta' ) ) {
  function roof_post_meta() {
  $metas_hide = (array) cs_get_option( 'theme_metas_hide' );
  $roof_single_share_option = cs_get_option('single_share_option');
  ?>
  <div class="blog-links-wrap">
    <?php
    if ( !in_array( 'date', $metas_hide ) ) { // Category Hide
      echo'<div class="blog-link"><div class="link-inner">
        <h2 class="blog-date">
          '.get_the_date('d').'
        </h2>
        <h6 class="link-title">
          '.get_the_date('M').'
        </h6>
      </div></div>';
    } // Category Hides
    if ( !in_array( 'share', $metas_hide ) ) { // Date Hide
      if($roof_single_share_option) { ?>
      <div class="blog-link share"><?php roof_wp_share_option(); ?></div>
       <?php }
    } // Date Hides ?>

  </div>
  <?php
  }
}
// Metas (author , comments , categories)
if ( ! function_exists( 'roof_post_metas' ) ) {
  function roof_post_metas() {
    global $post;
  $metas_hide = (array) cs_get_option( 'theme_metas_hide' );
  $posted_by_text = cs_get_option('posted_by_text');
    if($posted_by_text){
      $posted_txt = $posted_by_text;
    } else {
      $posted_txt = esc_html__('Posted by', 'roof');
    }
  ?>
  <h6 class="blog-meta">
    <?php
    if ( !in_array( 'author', $metas_hide ) ) { // Author Hide ?>
      <span class="meta-author"><?php echo esc_attr($posted_txt); ?> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>"><?php the_author(); ?></a></span>
    <?php } // Author Hide

    if ( !in_array( 'comments', $metas_hide ) ) { // Date Hide ?>
      <span><?php comments_popup_link(); ?></span>
    <?php } // Date Hides

    if ( !in_array( 'category', $metas_hide ) ) { // Date Hide ?>
      <span><?php echo get_the_category_list( ', ', '', $post->ID ); ?></span>
    <?php } // Date Hides ?>

  </h6>
  <?php
  }
}

/* Author Info */
if ( ! function_exists( 'roof_author_info' ) ) {
  function roof_author_info() {

    if (get_the_author_meta( 'url' )) {
      $author_url = get_author_posts_url( get_the_author_meta( 'ID' ) );
      $website_url = get_the_author_meta( 'url' );
      $target = 'target="_blank"';
    } else {
      $author_url = get_author_posts_url( get_the_author_meta( 'ID' ) );
      $website_url = get_author_posts_url( get_the_author_meta( 'ID' ) );
      $target = '';
    }

    // variables
    $author_text = cs_get_option('author_text');
    $author_text = $author_text ? $author_text : esc_html__( 'Author', 'roof' );
    $author_content = get_the_author_meta( 'description' );
if ($author_content) {
?>

  <div class="roof-author-info">
    <div class="author-avatar">
      <a href="<?php echo esc_url($website_url); ?>" <?php echo esc_attr($target); ?>>
        <?php echo get_avatar( get_the_author_meta( 'ID' ), 80 ); ?>
      </a>
    </div>
    <div class="author-content">
      <div class="author-pro"><?php echo esc_attr($author_text); ?></div>
      <a href="<?php echo esc_url($author_url); ?>" class="author-name"><?php echo get_the_author_meta('first_name').' '.get_the_author_meta('last_name'); ?></a>
      <p><?php echo get_the_author_meta( 'description' ); ?></p>
       <!--post author socail start\-->
        <?php
        $facebook = get_the_author_meta('facebook');
        $twitter  = get_the_author_meta('twitter');
        $vine = get_the_author_meta('vine');
        $pinterest = get_the_author_meta('pinterest');
        $instagram = get_the_author_meta('instagram');
        ?>
        <div class="roof-social">
          <?php
          if(!empty($facebook)) {
          echo '<a href="'.$facebook.'" target="_blank"><i class="fa fa-facebook"></i></a>';
          }
           if(!empty($twitter)) {
          echo '<a href="'.$twitter.'" target="_blank"><i class="fa fa-twitter"></i></a>';
          }
          if(!empty($vine)) {
          echo '<a href="'.$vine.'" target="_blank"><i class="fa fa-vine"></i></a>';
          }
          if(!empty($pinterest)) {
          echo '<a href="'.$pinterest.'" target="_blank"><i class="fa fa-pinterest"></i></a>';
          }
          if(!empty($instagram)) {
          echo '<a href="'.$instagram.'" target="_blank"><i class="fa fa-instagram"></i></a>';
          }
         ?>
        </div>
    </div>
  </div>
<?php
} // if $author_content
  }
}

/* ==============================================
   Custom Comment Area Modification
=============================================== */
if ( ! function_exists( 'roof_comment_modification' ) ) {
  function roof_comment_modification($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);
    if ( 'div' == $args['style'] ) {
      $tag = 'div';
      $add_below = 'comment';
    } else {
      $tag = 'li';
      $add_below = 'div-comment';
    }
    $comment_class = empty( $args['has_children'] ) ? '' : 'parent';
  ?>

  <<?php echo esc_attr($tag); ?> <?php comment_class('item ' . $comment_class .' ' ); ?> id="comment-<?php comment_ID() ?>">
    <?php if ( 'div' != $args['style'] ) : ?>
    <div id="div-comment-<?php comment_ID() ?>" class="">
    <?php endif;
    $avatar = get_avatar(get_comment_author(), get_the_author_meta( 'ID' ) );
    if ($avatar) {?>
    <div class="comment-theme">
        <div class="comment-image">
          <?php if ( $args['avatar_size'] != 0 ) {
            echo get_avatar( $comment, 80 );
          } ?>
        </div>
    </div>
    <?php } ?>
    <div class="comment-main-area">
      <div class="roof-comments-meta">
        <h4><?php printf( '%s', get_comment_author() ); ?></h4>
        <span class="comments-date">
          <?php echo get_comment_date('d M Y'); echo ' - '; ?>
          <span class="caps"><?php echo get_comment_time(); ?></span>
        </span>
        <div class="comments-reply">
        <?php
          comment_reply_link( array_merge( $args, array(
          'reply_text' => '<span class="comment-reply-link">'. esc_html__('Reply','roof') .'</span>',
          'before' => '',
          'class'  => '',
          'depth' => $depth,
          'max_depth' => $args['max_depth']
          ) ) );
        ?>
        </div>
      </div>
      <?php if ( $comment->comment_approved == '0' ) : ?>
      <em class="comment-awaiting-moderation"><?php echo esc_html__( 'Your comment is awaiting moderation.', 'roof' ); ?></em>
      <?php endif; ?>
      <div class="comment-area">
        <?php comment_text(); ?>
      </div>
    </div>
  <?php if ( 'div' != $args['style'] ) : ?>
  </div>
  <?php endif;
  }
}

/* Comments Form - Textarea next to Normal Fields */
add_filter( 'comment_form_fields', 'roof_move_comment_field' );
function roof_move_comment_field( $fields ) {
  $comment_field = $fields['comment'];
  unset( $fields['comment'] );
  $fields['comment'] = $comment_field;
  return $fields;
}

/* Title Area */
if ( ! function_exists( 'roof_title_area' ) ) {
  function roof_title_area() {

    global $post, $wp_query;

    // Get post meta in all type of WP pages
    $roof_id    = ( isset( $post ) ) ? get_the_id() : 0;
    $roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
    $roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
    $roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );
    if ($roof_meta && (!is_archive() || is_woocommerce_shop())) {
      $custom_title = $roof_meta['page_custom_title'];
      if ($custom_title) {
        $custom_title = $custom_title;
      } elseif(post_type_archive_title()) {
        post_type_archive_title();
      } else {
        $custom_title = '';
      }
    } else { $custom_title = ''; }

    if( $custom_title ) {
      echo esc_attr($custom_title);
    } elseif ( is_home() ) {
      bloginfo('name');
    } elseif ( is_search() ) {
      printf( esc_html__( 'Search Results for: %s', 'roof' ), '<span>' . get_search_query() . '</span>' );
    } elseif ( is_category() || is_tax() ){
      single_cat_title();
    } elseif ( is_tag() ){
      single_tag_title(esc_html__('Posts Tagged: ', 'roof'));
    } elseif ( is_archive() ){
      if ( is_day() ) {
        printf( __( 'Archive for <span>%s</span>', 'roof' ), get_the_date());
      } elseif ( is_month() ) {
        printf( __( 'Archive for <span>%s</span>', 'roof' ), get_the_date( 'F, Y' ));
      } elseif ( is_year() ) {
        printf( __( 'Archive for <span>%s</span>', 'roof' ), get_the_date( 'Y' ));
      } elseif ( is_author() ) {
        printf( __( 'Posts by: <span>%s</span>', 'roof' ), get_the_author_meta( 'display_name', $wp_query->post->post_author ));
      } elseif( is_shop() ) {
        esc_html_e( 'Shop', 'roof' );
      } elseif ( is_post_type_archive() ) {
        post_type_archive_title();
      } else {
        _e( 'Archives', 'roof' );
      }
    } elseif( is_404() ) {
      _e('Page Not Found', 'roof');
    } else {
      the_title();
    }

  }
}

/**
 * Pagination Function
 */
if ( ! function_exists( 'roof_paging_nav' ) ) {
  function roof_paging_nav() {
    if ( function_exists('wp_pagenavi')) {
      wp_pagenavi();
    } else {
      $older_post = cs_get_option('older_post');
      $newer_post = cs_get_option('newer_post');
      $older_post = $older_post ? $older_post : esc_html__( 'OLDER POSTS', 'roof' );
      $newer_post = $newer_post ? $newer_post : esc_html__( 'NEWER POSTS', 'roof' );
        global $wp_query;

        $big = 999999999; // need an unlikely integer

        $pages = paginate_links( array(
          'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
          'prev_text' => 'PREV',
          'next_text' => 'NEXT',
          'format' => '?paged=%#%',
          'current' => max( 1, get_query_var('paged') ),
          'total' => $wp_query->max_num_pages,
          'type'  => 'array',
        ) );
        if( is_array( $pages ) ) {
          $paged = ( get_query_var('paged') == 0 ) ? 1 : get_query_var('paged');
          echo '<div class="roof-pagination">';
          foreach ( $pages as $page ) {
            echo "$page";
          }
         echo '</div>';
        }

      if($wp_query->max_num_pages == '1' ) {} else {echo '';}
    }
  }
}