<?php
/*
 * All CSS and JS files are enqueued from this file
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

/**
 * Enqueue Files for FrontEnd
 */
if ( ! function_exists( 'roof_vt_scripts_styles' ) ) {
  function roof_vt_scripts_styles() {

    // Styles
    wp_enqueue_style( 'bootstrap', ROOF_CSS .'/bootstrap.min.css', array(), '4.5.3', 'all' );
    wp_enqueue_style( 'simple-line-icons', ROOF_CSS .'/simple-line-icons.css', array(), '2.4.0', 'all' );
    wp_enqueue_style( 'font-awesome', ROOF_CSS .'/font-awesome.min.css', array(), '4.6.3', 'all' );
    wp_enqueue_style( 'own-carousel', ROOF_CSS .'/owl.carousel.css', array(), '2.1.6', 'all' );
    wp_enqueue_style( 'meanmenu', ROOF_CSS . '/meanmenu.min.css', array(), ROOF_VERSION, 'all' );
    wp_enqueue_style( 'admin', ROOF_CSS .'/admin-styles.css', array(), ROOF_VERSION, 'all' );
    wp_enqueue_style( 'magnific-popup', ROOF_CSS .'/magnific-popup.css', array(), ROOF_VERSION, 'all' );
    wp_enqueue_style( 'slick-theme', ROOF_CSS .'/slick-theme.css', array(), ROOF_VERSION, 'all' );
    wp_enqueue_style( 'slick', ROOF_CSS .'/slick.css', array(), ROOF_VERSION, 'all' );
    wp_enqueue_style( 'slider', ROOF_CSS .'/slider.css', array(), ROOF_VERSION, 'all' );
    wp_enqueue_style( 'swiper', ROOF_CSS .'/swiper.min.css', array(), ROOF_VERSION, 'all' );

    // WooCommerce
    if (class_exists( 'WooCommerce' )){
      wp_enqueue_style( 'woocommerce-layout', ROOF_THEMEROOT_URI . '/inc/plugins/woocommerce/woocommerce-layout.css', null, 1.0, 'all' );
      wp_enqueue_style( 'woocommerce', ROOF_THEMEROOT_URI . '/inc/plugins/woocommerce/woocommerce.css', null, 1.0, 'all' );
    }

    wp_enqueue_style( 'roof-style', ROOF_CSS .'/styles.css', array(), ROOF_VERSION, 'all' );

    // Scripts
    wp_enqueue_script( 'bootstrap', ROOF_SCRIPTS . '/bootstrap.min.js', array( 'jquery' ), '4.5.3', true );
    wp_enqueue_script( 'bootstrap-hover-dropdown', ROOF_SCRIPTS . '/bootstrap.hover.dropdown.js', array( 'jquery' ), '2.2.1', true );
    wp_enqueue_script( 'plugins', ROOF_SCRIPTS . '/plugins.js', array( 'jquery' ), ROOF_VERSION, true );
    wp_enqueue_script( 'scripts', ROOF_SCRIPTS . '/scripts.js', array( 'jquery' ), ROOF_VERSION, true );

    // Comments
    wp_enqueue_script( 'validate', ROOF_SCRIPTS . '/jquery.validate.min.js', array( 'jquery' ), '1.9.0', true );
    wp_add_inline_script( 'validate', 'jQuery(document).ready(function($) {$("#commentform").validate({rules: {author: {required: true,minlength: 2},email: {required: true,email: true},comment: {required: true,minlength: 10}}});});' );

    // Responsive Active
    $roof_viewport = cs_get_option('theme_responsive');
    if($roof_viewport == 'on') {
      wp_enqueue_style( 'roof-responsive', ROOF_CSS .'/responsive.css', array(), ROOF_VERSION, 'all' );
    }

    // Custom Colors
    // wp_enqueue_style( 'custom-color', ROOF_CSS .'/custom-color.css', array(), ROOF_VERSION, 'all' );

    // Adds support for pages with threaded comments
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
    }

  }
  add_action( 'wp_enqueue_scripts', 'roof_vt_scripts_styles' );
}

/**
 * Enqueue Files for BackEnd
 */
if ( ! function_exists( 'roof_vt_admin_scripts_styles' ) ) {
  function roof_vt_admin_scripts_styles() {

    wp_enqueue_style( 'admin-main', ROOF_CSS . '/admin-styles.css', true );
    wp_enqueue_style( 'simple-line-icons', ROOF_CSS . '/simple-line-icons.css', true );
    wp_enqueue_script( 'admin-scripts', ROOF_SCRIPTS . '/admin-scripts.js', true );

  }
  add_action( 'admin_enqueue_scripts', 'roof_vt_admin_scripts_styles' );
}

/* Enqueue All Styles */
if ( ! function_exists( 'roof_vt_wp_enqueue_styles' ) ) {
  function roof_vt_wp_enqueue_styles() {
    roof_vt_google_fonts();
    add_action( 'wp_head', 'roof_vt_custom_css', 99 );
  }
  add_action( 'wp_enqueue_scripts', 'roof_vt_wp_enqueue_styles' );
}
