<?php
/*
 * The header for our theme.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */
?><!DOCTYPE html>
<!--[if IE 8]> <html <?php language_attributes(); ?> class="ie8"> <![endif]-->
<!--[if !IE]><!--> <html <?php language_attributes(); ?>> <!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<?php
$roof_viewport = cs_get_option('theme_responsive');
if($roof_viewport == 'on') { ?>
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<?php } else { }

// if the `wp_site_icon` function does not exist (ie we're on < WP 4.3)
if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) {
  if (cs_get_option('brand_fav_icon')) {
    echo '<link rel="shortcut icon" href="'. esc_url(wp_get_attachment_url(cs_get_option('brand_fav_icon'))) .'" />';
  } else { ?>
    <link rel="shortcut icon" href="<?php echo esc_url(ROOF_IMAGES); ?>/favicon.png" />
  <?php }
  if (cs_get_option('iphone_icon')) {
    echo '<link rel="apple-touch-icon" sizes="57x57" href="'. esc_url(wp_get_attachment_url(cs_get_option('iphone_icon'))) .'" >';
  }
  if (cs_get_option('iphone_retina_icon')) {
    echo '<link rel="apple-touch-icon" sizes="114x114" href="'. esc_url(wp_get_attachment_url(cs_get_option('iphone_retina_icon'))) .'" >';
    echo '<link name="msapplication-TileImage" href="'. esc_url(wp_get_attachment_url(cs_get_option('iphone_retina_icon'))) .'" >';
  }
  if (cs_get_option('ipad_icon')) {
    echo '<link rel="apple-touch-icon" sizes="72x72" href="'. esc_url(wp_get_attachment_url(cs_get_option('ipad_icon'))) .'" >';
  }
  if (cs_get_option('ipad_retina_icon')) {
    echo '<link rel="apple-touch-icon" sizes="144x144" href="'. esc_url(wp_get_attachment_url(cs_get_option('ipad_retina_icon'))) .'" >';
  }
}
$roof_all_element_color  = cs_get_customize_option( 'all_element_colors' );
?>
<meta name="msapplication-TileColor" content="<?php echo esc_attr($roof_all_element_color); ?>">
<meta name="theme-color" content="<?php echo esc_attr($roof_all_element_color); ?>">

<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">

<?php
// Metabox
global $post;
$roof_id    = ( isset( $post ) ) ? $post->ID : false;
$roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
$roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id('shop') : $roof_id;
$roof_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('testimonial') ) ? $roof_id : false;
$roof_meta  = get_post_meta( $roof_id, 'page_type_metabox', true );

// Parallax
$roof_bg_parallax = cs_get_option('theme_bg_parallax');
$roof_hav_parallax = $roof_bg_parallax ? ' parallax-window' : '';
$roof_parallax_speed = cs_get_option('theme_bg_parallax_speed');
$roof_bg_parallax_speed = $roof_parallax_speed ? $roof_parallax_speed : '0.4';

// Theme Layout Width
$roof_bg_overlay_color  = cs_get_option( 'theme_bg_overlay_color' );
$roof_layout_width  = cs_get_option( 'theme_layout_width' );
$roof_layout_width_class = ($roof_layout_width === 'container') ? 'layout-boxed'. $roof_hav_parallax : 'layout-full';

// Header Style
if ($roof_meta) {
  $roof_header_design  = $roof_meta['select_header_design'];
  $roof_sticky_header  = $roof_meta['sticky_header'];
} else {
  $roof_header_design  = cs_get_option('select_header_design');
  $roof_sticky_header  = cs_get_option('sticky_header');
}
if ($roof_header_design === 'default') {
  $roof_header_design_actual  = cs_get_option('select_header_design');
} else {
  $roof_header_design_actual = ( $roof_header_design ) ? $roof_header_design : cs_get_option('select_header_design');
}
if ($roof_meta && $roof_header_design !== 'default') {
  $roof_sticky_header  = $roof_meta['sticky_header'];
} else {
  $roof_sticky_header  = cs_get_option('sticky_header');
}
if ($roof_header_design_actual === 'style_two') {
  $roof_header_class = 'roof-style-two ';
} else {
  $roof_header_class = 'roof-style-one ';
}

$roof_sticky_header_class = $roof_sticky_header ? ' roof-header-sticky ' : '';

// Header Transparent
if ($roof_meta && $roof_header_design !== 'default') {
  $roof_transparent_header = $roof_meta['transparency_header'];
  $roof_transparent_header = $roof_transparent_header ? ' header-style-three ' : ' header-dhav-trspt ';
  // Shortcode Banner Type
  $roof_banner_type = $roof_meta['banner_type'];
} elseif ($roof_header_design_actual === 'style_two') {
  $roof_transparent_header_option = cs_get_option('transparent_header_option');
  $roof_transparent_header = $roof_transparent_header_option ? ' header-style-three ' : ' header-dhav-trspt ';
  $roof_banner_type = '';
} else {
  $roof_banner_type = '';
  $roof_transparent_header = '';
}

wp_head();
?>
</head>
<body <?php echo body_class(); ?>>
<?php
if ($roof_bg_parallax) { ?>
  <div class="<?php echo esc_attr($roof_layout_width_class); ?>" data-stellar-background-ratio="<?php echo esc_attr($roof_bg_parallax_speed); ?>">
<?php } else {?>
  <div class="<?php echo esc_attr($roof_layout_width_class); ?>">
<?php } ?>

  <?php if($roof_bg_overlay_color) { ?>
    <div class="layout-overlay" style="background-color: <?php echo esc_attr($roof_bg_overlay_color); ?>;"></div>
  <?php } ?>
  <div id="vtheme-wrapper">
<!-- Roof Top Bar, Top Bar Style Two -->
 <?php get_template_part( 'layouts/header/top', 'bar' );

  if ($roof_meta) {
    $roof_hide_header = $roof_meta['hide_header'];
  } else { $roof_hide_header = ''; }

  // Header Style
  if($roof_header_design_actual === 'style_one'){
    if ($roof_meta && $roof_header_design !== 'default') {
      $roof_address_info  = $roof_meta['header_address_info'];
    } else {
      $roof_address_info  = cs_get_option('header_address_info');
    }
  }
 if($roof_header_design_actual === 'style_one'){
  if (!$roof_hide_header) { // Hide Header - Metabox
    ?>

<!-- Roof Header, Header Style Two -->

<header class="roof-header <?php echo esc_attr($roof_header_class .$roof_banner_type); ?>">
<div class="roof-add-section">
  <div class="container">

    <?php
    // Brand Logo
    get_template_part( 'layouts/header/logo' ); ?>
    <div class="header-right">
      <!-- <a href="javascript:void(0);" class="roof-toggle"><span></span></a> -->
    </div>
    <?php echo do_shortcode($roof_address_info);
    ?>
  </div>
  </div>
  <?php get_template_part( 'layouts/header/menu', 'bar' ); ?>
</header>

<!-- Roof Menu, Menu Style Two -->
<?php  }

} else {
  if (!$roof_hide_header) { // Hide Header - Metabox?>
<header class="roof-header <?php echo esc_attr($roof_header_class . $roof_sticky_header_class . $roof_transparent_header .  $roof_banner_type); ?>">
  <div class="container">
    <?php
    // Brand Logo
    get_template_part( 'layouts/header/logo' ); ?>
    <div class="header-right">
      <!-- <a href="javascript:void(0);" class="roof-toggle"><span></span></a> -->
    </div>
    <?php
      get_template_part( 'layouts/header/menu', 'bar' );
     ?>
  </div>
</header>

<!-- Roof Menu, Menu Style Two -->
<?php  }
}
