<?php
/*
 * Roof Theme's Functions
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

/**
 * Define - Folder Paths
 */
define( 'ROOF_THEMEROOT_PATH', get_template_directory() );
define( 'ROOF_THEMEROOT_URI', get_template_directory_uri() );
define( 'ROOF_CSS', ROOF_THEMEROOT_URI . '/assets/css' );
define( 'ROOF_IMAGES', ROOF_THEMEROOT_URI . '/assets/images' );
define( 'ROOF_SCRIPTS', ROOF_THEMEROOT_URI . '/assets/js' );
define( 'ROOF_FRAMEWORK', get_template_directory() . '/inc' );
define( 'ROOF_LAYOUT', get_template_directory() . '/layouts' );
define( 'ROOF_CS_IMAGES', ROOF_THEMEROOT_URI . '/inc/theme-options/theme-extend/images' );
define( 'ROOF_CS_FRAMEWORK', get_template_directory() . '/inc/theme-options/theme-extend' ); // Called in Icons field *.json
define( 'ROOF_ADMIN_PATH', get_template_directory() . '/inc/theme-options/cs-framework' ); // Called in Icons field *.json

/**
 * Define - Global Theme Info's
 */
if (is_child_theme()) { // If Child Theme Active
	$roof_theme_child = wp_get_theme();
	$roof_get_parent = $roof_theme_child->Template;
	$roof_theme = wp_get_theme($roof_get_parent);
} else { // Parent Theme Active
	$roof_theme = wp_get_theme();
}
define('ROOF_NAME', $roof_theme->get( 'Name' ));
define('ROOF_VERSION', $roof_theme->get( 'Version' ));
define('ROOF_BRAND_URL', $roof_theme->get( 'AuthorURI' ));
define('ROOF_BRAND_NAME', $roof_theme->get( 'Author' ));

/**
 * All Main Files Include
 */
require_once( ROOF_FRAMEWORK . '/init.php' );
