<?php
/*
 * The template for displaying archive pages.
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */
get_header();
get_template_part( 'layouts/header/title', 'bar' );
 if (is_post_type('portfolio')) {

$roof_sidebar_position = cs_get_option('blog_sidebar_position');?>

<div class="container roof-main-wrap">
	<div class="row">
					<div class="roof-primary">

			<?php
			$portfolio_style        = cs_get_option('portfolio_style');
			$portfolio_column       = cs_get_option('portfolio_column');
			$portfolio_order        = cs_get_option('portfolio_order');
			$portfolio_orderby      = cs_get_option('portfolio_orderby');
			$portfolio_pagination   = cs_get_option('portfolio_pagination');
			$portfolio_read_more_txt = cs_get_option('portfolio_read_more_txt');
			$portfolio_view = cs_get_option('portfolio_view');
			$portfolio_limit = cs_get_option('portfolio_limit');

			if($portfolio_column) {
			  if($portfolio_column == 'bpw-col-2') {
			      $portfolio_column = 'bpw-col-2';
			  } elseif($portfolio_column == 'bpw-col-3') {
			      $portfolio_column = 'bpw-col-3';
			  } elseif($portfolio_column == 'bpw-col-4') {
			    $portfolio_column = 'bpw-col-4';
			  }
			} else {
			  $portfolio_column = 'bpw-col-4';
			}
			if($portfolio_read_more_txt) {
				$btn_txt = $portfolio_read_more_txt;
			} else {
				$btn_txt = esc_html__('Read More', 'roof');
			}
			if($portfolio_style === 'three'){
			  $port_style = ' works-style-three';
			} else {
			  $port_style = '';
			}
			?>
			<div class="container roo-main-wrap">
				<div class="row">
				  <section class="roof-works <?php echo esc_attr($port_style); ?>">

				    <?php if ($portfolio_style === 'two') { ?>
				      <ul class="nav navbar-nav filters-nav masonry-filters">
				      	<li><a href="javascript:void(0);" data-filter="*" class="active"><?php echo esc_html__('ALL PROJECTS', 'roof'); ?></a></li>
				    <?php } elseif ($portfolio_style === 'three') { ?>
			      <ul class="nav navbar-nav filters-nav masonry-filters">
			      	<li><a href="javascript:void(0);" data-filter="*" class="active"><?php echo esc_html__('ALL PROJECTS', 'roof'); ?></a></li>
			    <?php } else { ?>
				      <ul class="nav navbar-nav filters-nav slick-filter-nav">
				        <li><a href="javascript:void(0);" class="active" id="all"><?php echo esc_html__('ALL PROJECTS', 'roof'); ?></a></li>
				    <?php }

				          $terms = get_terms('portfolio_category');
				          $count = count($terms);
				          $i=0;
				          $term_list = '';
				          if ($count > 0) {
				            foreach ($terms as $term) {
				              $i++;
				              if ($portfolio_style === 'two'|| $portfolio_style === 'three') {
				                $term_list .= '<li><a href="javascript:void(0);" data-filter=".'. esc_attr($term->slug) .'-item">' . esc_attr($term->name) . '</a></li>';
				              } else {
				                $term_list .= '<li><a href="javascript:void(0);" id="'. esc_attr($term->slug) .'">' . esc_attr($term->name) . '</a></li>';
				              }

				              if ($count != $i) {
				                $term_list .= '';
				              } else {
				                $term_list .= '';
				              }
				            }
				            echo $term_list;
				          }

				      ?>
				        </ul>
				    <?php
				    $portfolio_style_class = $portfolio_style === 'two' ? 'roof-masonry ' : 'slick-horizontal';
				    $portfolio_column = $portfolio_column ? $portfolio_column : 'bpw-col-3';
				    // Pagination
				    global $paged;
				    if( get_query_var( 'paged' ) )
				      $my_page = get_query_var( 'paged' );
				    else {
				      if( get_query_var( 'page' ) )
				        $my_page = get_query_var( 'page' );
				      else
				        $my_page = 1;
				      set_query_var( 'paged', $my_page );
				      $paged = $my_page;
				    }

				    $args = array(
				      // other query params here,
				      'paged' => $my_page,
				      'post_type' => 'portfolio',
				      'posts_per_page' => (int)$portfolio_limit,
				      'portfolio_category' => '',
				      'orderby' => $portfolio_orderby,
				      'order' => $portfolio_order
				    );

				    $roof_port = new WP_Query( $args );

				    // Portfolio Start

				if($portfolio_style === 'three' ) { ?>
					<div class="roof-masonry masonry-fullwidth <?php echo esc_attr($portfolio_column); ?>">
				<?php } else { ?>
					<div class="masonry-item-five <?php echo esc_attr($portfolio_style_class); ?>" data-items="5" data-dots="true" data-arrow="true">
				<?php }

				      if ($roof_port->have_posts()) : while ($roof_port->have_posts()) : $roof_port->the_post();

				        global $post;
				        $roof_id    = ( isset( $post ) ) ? $post->ID : 0;
				        $roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
				        $roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
				        $roof_meta  = get_post_meta( get_the_ID(), 'portfolio_type_metabox', true );

				        if ($roof_meta) {
				          $masonry_img_size  = $roof_meta['masonry_img_size'];
				        } else {
				          $masonry_img_size = '';
				        }

				        // Category
				        $terms = wp_get_post_terms($post->ID,'portfolio_category');
				        foreach ($terms as $term) {
				          if ($portfolio_style === 'two' || $portfolio_style === 'three') {
				            $cat_class = $term->slug .'-item';
				          } else {
				            $cat_class = 'filter-' . $term->slug;
				          }
				        }
				        $count = count($terms);
				        $i=0;
				        $cat_class = '';
				        if ($count > 0) {
				          foreach ($terms as $term ) {
				            $i++;
				            if ($portfolio_style === 'two' || $portfolio_style === 'three') {
				              $cat_class .= $term->slug.'-item ';
				            } else {
				              $cat_class .= 'filter-'. $term->slug .' ';
				            }
				            if ($count != $i) {
				              $cat_class .= '';
				            } else {
				              $cat_class .= '';
				            }
				          }
				        }

				        // Featured Image
				        $large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
				        $large_image = isset($large_image[0]) ? $large_image[0] : '';
				        $resizer = cs_get_option('disable_resizer');

				        if($resizer) {
				        	$featured_img = $large_image;
				        } else {

				          if ($portfolio_style === 'two') {
				            if($portfolio_view === 'masonry'){
				              if ($masonry_img_size === '2x-width'){
				                  if(class_exists('Aq_Resize')) {
				                    $portfolio_img = aq_resize( $large_image, '575', '300', true );
				                  } else {
				                    $portfolio_img = $large_image;
				                  }
				                $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
				              } elseif ($masonry_img_size === '2x-width-height') {
				                  if(class_exists('Aq_Resize')) {
				                    $portfolio_img = aq_resize( $large_image, '575', '620', true );
				                  } else {
				                    $portfolio_img = $large_image;
				                  }
				                  $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
				              } else {
				                  if(class_exists('Aq_Resize')) {
				                    $portfolio_img = aq_resize( $large_image, '278', '300', true );
				                  } else {
				                    $portfolio_img = $large_image;
				                  }
				                  $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
				              }
				            } else {
				                  if(class_exists('Aq_Resize')) {
				                    $portfolio_img = aq_resize( $large_image, '370', '300', true );
				                  } else {
				                    $portfolio_img = $large_image;
				                  }
				                  $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
				              }
			          	} elseif($portfolio_style === 'three') {

			              if(class_exists('Aq_Resize')) {
			                if($portfolio_column === 'bpw-col-3'){
			                  $portfolio_img = aq_resize( $large_image, '601', '531', true );
			                } elseif($portfolio_column === 'bpw-col-5'){
			                  $portfolio_img = aq_resize( $large_image, '356', '259', true );
			                } elseif($portfolio_column === 'bpw-col-2'){
			                  $portfolio_img = $large_image;
			                } else {
			                  $portfolio_img = aq_resize( $large_image, '450', '327', true );
			                }
			              } else {
			                $portfolio_img = $large_image;
			              }
			                $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';

			        		} else {
				            if(class_exists('Aq_Resize')) {
				                $portfolio_img = aq_resize( $large_image, '384', '350', true );
				              } else {
				                $portfolio_img = $large_image;
				              }
				              $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
				          }
				        }


				        if ($portfolio_style === 'two') {
				          if($portfolio_view ==='masonry'){
				            if ($masonry_img_size === '2x-width') {
				              $msnr_class = 'one-half ';
				            } elseif ($masonry_img_size === '2x-width-height') {
				              $msnr_class = 'one-half ';
				            } else {
				              $msnr_class = ' ';
				            }
				          } else {$msnr_class = 'masonry-grid ';}
				        }

				        if ($portfolio_style === 'two') { ?>

				          <div class="masonry-item msry-detail-page <?php echo esc_attr($msnr_class); ?><?php echo esc_attr($cat_class); ?>" data-category="<?php echo esc_attr($cat_class); ?>">
				            <div class="work-list">
				              <div class="roof-picture"> <img src="<?php echo esc_url($featured_img); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></div>
				              <div class="work-info">
				                <div class="roof-table-container">
				                  <div class="roof-align-container">
				                    <h5 class="work-title"><a href="<?php esc_url(the_permalink()); ?>"><?php esc_attr(the_title()); ?></a></h5>
				                    <div class="view-more"><a href="<?php esc_url(the_permalink()); ?>" class="roof-btn roof-btn-small"><?php echo esc_attr($btn_txt); ?></a></div>
				                  </div>
				                </div>
				              </div>
				            </div>
				          </div>

				        <?php
				        } elseif($portfolio_style === 'three' ) {
			      ?>
					      <div class="masonry-item <?php echo esc_attr($cat_class); ?>" data-category="<?php echo esc_attr($cat_class); ?>">
					        <div class="work-list">
					          <div class="roof-picture"> <img src="<?php echo esc_url($featured_img); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></div>
					          <div class="work-info">
					            <div class="roof-table-container">
					              <div class="roof-align-container">
					                <h5 class="work-title"><a href="<?php esc_url(the_permalink()); ?>"><?php esc_attr(the_title()); ?></a></h5>
					                <h5 class="work-category">
					                  <?php foreach ($terms as $term) {
					                    $terms = wp_get_post_terms($post->ID,'portfolio_category');?>
					                    <span><?php echo esc_attr($term->slug); ?></span>
					                  <?php } ?>
					                </h5>
					              </div>
					            </div>
					          </div>
					        </div>
					      </div>
			      <?php } else { ?>
						    <div class="item filter-all <?php echo esc_attr($cat_class); ?>">
						      <div class="work-list">
						        <div class="roof-picture"><img src="<?php echo esc_url($featured_img); ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></div>
						        <div class="work-info">
						          <div class="roof-table-container">
						            <div class="roof-align-container">
						              <h5 class="work-title"><?php esc_attr(the_title()); ?></h5>
						              <div class="view-more"><a href="<?php esc_url(the_permalink()); ?>" class="roof-btn roof-btn-small"><?php echo esc_attr($btn_txt); ?></a></div>
						            </div>
						          </div>
						        </div>
						      </div>
						    </div>
				    <?php }
				      endwhile;
				      endif;
				      wp_reset_postdata(); ?>

				    </div>
				    </div>
				  </section>
				  <?php
				    if ($portfolio_pagination) {
				      if ( function_exists('wp_pagenavi')) {
				        wp_pagenavi(array( 'query' => $roof_port ) );
				        wp_reset_postdata();  // avoid errors further down the page
				      }
				    }
				  ?>
				</div>
			</div>
		</div>
</div>

    <!-- Portfolio End -->
<?php } else {

// Theme Options
$roof_blog_style = cs_get_option('blog_listing_style');
$roof_blog_columns = cs_get_option('blog_listing_columns');
$roof_sidebar_position = cs_get_option('blog_sidebar_position');

// Columns
if ($roof_blog_style === 'style-two') {
	$roof_blog_columns = $roof_blog_columns ? $roof_blog_columns : 'roof-blog-col-2';
} else {
	$roof_blog_columns = 'roof-blog-col-1';
}

// Style
if ($roof_blog_style === 'style-two') {
	$roof_blog_style = 'roof-blog-one ';
} else {
	$roof_blog_style = 'roof-blog-one roof-blog-list';
}

// Sidebar Position
if ($roof_sidebar_position === 'sidebar-hide') {
	$roof_layout_class = 'col-md-12';
	$roof_sidebar_class = 'roof-hide-sidebar';
} elseif ($roof_sidebar_position === 'sidebar-left') {
	$roof_layout_class = 'col-md-9';
	$roof_sidebar_class = 'roof-left-sidebar';
} else {
	$roof_layout_class = 'col-md-9';
	$roof_sidebar_class = 'sidebar-right';
}
?>

<div class="container roof-main-wrap <?php echo esc_attr($roof_sidebar_class); ?>">
<div class="row">

	<?php
	if ($roof_sidebar_position === 'sidebar-left' && $roof_sidebar_position !== 'sidebar-hide') {
		get_sidebar(); // Sidebar
	}
	?>

	<div class="roof-primary <?php echo esc_attr($roof_layout_class); ?>">
		<div class="<?php echo esc_attr($roof_blog_style) .' '. esc_attr($roof_blog_columns); ?>">

		<?php
		if ( have_posts() ) :
			/* Start the Loop */
			while ( have_posts() ) : the_post();
				get_template_part( 'layouts/post/content' );
			endwhile;
		else :
			get_template_part( 'layouts/post/content', 'none' );
		endif; ?>

		</div><!-- Blog Div -->
		<?php
    roof_paging_nav();
    wp_reset_postdata();  // avoid errors further down the page
		?>
	</div><!-- Content Area -->

		<?php
		if ($roof_sidebar_position !== 'sidebar-hide') {
			get_sidebar(); // Sidebar
		}
		?>

</div>
</div>

<?php
}
get_footer();
