<?php
/*
 * The template for displaying 404 pages (not found).
 * Author & Copyright: VictorThemes
 * URL: https://victorthemes.com
 */

// Theme Options
$roof_error_heading = cs_get_option('error_heading');
$roof_error_page_content = cs_get_option('error_page_content');

$roof_error_heading = ( $roof_error_heading ) ? $roof_error_heading : '';
$roof_error_page_content = ( $roof_error_page_content ) ? $roof_error_page_content : '';

get_header();
get_template_part( 'layouts/header/title', 'bar' ); ?>

<section class="roof-main-wrap">
  <div class="container">
    <div class="roof-404-error">
      <?php if ($roof_error_page_content) { 
      	echo '<h1 class="error-title">'.$roof_error_heading.'</h1>';
      	echo ' <h2 class="error-sub-title">'.$roof_error_page_content.'</h2>';
      } else { ?>
      <h1 class="error-title"><?php esc_html_e('404', 'roof') ?></h1>
      <h2 class="error-sub-title"><?php echo __('<span>Oops!</span> Page Not Found!', 'roof') ?></h2>
      <p><?php esc_html_e('You may have typed the address incorrectly or you may have used an outdated link. Try search our site.', 'roof') ?></p>
      <?php }
      get_search_form(); ?>
    </div>
  </div>
</section>

<?php
get_footer();
