<?php
/**
 * Testimonial Carousel - Shortcode Options
 */
add_action( 'init', 'testimonial_carousel_vc_map' );
if ( ! function_exists( 'testimonial_carousel_vc_map' ) ) {
  function testimonial_carousel_vc_map() {
    vc_map( array(
    "name" => __( "Testimonial Carousel", 'roof-core'),
    "base" => "roof_testimonial_carousel",
    "description" => __( "Carousel Style Testimonial", 'roof-core'),
    "icon" => "fa fa-comments color-green",
    "category" => RoofLib::roof_cat_name(),
    "params" => array(

      array(
        "type" => "textfield",
        "heading" => __( "Heading", 'roof-core' ),
        "param_name" => "testimonial_heading",
        'value' => '',
        "description" => __( "Enter your testimonial heading.", 'roof-core')
      ),
      array(
        "type" => "dropdown",
        "heading" => __( "Testimonial Style", 'roof-core' ),
        "param_name" => "testimonial_style",
        "value" => array(
          __('Style One', 'roof-core') => 'testimonial_one',
          __('Style Two', 'roof-core') => 'testimonial_two',
          __('Style Three', 'roof-core') => 'testimonial_three',
        ),
        "admin_label" => true,
        "description" => __( "Select testimonial carousel style.", 'roof-core'),
      ),

      array(
        "type"        => "notice",
        "heading"     => __( "Listing", 'roof-core' ),
        "param_name"  => 'lsng_opt',
        'class'       => 'cs-warning',
        'value'       => '',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('Limit', 'roof-core'),
        "param_name"  => "testimonial_limit",
        "value"       => "",
        'admin_label' => true,
        "description" => __( "Enter the number of items to show.", 'roof-core'),
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Order', 'roof-core' ),
        'value' => array(
          __( 'Select Testimonial Order', 'roof-core' ) => '',
          __('Asending', 'roof-core') => 'ASC',
          __('Desending', 'roof-core') => 'DESC',
        ),
        'param_name' => 'testimonial_order',
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        'type' => 'dropdown',
        'heading' => __( 'Order By', 'roof-core' ),
        'value' => array(
          __('None', 'roof-core') => 'none',
          __('ID', 'roof-core') => 'ID',
          __('Author', 'roof-core') => 'author',
          __('Title', 'roof-core') => 'title',
          __('Date', 'roof-core') => 'date',
        ),
        'param_name' => 'testimonial_orderby',
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      RoofLib::vt_class_option(),

      // Carousel
      array(
        "type"        => "notice",
        "heading"     => __( "Basic Options", 'roof-core' ),
        "param_name"  => 'bsic_opt',
        "group" => __( "Carousel", 'roof-core' ),
        'class'       => 'cs-warning',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'value'       => '',
      ),

      array(
        "type" => "switcher",
        "heading" => __( "Disable Loop?", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_loop",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        "description" => __( "Continuously moving carousel, if enabled.", 'roof-core')
      ),
      array(
        "type" => "textfield",
        "heading" => __( "Items", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_items",
        'value' => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        "description" => __( "Enter the numeric value of how many items you want in per slide.", 'roof-core')
      ),
      array(
        "type" => "textfield",
        "heading" => __( "Margin", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_margin",
        'value' => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        "description" => __( "Enter the numeric value of how much space you want between each carousel item.", 'roof-core')
      ),
      array(
        "type" => "switcher",
        "heading" => __( "Dots", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_dots",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        "description" => __( "If you want Carousel Dots, enable it.", 'roof-core')
      ),
      array(
        "type" => "switcher",
        "heading" => __( "Navigation", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_nav",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        "description" => __( "If you want Carousel Navigation, enable it.", 'roof-core')
      ),

      array(
        "type"        => "notice",
        "heading"     => __( "Auto Play & Interaction", 'roof-core' ),
        "param_name"  => 'apyi_opt',
        "group" => __( "Carousel", 'roof-core' ),
        'class'       => 'cs-warning',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'value'       => '',
      ),
      array(
        "type" => "textfield",
        "heading" => __( "Autoplay Timeout", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_autoplay_timeout",
        'value' => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        "description" => __( "Change carousel Autoplay timing value. Default : 5000. Means 5 seconds.", 'roof-core')
      ),
      array(
        "type" => "switcher",
        "heading" => __( "Autoplay", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_autoplay",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        "description" => __( "If you want to start Carousel automatically, enable it.", 'roof-core')
      ),
      array(
        "type" => "switcher",
        "heading" => __( "Animate Out", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_animate_out",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        "description" => __( "CSS3 animation out.", 'roof-core')
      ),

      array(
        "type"        => "notice",
        "heading"     => __( "Width & Height", 'roof-core' ),
        "param_name"  => 'wah_opt',
        "group" => __( "Carousel", 'roof-core' ),
        'class'       => 'cs-warning',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'value'       => '',
      ),

      array(
        "type" => "switcher",
        "heading" => __( "Auto Width", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_autowidth",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        "description" => __( "Adjust Auto Width automatically for each carousel items.", 'roof-core')
      ),
      array(
        "type" => "switcher",
        "heading" => __( "Auto Height", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_autoheight",
        "on_text" => __( "Yes", 'roof-core' ),
        "off_text" => __( "No", 'roof-core' ),
        "value" => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        "description" => __( "Adjust Auto Height automatically for each carousel items.", 'roof-core')
      ),

      array(
        "type"        => "notice",
        "heading"     => __( "Responsive Options", 'roof-core' ),
        "param_name"  => 'res_opt',
        "group" => __( "Carousel", 'roof-core' ),
        'class'       => 'cs-warning',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'value'       => '',
      ),

      array(
        "type" => "textfield",
        "heading" => __( "Tablet", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_tablet",
        'value' => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        "description" => __( "Enter number of items to show in tablet.", 'roof-core')
      ),
      array(
        "type" => "textfield",
        "heading" => __( "Mobile", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_mobile",
        'value' => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        "description" => __( "Enter number of items to show in mobile.", 'roof-core')
      ),
      array(
        "type" => "textfield",
        "heading" => __( "Small Mobile", 'roof-core' ),
        "group" => __( "Carousel", 'roof-core' ),
        "param_name" => "carousel_small_mobile",
        'value' => '',
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        "description" => __( "Enter number of items to show in small mobile.", 'roof-core')
      ),

      // Style
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Title Color', 'roof-core'),
        "param_name"  => "title_color",
        "value"       => "",
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Content Color', 'roof-core'),
        "param_name"  => "content_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Name Color', 'roof-core'),
        "param_name"  => "name_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Name Hover Color', 'roof-core'),
        "param_name"  => "name_hover_color",
        "value"       => "",
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => 'testimonial_two',
          ),
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Profession Color', 'roof-core'),
        "param_name"  => "profession_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      // Size
      array(
        "type"        =>'textfield',
        "heading"     =>__('Title Size', 'roof-core'),
        "param_name"  => "title_size",
        "value"       => "",
        'dependency' => array(
            'element' => 'testimonial_style',
            'value' => array('testimonial_two','testimonial_three'),
          ),
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('Content Size', 'roof-core'),
        "param_name"  => "content_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('Name Size', 'roof-core'),
        "param_name"  => "name_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('Profession Size', 'roof-core'),
        "param_name"  => "profession_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),

      ), // Params
    ) );
  }
}
