<?php
/* Team */
if ( !function_exists('roof_team_function')) {
  function roof_team_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'team_column'  => '',
      'class'  => '',
      // Listing
      'team_limit'  => '',
      'team_id'  => '',
      'team_order'  => '',
      'team_orderby'  => '',
      'team_pagination'  => '',
      'team_social_icon' => '',
      'team_min_height'  => '',
      'team_excerpt'  => '',
      // Color & Style
      'name_color'  => '',
      'profession_color'  => '',
      'content_color'  => '',
      'name_hover_color'  => '',
      'name_size'  => '',
      'profession_size'  => '',
      'content_size'  => '',
    ), $atts));

    if (roof_framework_active()) {
      if ($team_excerpt) {
          $team_excerpt = $team_excerpt;
        } else {
          $team_excerpt = '10';
        }
    } else {
      $team_excerpt = '10';
    }

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Minimum Height
    if ( $team_min_height ) {
      $inline_style .= '.roof-team-'. $e_uniqid .'.team-wrap .mate-list {';
      $inline_style .= ( $team_min_height ) ? 'min-height:'. roof_core_check_px($team_min_height) .';' : '';
      $inline_style .= '}';
    }
    // Name Color
    if ( $name_color || $name_size ) {
      $inline_style .= '.roof-team-'. $e_uniqid .'.team-wrap .mate-name a {';
      $inline_style .= ( $name_color ) ? 'color:'. $name_color .';' : '';
      $inline_style .= ( $name_size ) ? 'font-size:'. $name_size .';' : '';
      $inline_style .= '}';
    }
    // Name Hover color
    if ( $name_hover_color ) {
      $inline_style .= '.roof-team-'. $e_uniqid .'.team-wrap .mate-name a:hover {';
      $inline_style .= ( $name_hover_color ) ? 'color:'. $name_hover_color .';' : '';
      $inline_style .= '}';
    }
    // Profession Color
    if ( $profession_color || $profession_size ) {
      $inline_style .= '.roof-team-'. $e_uniqid .'.team-wrap .mate-designation {';
      $inline_style .= ( $profession_color ) ? 'color:'. $profession_color .';' : '';
      $inline_style .= ( $profession_size ) ? 'font-size:'. $profession_size .';' : '';
      $inline_style .= '}';
    }
    // Content Color
    if ( $content_color || $content_size ) {
      $inline_style .= '.roof-team-'. $e_uniqid .'.team-wrap .mate-info p {';
      $inline_style .= ( $content_color ) ? 'color:'. $content_color .';' : '';
      $inline_style .= ( $content_size ) ? 'font-size:'. $content_size .';' : '';
      $inline_style .= '}';
    }

    // Add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-team-'. $e_uniqid;

    // Team Column
    $team_column = $team_column ? $team_column : 'col-lg-4';

    // Turn output buffer on
    ob_start();

    // Show ID
    if ($team_id) {
      $team_id = explode(',',$team_id);
    } else {
      $team_id = '';
    }

    // Query Starts Here
    // Pagination
    global $paged;
    if( get_query_var( 'paged' ) )
      $my_page = get_query_var( 'paged' );
    else {
      if( get_query_var( 'page' ) )
        $my_page = get_query_var( 'page' );
      else
        $my_page = 1;
      set_query_var( 'paged', $my_page );
      $paged = $my_page;
    }

    $args = array(
      'paged' => $my_page,
      'post_type' => 'team',
      'posts_per_page' => (int)$team_limit,
      'orderby' => $team_orderby,
      'order' => $team_order,
      'post__in' => $team_id,
    );

    $roof_team_qury = new WP_Query( $args );

    if ($roof_team_qury->have_posts()) :
    ?>

    <div class="team-wrap row <?php echo $styled_class .' '. $class; ?>"> <!-- Team Starts -->

    <?php
    while ($roof_team_qury->have_posts()) : $roof_team_qury->the_post();

    // Link
    $team_options = get_post_meta( get_the_ID(), 'team_options', true );
    $team_socials = $team_options['social_icons'];
    $team_pro = $team_options['team_job_position'];
    $team_pro = $team_pro ? '<h6 class="mate-designation">'.$team_pro.'</h6>' : '';

    // Featured Image
    $large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
    $large_image = isset($large_image[0]) ? $large_image[0] : '';
    $abt_title = get_the_title();
    $actual_image = '<div class="roof-picture"><img src="'. $large_image .'" alt="'.$abt_title.'"></div>';
    ?>
    <div class="<?php echo $team_column; ?>">
      <div class="mate-list">
        <?php echo $actual_image; ?>
        <div class="mate-info">
          <h5 class="mate-name"><a href="<?php echo esc_url(get_permalink()); ?>" class="team-name"><?php echo $abt_title; ?></a></h5>
          <?php
            echo $team_pro;
            echo '<p>';
                if (roof_framework_active()) {
                  roof_excerpt($team_excerpt);
                } else {
                  the_excerpt();
                }
            echo '</p>';

          if($team_social_icon) { ?>
            <div class="roof-social">
              <?php
                if ( ! empty( $team_socials ) ) {
                foreach ( $team_socials as $social ) {
              ?>
                <a href="<?php echo $social['icon_link']; ?>"><i class="<?php echo $social['icon']; ?>" aria-hidden="true"></i></a>
              <?php } } ?>
            </div>
          <?php } ?>
        </div>
      </div>

    </div>

    <?php endwhile; ?>

    </div> <!-- Team End -->

<?php
  endif;

  if ($team_pagination) {
    if ( function_exists('wp_pagenavi')) {
      wp_pagenavi(array( 'query' => $roof_team_qury ) );
      wp_reset_postdata();  // avoid errors further down the page
    }
  }

    // Return outbut buffer
    return ob_get_clean();

  }
}
add_shortcode( 'roof_team', 'roof_team_function' );
