<?php
/**
 * Team - Shortcode Options
 */
add_action( 'init', 'team_vc_map' );
if ( ! function_exists( 'team_vc_map' ) ) {
  function team_vc_map() {
    vc_map( array(
    "name" => __( "Team", 'roof-core'),
    "base" => "roof_team",
    "description" => __( "Team Style", 'roof-core'),
    "icon" => "fa fa-user color-red",
    "category" => RoofLib::roof_cat_name(),
    "params" => array(

        array(
          "type" => "dropdown",
          "heading" => __( "Team Column", 'roof-core' ),
          "param_name" => "team_column",
          "value" => array(
            __('Select Column', 'roof-core') => '',
            __('Column One', 'roof-core') => 'col-md-12',
            __('Column Two', 'roof-core') => 'col-md-6',
            __('Column Three', 'roof-core') => 'col-md-4 col-sm-6',
            __('Column Four', 'roof-core') => 'col-md-3 col-sm-6',
          ),
          "admin_label" => true,
          "description" => __( "Select team column.", 'roof-core'),
        ),

        array(
          "type"        => "notice",
          "heading"     => __( "Listing", 'roof-core' ),
          "param_name"  => 'lsng_opt',
          'class'       => 'cs-warning',
          'value'       => '',
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Limit', 'roof-core'),
          "param_name"  => "team_limit",
          "value"       => "",
          'admin_label' => true,
          "description" => __( "Enter the number of items to show.", 'roof-core'),
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Specific ID', 'roof-core'),
          "param_name"  => "team_id",
          "value"       => "",
          "description" => __( "Enter your team members ID, to show them only by your choice.", 'roof-core'),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order', 'roof-core' ),
          'value' => array(
            __( 'Select Team Order', 'roof-core' ) => '',
            __('Asending', 'roof-core') => 'ASC',
            __('Desending', 'roof-core') => 'DESC',
          ),
          'param_name' => 'team_order',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order By', 'roof-core' ),
          'value' => array(
            __('None', 'roof-core') => 'none',
            __('ID', 'roof-core') => 'ID',
            __('Author', 'roof-core') => 'author',
            __('Title', 'roof-core') => 'title',
            __('Date', 'roof-core') => 'date',
          ),
          'param_name' => 'team_orderby',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Pagination', 'roof-core'),
          "param_name"  => "team_pagination",
          "value"       => "",
          "std"         => false,
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "If you need pagination, turn this to On.", 'roof-core'),
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Social Icons', 'roof-core'),
          "param_name"  => "team_social_icon",
          "value"       => "",
          "std"         => false,
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "If you need social icon, turn this to On.", 'roof-core'),
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Miss-Aligned?', 'roof-core'),
          "param_name"  => "team_min_height",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "Enter minimum height value in px.", 'roof-core'),
        ),
        array(
          'param_name'      => 'team_excerpt',
          'type'    => 'textfield',
          "value"       => "",
          'heading'   => __('Excerpt Length', 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'description'   => __('Team short content length.', 'roof-core'),
        ),
        RoofLib::vt_class_option(),

        // Style
        array(
          "type"        =>'colorpicker',
          "heading"     =>__('Name Color', 'roof-core'),
          "param_name"  => "name_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),
        array(
          "type"        =>'colorpicker',
          "heading"     =>__('Name Hover Color', 'roof-core'),
          "param_name"  => "name_hover_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),
        array(
          "type"        =>'colorpicker',
          "heading"     =>__('Profession Color', 'roof-core'),
          "param_name"  => "profession_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),
        array(
          "type"        =>'colorpicker',
          "heading"     =>__('Content Color', 'roof-core'),
          "param_name"  => "content_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),
        // Size
        array(
          "type"        =>'textfield',
          "heading"     =>__('Name Size', 'roof-core'),
          "param_name"  => "name_size",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Profession Size', 'roof-core'),
          "param_name"  => "profession_size",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Content Size', 'roof-core'),
          "param_name"  => "content_size",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "group"     =>__('Style', 'roof-core'),
        ),

      ), // Params
    ) );
  }
}
