<?php
/* ==========================================================
    Share
=========================================================== */
if ( !function_exists('roof_share_function')) {
  function roof_share_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'share_text'  => '',
      'share_on_text'  => '',
      'class'  => '',
      // Enable & Disable
      'social_icons'   => '',
      'share_twitter'  => '',
      'share_facebook'  => '',
      'share_linkedin'  => '',
      // Colors
      'share_text_color'  => '',
      'share_on_text_color'  => '',
      'icon_color'  => '',
      'icon_bg_color'  => '',
      'icon_border_color'  => '',
      // Style - Size
      'share_text_size'  => '',
      'share_on_text_size'  => '',
    ), $atts));

    // Alignment & Texts
    $share_text = ( $share_text ) ? $share_text : __('Share:', 'roof-core');
    $share_on_text = ( $share_on_text ) ? $share_on_text : __('Share On', 'roof-core');
    $class = ( $class ) ? ' '. $class : '';

    // Group Field
    $social_items = (array) vc_param_group_parse_atts( $social_icons );
    $get_each_list = array();
    foreach ( $social_items as $list_item ) {
      $each_list = $list_item;
      $each_list['select_icon'] = isset( $list_item['select_icon'] ) ? $list_item['select_icon'] : '';
      $each_list['social_share_link'] = isset( $list_item['social_share_link'] ) ? $list_item['social_share_link'] : '';
      $get_each_list[] = $each_list;
    }

    // Share get details - dynamic thing
    global $post;
    $page_url = get_permalink($post->ID );
    $title = $post->post_title;

    // Enable & Disable
    $share_twitter = ( $share_twitter ) ? '<li class="description-share-twitter"><a href="//twitter.com/intent/tweet?text='. urlencode($title) .'&url='. urlencode($page_url) .'" class="icon-fa-twitter" data-toggle="tooltip" data-placement="top" title="'. $share_on_text .' Twitter" target="_blank"><i class="fa fa-twitter"></i></a></li>' : '';
    $share_facebook = ( $share_facebook ) ? '<li class="description-share-facebook"><a href="http://www.facebook.com/sharer/sharer.php?u='. urlencode($page_url) .'&amp;t='. urlencode($title) .'" class="icon-fa-facebook" data-toggle="tooltip" data-placement="top" title="'. $share_on_text .' Facebook" target="_blank"><i class="fa fa-facebook"></i></a></li>' : '';
    $share_linkedin = ( $share_linkedin ) ? '<li class="description-share-pinterest"><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url='. urlencode($page_url) .'&amp;title='. urlencode($title) .'" class="icon-fa-pinterest" data-toggle="tooltip" data-placement="top" title="'. $share_on_text .' Linkedin" target="_blank"><i class="fa fa-linkedin"></i></a></li>' : '';

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    // Icon Style
    if ( $icon_border_color ) {
      $inline_style .= '.roof-share-'. $e_uniqid .'.bp-share > ul {';
      $inline_style .= ( $icon_border_color ) ? 'border-color:'. $icon_border_color .';' : '';
      $inline_style .= '}';
    }
    if ( $icon_border_color || $icon_color || $icon_bg_color ) {
      $inline_style .= '.roof-share-'. $e_uniqid .'.bp-share li a {';
      $inline_style .= ( $icon_border_color ) ? 'border-right-color:'. $icon_border_color .';' : '';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= ( $icon_bg_color ) ? 'background-color:'. $icon_bg_color .';' : '';
      $inline_style .= '}';
    }
    if ( $share_text_color || $share_text_size ) {
      $inline_style .= '.roof-share-'. $e_uniqid .'.bp-share > p {';
      $inline_style .= ( $share_text_color ) ? 'color:'. $share_text_color .';' : '';
      $inline_style .= ( $share_text_size ) ? 'font-size:'. roof_core_check_px($share_text_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $share_on_text_color || $share_on_text_size ) {
      $inline_style .= '.roof-share-'. $e_uniqid .'.bp-share .tooltip-inner {';
      $inline_style .= ( $share_on_text_color ) ? 'color:'. $share_on_text_color .';' : '';
      $inline_style .= ( $share_on_text_size ) ? 'font-size:'. roof_core_check_px($share_on_text_size) .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-share-'. $e_uniqid;
$output = '<div class="roof-description-share'. $styled_class . $class .'"><ul class="pull-right"><li class="job-share"><h6>'. $share_text .'</h6></li>';
    foreach ( $get_each_list as $each_list ) {
      $output .= $share_twitter.$share_facebook.$share_linkedin;
      $output .= '<li>';
      $social_link = do_shortcode($each_list['social_share_link']);
        $social_icons_actual = $each_list['social_share_link'] ? '<a href="'.$social_link .'" target="_blank" data-toggle="tooltip" data-placement="top" <i class="'. $each_list['select_icon'] .'"></i></a> ' : '<i class="'.$each_list['select_icon'].'"></i>';
      $output .= $social_icons_actual;
      $output .= '</li>';
      }
      $output .= '</ul></div>';

    // Starts

    return $output;

  }
}
add_shortcode( 'roof_share', 'roof_share_function' );
