<?php
/**
 * Share - Shortcode Options
 */
add_action( 'init', 'share_vc_map' );
if ( ! function_exists( 'share_vc_map' ) ) {
  function share_vc_map() {
    vc_map( array(
    "name" => __( "Share", 'roof-core'),
    "base" => "roof_share",
    "description" => __( "Share Style", 'roof-core'),
    "icon" => "fa fa-share-alt color-blue",
    "category" => RoofLib::roof_cat_name(),
    "params" => array(

      array(
        "type"        =>'textfield',
        "heading"     =>__('"Share" Text', 'roof-core'),
        "param_name"  => "share_text",
        "value"       => "",
        'admin_label' => true,
        "description" => __( "Enter your share text here.", 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('"Share On" Text', 'roof-core'),
        "param_name"  => "share_on_text",
        "value"       => "",
        "description" => __( "This will be a prefix for tooltip popup text.", 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),

      // List
      array(
        'type' => 'param_group',
        'value' => '',
        'heading' => __( 'Social Icons', 'roof-core' ),
        'param_name' => 'social_icons',
        // Note params is mapped inside param-group:
        'params' => array(
          array(
            "type" => "vt_icon",
            "heading" => __( "Select Icon", 'roof-core' ),
            "param_name" => "select_icon",
            'value'      => '',
            'admin_label' => true,
            "description" => __( "Select icon if you want.", 'roof-core'),
            'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
          ),
          array(
            'type' => 'textarea',
            'value' => '',
            'heading' => __( 'Share Link', 'roof-core' ),
            'param_name' => 'social_share_link',
            "description" => __( "Useful shortcodes [roof_page_title], [roof_page_url].", 'roof-core'),
          ),
        ),

      ),

      array(
        "type"        => "notice",
        "heading"     => __( "Enable & Disable", 'roof-core' ),
        "param_name"  => 'enb_dis',
        'class'       => 'cs-warning',
        'value'       => '',
      ),
      array(
        "type"        =>'switcher',
        "heading"     =>__('Twitter', 'roof-core'),
        "param_name"  => "share_twitter",
        "value"       => "",
        "std"         => true,
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'switcher',
        "heading"     =>__('Facebook', 'roof-core'),
        "param_name"  => "share_facebook",
        "value"       => "",
        "std"         => true,
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'switcher',
        "heading"     =>__('LinkedIn', 'roof-core'),
        "param_name"  => "share_linkedin",
        "value"       => "",
        "std"         => true,
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      roofLib::vt_class_option(),

      // Style
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Share Text Color', 'roof-core'),
        "param_name"  => "share_text_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Share On Text Color', 'roof-core'),
        "param_name"  => "share_on_text_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Icon Color', 'roof-core'),
        "param_name"  => "icon_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Icon BG Color', 'roof-core'),
        "param_name"  => "icon_bg_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Icon Border Color', 'roof-core'),
        "param_name"  => "icon_border_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      // Size
      array(
        "type"        =>'textfield',
        "heading"     =>__('Share Text Size', 'roof-core'),
        "param_name"  => "share_text_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('Share On Text Size', 'roof-core'),
        "param_name"  => "share_on_text_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),

      ), // Params
    ) );
  }
}
