<?php
/* ==========================================================
  Services
=========================================================== */
if ( !function_exists('roof_services_function')) {
  function roof_services_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'service_style'  => '',
      'service_image'  => '',
      'service_image_link'  => '',
      'service_icon_image'  => '',
      'service_icon_link'  => '',
      'service_title'  => '',
      'read_more_link'  => '',
      'read_more_title'  => '',
      'view_more_link' => '',
      'view_more_title' => '',
      'open_link'  => '',
      'class'  => '',

      // Style
      'services_icon_width' => '',
      'title_color'  => '',
      'title_size'  => '',
      'title_hover_color' => '',
      'read_more_color' => '',
      'read_more_hover_color' => '',
    ), $atts));

    // fix unclosed/unwanted paragraph tags in $content
    $content = wpb_js_remove_wpautop($content, true);

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $title_color || $title_size) {
      $inline_style .= '.services-'.$e_uniqid.' .service-title a {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $title_hover_color) {
      $inline_style .= '.services-'.$e_uniqid.' .service-title a:hover {';
      $inline_style .= ( $title_hover_color ) ? 'color:'. $title_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $read_more_color ) {
      $inline_style .= '.services-'.$e_uniqid.' .read-more a, .roof-main-wrap .roof-content-side .services-'.$e_uniqid.' .read-more a {';
      $inline_style .= ( $read_more_color ) ? 'color:'. $read_more_color .';' : '';
      $inline_style .= '}';
    }
    if ( $read_more_hover_color ) {
      $inline_style .= '.services-'.$e_uniqid.' .read-more a:hover {';
      $inline_style .= ( $read_more_hover_color ) ? 'color:'. $read_more_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $services_icon_width) {
      $inline_style .= '.services-'.$e_uniqid.' .roof-icon img {';
      $inline_style .= ( $services_icon_width ) ? 'width:'. roof_check_px($services_icon_width) .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' services-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';
    $read_more_link = $read_more_link ? '<div class="read-more"><a href="'.$read_more_link.'" '.$open_link.'>'.$read_more_title.'</a></div>' : '<div class="read-more">'.$read_more_title.'</div>';
    $read_more_txt = $read_more_title ? $read_more_link : '';

    // Service Icon
    $image_url = wp_get_attachment_url( $service_icon_image );
    $service_icon_image_main = $service_icon_image ? '<img src="'.$image_url.'" alt="">' : '';
    $service_icon_image_exact = $service_icon_link ? '<a href="'.$service_icon_link.'" '.$open_link.'>'.$service_icon_image_main.'</a>' :  $service_icon_image_main ;

    // Service Title
    if ( function_exists( 'vc_parse_multi_attribute' ) ) {
      $parse_args = vc_parse_multi_attribute( $service_title );
      $url        = ( isset( $parse_args['url'] ) ) ? $parse_args['url'] : '';
      $title      = ( isset( $parse_args['title'] ) ) ? $parse_args['title'] : '';
      $target     = ( isset( $parse_args['target'] ) ) ? trim( $parse_args['target'] ) : '_self';
    }
    if ($service_style === 'roof-service-five') {
        if ($url) {
          $service_title = '<h5 class="expert-title"><a href="'. $url .'" target="'. $target .'">'. $title .'</a></h5>';
        } elseif ($title) {
          $service_title = '<h5 class="expert-title">'. $title .'</h5>';
        } else {
          $service_title = '';
        }
     } else {
        if ($url) {
          $service_title = '<h5 class="service-title"><a href="'. $url .'" target="'. $target .'">'. $title .'</a></h5>';
        } elseif ($title) {
          $service_title = '<h5 class="service-title">'. $title .'</h5>';
        } else {
          $service_title = '';
        }
    }

    // Service Image
    $image_url = wp_get_attachment_url( $service_image );
    $service_image_main = $service_image ? '<img src="'.$image_url.'" alt="'. $title .'">' : '';
    $service_image_exact = $service_image_link ? '<a href="'.$service_image_link.'">'.$service_image_main.'</a>' :  $service_image_main ;

    $output = '';
    if ($service_style === 'roof-service-two') {
      $output .= '<div class="roof-services '.$styled_class.' services-style-two '. $class .'"><div class="service-item"><div class="roof-picture">'.$service_image_exact.'</div><div class="service-info">'.$service_title.'</div></div></div>';

    } elseif ($service_style === 'roof-service-three') {
      $output .= '<div class="roof-services '.$styled_class.' services-style-three '. $class .'"><div class="service-item"><div class="roof-icon">'.$service_icon_image_exact.'</div><div class="service-info">'. $service_title . $content .$read_more_txt.'</div></div></div>';

    } elseif ($service_style === 'roof-service-four') {
      $output .= '<div class="roof-services '.$styled_class.' services-style-five '. $class .'"><div class="service-item"><div class="roof-picture">'.$service_image_exact.'</div><div class="service-info">'. $service_title . $content .$read_more_txt.'</div></div></div>';

    } elseif ($service_style === 'roof-service-five') {
      $output .= '<div class="roof-expert '.$styled_class.''. $class .'"><div class="expert-item">
          <div class="roof-icon">'.$service_image_exact.'</div>'. $service_title .'</div></div>';

    } else {
      $output .= '<div class="roof-services '.$styled_class.' '. $class .'"><div class="service-item"><div class="roof-picture">'.$service_image_exact.'</div><div class="service-info">'. $service_title . $content .$read_more_txt.'</div></div></div>';
    }

    return $output;
  }
}
add_shortcode( 'roof_services', 'roof_services_function' );
