<?php
/**
 * Services - Shortcode Options
 */
add_action( 'init', 'roof_services_vc_map' );
if ( ! function_exists( 'roof_services_vc_map' ) ) {
  function roof_services_vc_map() {
    vc_map( array(
      "name" => __( "Service", 'roof-core'),
      "base" => "roof_services",
      "description" => __( "Service Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Services Style', 'roof-core' ),
          'value' => array(
            __( 'Style One', 'roof-core' ) => 'roof-service-one',
            __( 'Style Two', 'roof-core' ) => 'roof-service-two',
            __( 'Style Three', 'roof-core' ) => 'roof-service-three',
            __( 'Style Four', 'roof-core' ) => 'roof-service-four',
            __( 'Style Five', 'roof-core' ) => 'roof-service-five',
          ),
          'admin_label' => true,
          'param_name' => 'service_style',
          'description' => __( 'Select your service style.', 'roof-core' ),
        ),
        RoofLib::vt_open_link_tab(),
        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Service Image', 'roof-core'),
          "param_name" => "service_image",
          "value"      => "",
          "description" => __( "Set your service image.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-two','roof-service-four','roof-service-five'),
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'attach_image',
          "heading"   => __('Upload Icon', 'roof-core'),
          "param_name" => "service_icon_image",
          "value"      => "",
          "description" => __( "Set your service icon image.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => 'roof-service-three',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'href',
          "heading"   => __('Image Link', 'roof-core'),
          "param_name" => "service_image_link",
          "value"      => "",
          "description" => __( "Enter your service image link.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-two','roof-service-four'),
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'href',
          "heading"   => __('Icon Link', 'roof-core'),
          "param_name" => "service_icon_link",
          "value"      => "",
          "description" => __( "Enter your service icon link.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => 'roof-service-three',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        RoofLib::vt_notice_field(__( "Content Area", 'roof-core' ),'cntara_opt','cs-warning', ''), // Notice
        array(
          "type"      => 'vc_link',
          "heading"   => __('Service Title', 'roof-core'),
          "param_name" => "service_title",
          "value"      => "",
          "description" => __( "Enter your service title and link.", 'roof-core')
        ),
        array(
          "type"      => 'textarea_html',
          "heading"   => __('Content', 'roof-core'),
          "param_name" => "content",
          "value"      => "",
          "description" => __( "Enter your service content here.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-three','roof-service-four'),
          ),
        ),

        // Read More
        array(
          "type"      => 'href',
          "heading"   => __('Link', 'roof-core'),
          "param_name" => "read_more_link",
          "value"      => "",
          "description" => __( "Set your link for read more.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-three'),
          ),
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title', 'roof-core'),
          "param_name" => "read_more_title",
          "value"      => "",
          "description" => __( "Enter your read more title.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-three'),
          ),
        ),

        // View More
        array(
          "type"      => 'href',
          "heading"   => __('Link', 'roof-core'),
          "param_name" => "view_more_link",
          "value"      => "",
          "description" => __( "Set your link for view more.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'dependency' => array(
            'element' => 'service_style',
            'value' => 'roof-service-two',
          ),
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title', 'roof-core'),
          "param_name" => "view_more_title",
          "value"      => "",
          "description" => __( "Enter your view more title.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'dependency' => array(
            'element' => 'service_style',
            'value' => 'roof-service-two',
          ),
        ),
        RoofLib::vt_class_option(),

        // Style
        array(
          "type"         => 'textfield',
          "heading"      => __('Services Icon Width', 'roof-core'),
          "param_name"   => "services_icon_width",
          "value"        => "",
          "group"        => "Style",
          "description"  => __( "Enter the numeric value for icon width in px.", 'roof-core'),
          'dependency'   => array(
            'element'    => 'service_style',
            'value'      => array('roof-service-three','roof-service-five'),
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"         => 'colorpicker',
          "heading"      => __('Title Color', 'roof-core'),
          "param_name"   => "title_color",
          "value"        => "",
          "description"  => __( "Pick your heading color.", 'roof-core'),
          "group"        => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Hover Color', 'roof-core'),
          "param_name" => "title_hover_color",
          "value"      => "",
          "description" => __( "Pick your heading hover color.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Title Size', 'roof-core'),
          "param_name" => "title_size",
          "value"      => "",
          "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
          "group"       => "Style",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Read More Color', 'roof-core'),
          "param_name" => "read_more_color",
          "value"      => "",
          "group"       => "Style",
          "description" => __( "Pick your Read More Text color.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-three'),
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Read More Hover Color', 'roof-core'),
          "param_name" => "read_more_hover_color",
          "value"      => "",
          "group"       => "Style",
          "description" => __( "Pick your Read More Text hover color.", 'roof-core'),
          'dependency' => array(
            'element' => 'service_style',
            'value' => array('roof-service-one','roof-service-three'),
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
      )
    ) );
  }
}
