<?php
/* ==========================================================
  Services
=========================================================== */
if ( !function_exists('roof_brochure_function')) {
  function roof_brochure_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'brochure_title'  => '',
      'brochure_image'  => '',
      'btn_txt'         => '',
      'btn_link'        => '',
      'open_link'       => '',
      'class'           => '',

      // Style
      'txt_size'           => '',
      'txt_color'          => '',
      'txt_hover_color'    => '',
      'btn_bg_color'       => '',
      'btn_bg_hover_color' => '',
    ), $atts));

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $txt_color || $txt_size) {
      $inline_style .= '.brochure-'.$e_uniqid.' .brochure-info .roof-btn {';
      $inline_style .= ( $txt_color ) ? 'color:'. $txt_color .';' : '';
      $inline_style .= ( $txt_size ) ? 'font-size:'. roof_check_px($txt_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $txt_hover_color) {
      $inline_style .= '.brochure-'.$e_uniqid.' .brochure-info .roof-btn:hover {';
      $inline_style .= ( $txt_hover_color ) ? 'color:'. $txt_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_bg_color ) {
      $inline_style .= '.brochure-'.$e_uniqid.' .brochure-info .roof-btn {';
      $inline_style .= ( $btn_bg_color ) ? 'background-color:'. $btn_bg_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_bg_hover_color ) {
      $inline_style .= '.brochure-'.$e_uniqid.' .brochure-info .roof-btn:hover {';
      $inline_style .= ( $btn_bg_hover_color ) ? 'background-color:'. $btn_bg_hover_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' brochure-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';
    $btn_link = $btn_link ? '<div class="brochure-info"><a href="'.$btn_link.'" '.$open_link.' class="roof-btn">'.$btn_txt.'</a></div>' : '<div class="brochure-info"><span class="roof-btn">'.$btn_txt.'</span></div>';
    $btn_txt = $btn_txt ? $btn_link : '';

    // Brochure Title
    $brochure_title_main = $brochure_title ? '<h3 class="info-title">'.$brochure_title.'</h3>' : '';

    // Service Icon
    $image_url = wp_get_attachment_url( $brochure_image );
    $brochure_image_main = $brochure_image ? '<img src="'.$image_url.'" alt="'.$brochure_title.'">' : '';

    $output = '';

    $output .= ''.$brochure_title_main.'<div class="brochure-wrap '.$class.''.$styled_class.'"><div class="roof-picture">'.$brochure_image_main.'</div>'.$btn_txt.'</div>';

    return $output;
  }
}
add_shortcode( 'roof_brochure', 'roof_brochure_function' );
