<?php
/**
 * Services - Shortcode Options
 */
add_action( 'init', 'roof_brochure_vc_map' );
if ( ! function_exists( 'roof_brochure_vc_map' ) ) {
  function roof_brochure_vc_map() {
    vc_map( array(
      "name"        => __( "Service Brochure", 'roof-core'),
      "base"        => "roof_brochure",
      "description" => __( "Service Brochure Shortcodes", 'roof-core'),
      "icon"        => "fa fa-cog color-brown",
      "category"    => RoofLib::roof_cat_name(),
      "params"      => array(

        RoofLib::vt_open_link_tab(),
        array(
          "type"               => 'textfield',
          "heading"            => __('Download Brochure Title', 'roof-core'),
          "param_name"         => "brochure_title",
          "value"              => "",
          'admin_label'        => true,
          "description"        => __( "Enter your download brochure title.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"               => 'attach_image',
          "heading"            => __('Upload Brochure Image', 'roof-core'),
          "param_name"         => "brochure_image",
          "value"              => "",
          "description"        => __( "Set your brochure image.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"               => 'textfield',
          "heading"            => __('Download Button Text', 'roof-core'),
          "param_name"         => "btn_txt",
          "value"              => "",
          "description"        => __( "Enter your download button text.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"              => 'href',
          "heading"           => __('Download Button Link', 'roof-core'),
          "param_name"        => "btn_link",
          "value"             => "",
          "description"       => __( "Enter your download button link.", 'roof-core'),
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),

        RoofLib::vt_class_option(),

        // Style
        array(
          "type"             => 'textfield',
          "heading"          => __('Download Text Size', 'roof-core'),
          "param_name"       => "txt_size",
          "value"            => "",
          "description"      => __( "Enter the numeric value for download text size in px.", 'roof-core'),
          "group"            => "Style",
          'edit_field_class' => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"             => 'colorpicker',
          "heading"          => __('Download Text Color', 'roof-core'),
          "param_name"       => "txt_color",
          "value"            => "",
          "description"      => __( "Pick your download text color.", 'roof-core'),
          "group"            => "Style",
          'edit_field_class' => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"             => 'colorpicker',
          "heading"          => __('Download Text Hover Color', 'roof-core'),
          "param_name"       => "txt_hover_color",
          "value"            => "",
          "description"      => __( "Pick your download text hover color.", 'roof-core'),
          "group"            => "Style",
          'edit_field_class' => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"             => 'colorpicker',
          "heading"          => __('Download Button Background Color', 'roof-core'),
          "param_name"       => "btn_bg_color",
          "value"            => "",
          "description"      => __( "Pick your download button background color.", 'roof-core'),
          "group"            => "Style",
          'edit_field_class' => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"             => 'colorpicker',
          "heading"          => __('Download Button Background Hover Color', 'roof-core'),
          "param_name"       => "btn_bg_hover_color",
          "value"            => "",
          "description"      => __( "Pick your download button background hover color.", 'roof-core'),
          "group"            => "Style",
          'edit_field_class' => 'vc_col-md-6 vc_column vt_field_space',
        ),

      )
    ) );
  }
}
