<?php
/**
 * Project Info - Shortcode Options
 */
add_action( 'init', 'project_info_vc_map' );
if ( ! function_exists( 'project_info_vc_map' ) ) {
  function project_info_vc_map() {
    vc_map( array(
    "name" => __( "Project Info", 'roof-core'),
    "base" => "roof_project_info",
    "description" => __( "Project Info Style", 'roof-core'),
    "icon" => "fa fa-question-circle color-black",
    "category" => RoofLib::roof_cat_name(),
    "params" => array(

      array(
        "type"        =>'textfield',
        "heading"     =>__('Title', 'roof-core'),
        "param_name"  => "project_info_title",
        "value"       => "",
        "description" => __( "Enter your title here.", 'roof-core'),
        'admin_label' => true,
      ),
      // List
      array(
        'type' => 'param_group',
        'value' => '',
        'heading' => __( 'List of Project Details', 'roof-core' ),
        'param_name' => 'list_details',
        // Note params is mapped inside param-group:
        'params' => array(
          array(
            'type' => 'textfield',
            'value' => '',
            'heading' => __( 'Title', 'roof-core' ),
            'param_name' => 'list_title',
            'admin_label' => true,
          ),
          array(
            'type' => 'textfield',
            'value' => '',
            'heading' => __( 'Text', 'roof-core' ),
            'param_name' => 'list_text',
            'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
            'admin_label' => true,
          ),
          array(
            'type' => 'textfield',
            'value' => '',
            'heading' => __( 'Link', 'roof-core' ),
            'param_name' => 'list_link',
            'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          ),

        )
      ),
      array(
        "type"        =>'textarea_html',
        "heading"     =>__('Content', 'roof-core'),
        "param_name"  => "content",
        "value"       => "",
      ),
      RoofLib::vt_class_option(),

      // Style
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Title Color', 'roof-core'),
        "param_name"  => "title_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('List Title Color', 'roof-core'),
        "param_name"  => "list_title_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('List Text Color', 'roof-core'),
        "param_name"  => "list_text_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Title Area BG Color', 'roof-core'),
        "param_name"  => "title_bg_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'colorpicker',
        "heading"     =>__('Border Color', 'roof-core'),
        "param_name"  => "border_color",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
      ),
      // Size
      array(
        "type"        => "notice",
        "heading"     => __( "Text Sizes", 'roof-core' ),
        "param_name"  => 'txt_sizes',
        'class'       => 'cs-warning',
        'value'       => '',
        "group"       => __('Style', 'roof-core'),
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('Title Size', 'roof-core'),
        "param_name"  => "title_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('List Title Size', 'roof-core'),
        "param_name"  => "list_title_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),
      array(
        "type"        =>'textfield',
        "heading"     =>__('List Text Size', 'roof-core'),
        "param_name"  => "list_text_size",
        "value"       => "",
        "group"       => __('Style', 'roof-core'),
        'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
      ),

      ), // Params
    ) );
  }
}
