<?php
/* ==========================================================
  Project Details
=========================================================== */
if ( !function_exists('roof_project_details_function')) {
  function roof_project_details_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'project_details_items'  => '',
      'upload_type'  => '',
      'class'  => '',
      // Style - Colors
      'icon_color'  => '',
      'title_color'  => '',
      'text_color'  => '',
      'text_hover_color'  => '',
      'bg_color'  => '',
      // Style - Size
      'icon_size'  => '',
      'image_width' => '',
      'title_size'  => '',
      'text_size'  => '',
    ), $atts));

    // Group Field
    $project_details_items = (array) vc_param_group_parse_atts( $project_details_items );
    $get_each_project_details = array();
    foreach ( $project_details_items as $project_item ) {
      $each_project_details = $project_item;
      $each_project_details['select_icon'] = isset( $project_item['select_icon'] ) ? $project_item['select_icon'] : '';
      $each_project_details['select_image'] = isset( $project_item['select_image'] ) ? $project_item['select_image'] : '';
      $each_project_details['project_details_title'] = isset( $project_item['project_details_title'] ) ? $project_item['project_details_title'] : '';
      $each_project_details['project_details_text'] = isset( $project_item['project_details_text'] ) ? $project_item['project_details_text'] : '';
      $each_project_details['project_details_text_link'] = isset( $project_item['project_details_text_link'] ) ? $project_item['project_details_text_link'] : '';
      $get_each_project_details[] = $each_project_details;
    }

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    // Icon Style
    if ( $icon_color || $icon_size ) {
      $inline_style .= '.roof-project-'. $e_uniqid .' .work-info-item .roof-icon .icons {';
      $inline_style .= ( $icon_color ) ? 'color:'. $icon_color .';' : '';
      $inline_style .= ( $icon_size ) ? 'font-size:'. roof_core_check_px($icon_size) .';' : '';
      $inline_style .= '}';
    }
    // Image Width
    if ( $image_width ) {
      $inline_style .= '.roof-project-'. $e_uniqid .' .work-info-item .roof-icon img {';
      $inline_style .= ( $image_width ) ? 'width:'. roof_core_check_px($image_width) .';' : '';
      $inline_style .= '}';
    }
    // Title Style
    if ( $title_color || $title_size ) {
      $inline_style .= '.roof-project-'. $e_uniqid .' .right-info .info-label {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_core_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    // Text Style
    if ( $text_color || $text_size ) {
      $inline_style .= '.roof-project-'. $e_uniqid .' .right-info .info-sub-label, .roof-project-'. $e_uniqid .' .right-info .info-sub-label a {';
      $inline_style .= ( $text_color ) ? 'color:'. $text_color .';' : '';
      $inline_style .= ( $text_size ) ? 'font-size:'. roof_core_check_px($text_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $text_hover_color ) {
      $inline_style .= '.roof-project-'. $e_uniqid .' .right-info .info-sub-label a:hover {';
      $inline_style .= ( $text_hover_color ) ? 'color:'. $text_hover_color .';' : '';
      $inline_style .= '}';
    }
    // Box Style
    if ( $bg_color ) {
      $inline_style .= '.roof-project-'. $e_uniqid .'.work-detail-wrap {';
      $inline_style .= ( $bg_color ) ? 'background-color:'. roof_core_check_px($bg_color) .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-project-'. $e_uniqid;

    // Starts
    $output = '<div class="work-detail-wrap '. $styled_class .' '. $class .'">';

    // Group Param Output
    foreach ( $get_each_project_details as $project_item ) {

      // Icon
     $image_url = wp_get_attachment_url( $project_item['select_image'] );

      if ($project_item['select_icon']){
        $project_icon = '<div class="roof-icon"><i class="icons '. $project_item['select_icon'] .'"></i></div>';
      } elseif ($project_item['select_image']){
        $project_icon = '<div class="roof-icon"><img src="'.$image_url.'" alt="'.$project_item['project_details_title'].'"></div>';
      } else {
        $project_icon ='';
      }
      // Title
      $project_title = ( $project_item['project_details_title'] ) ? '<h6 class="info-label">'. $project_item['project_details_title'] .'</h6>' : '';

      // Text
      $project_link = ( $project_item['project_details_text_link'] ) ? '<a href="'.$project_item['project_details_text_link'].'">'. $project_item['project_details_text'] .'</a>' : ''. $project_item['project_details_text'] .'';
      $project_text = ( $project_item['project_details_text'] ) ? '<h5 class="info-sub-label">'.$project_link.'</h5>' : '';

      $output .= '<div class="work-info-item">'. $project_icon .'<div class="right-info">'. $project_title . $project_text .'</div></div>';
    }

    $output .= '</div>';
    // End

    return $output;
  }
}
add_shortcode( 'roof_project_details', 'roof_project_details_function' );
