<?php
/**
 * Project Details - Shortcode Options
 */
add_action( 'init', 'roof_project_details_vc_map' );
if ( ! function_exists( 'roof_project_details_vc_map' ) ) {
  function roof_project_details_vc_map() {
    vc_map( array(
      "name" => __( "Project Details", 'roof-core'),
      "base" => "roof_project_details",
      "description" => __( "Project Details Styles", 'roof-core'),
      "icon" => "fa fa-info-circle color-pink",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        // Project Details
        array(
          'type' => 'param_group',
          'value' => '',
          'heading' => __( 'Project Details', 'roof-core' ),
          'param_name' => 'project_details_items',
          // Note params is mapped inside param-group:
          'params' => array(
            array(
              'type' => 'dropdown',
              'heading' => __( 'Upload Type', 'roof-core' ),
              'value' => array(
                __( 'Image', 'roof-core' ) => 'image',
                __( 'Icon', 'roof-core' ) => 'icon',
              ),
              'param_name' => 'upload_type',
              'description' => __( 'Select your upload type (image or icon).', 'roof-core' ),
            ),
            array(
              'type' => 'vt_icon',
              'value' => '',
              'heading' => __( 'Select Icon', 'roof-core' ),
              'param_name' => 'select_icon',
              'dependency' => array(
                'element' => 'upload_type',
                'value' => 'icon',
              ),
            ),
            array(
              'type' => 'attach_image',
              'value' => '',
              'heading' => __( 'Upload Image', 'roof-core' ),
              'param_name' => 'select_image',
              'dependency' => array(
                'element' => 'upload_type',
                'value' => 'image',
              ),
            ),
            array(
              'type' => 'textfield',
              'value' => '',
              'heading' => __( 'Title', 'roof-core' ),
              'param_name' => 'project_details_title',
              'admin_label' => true,
            ),
            array(
              'type' => 'textarea',
              'value' => '',
              'heading' => __( 'Text', 'roof-core' ),
              'param_name' => 'project_details_text',
            ),
            array(
              'type' => 'href',
              'value' => '',
              'heading' => __( 'Text', 'roof-core' ),
              'param_name' => 'project_details_text_link',
            ),

          )
        ),
        RoofLib::vt_class_option(),
        array(
          "type"        => "notice",
          "heading"     => __( "Colors", 'roof-core' ),
          "param_name"  => 'colors',
          'class'       => 'cs-warning',
          'value'       => '',
          'group' => __( 'Style', 'roof-core' ),
        ),
        // Style
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Icon Color', 'roof-core' ),
          'param_name' => 'icon_color',
          'group' => __( 'Style', 'roof-core' ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'description' => __( 'It apply only for icons', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Title Color', 'roof-core' ),
          'param_name' => 'title_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Text Color', 'roof-core' ),
          'param_name' => 'text_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Text Hover Color', 'roof-core' ),
          'param_name' => 'text_hover_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'colorpicker',
          'value' => '',
          'heading' => __( 'Background Color', 'roof-core' ),
          'param_name' => 'bg_color',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          "type"        => "notice",
          "heading"     => __( "Text Size", 'roof-core' ),
          "param_name"  => 'txt_size',
          'class'       => 'cs-warning',
          'value'       => '',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Icon Size', 'roof-core' ),
          'param_name' => 'icon_size',
          'group' => __( 'Style', 'roof-core' ),
          'description' => __( 'It apply only for icons', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Image Width', 'roof-core' ),
          'param_name' => 'image_width',
          'group' => __( 'Style', 'roof-core' ),
          'description' => __( 'It apply only for images', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Title Size', 'roof-core' ),
          'param_name' => 'title_size',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),
        array(
          'type' => 'textfield',
          'value' => '',
          'heading' => __( 'Text Size', 'roof-core' ),
          'param_name' => 'text_size',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'group' => __( 'Style', 'roof-core' ),
        ),

      )
    ) );
  }
}
