<?php
/**
 * Product - Shortcode Options
 */
add_action( 'init', 'roof_product_vc_map' );
if ( ! function_exists( 'roof_product_vc_map' ) ) {
  function roof_product_vc_map() {
    vc_map( array(
      "name" => __( "Products", 'roof-core'),
      "base" => "roof_product",
      "description" => __( "WooCommerce Products", 'roof-core'),
      "icon" => "fa fa-shopping-cart color-slate-blue",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Product Column', 'roof-core' ),
          'value' => array(
            __( 'Column Three', 'roof-core' ) => 3,
            __( 'Column Four', 'roof-core' ) => 4,
          ),
          'admin_label' => true,
          'param_name' => 'product_column',
          'description' => __( 'Select your product column.', 'roof-core' ),
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Limit', 'roof-core'),
          "param_name"  => "product_limit",
          "value"       => "",
          'admin_label' => true,
          "description" => __( "Enter the number of items to show.", 'roof-core'),
        ),

        array(
          "type"        =>'switcher',
          "heading"     =>__('Pagination', 'roof-core'),
          "param_name"  => "product_pagination",
          "value"       => "",
        ),

        array(
    			"type"        => "notice",
    			"heading"     => __( "Listing", 'roof-core' ),
    			"param_name"  => 'lsng_opt',
    			'class'       => 'cs-warning',
    			'value'       => '',
    		),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order', 'roof-core' ),
          'value' => array(
            __( 'Select Product Order', 'roof-core' ) => '',
            __('Asending', 'roof-core') => 'ASC',
            __('Desending', 'roof-core') => 'DESC',
          ),
          'param_name' => 'product_order',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order By', 'roof-core' ),
          'value' => array(
            __('None', 'roof-core') => 'none',
            __('ID', 'roof-core') => 'ID',
            __('Author', 'roof-core') => 'author',
            __('Title', 'roof-core') => 'title',
            __('Type', 'roof-core') => 'type',
            __('Date', 'roof-core') => 'date',
            __('Modified', 'roof-core') => 'modified',
            __('Random', 'roof-core') => 'rand',
          ),
          'param_name' => 'product_orderby',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Show only certain categories?', 'roof-core'),
          "param_name"  => "product_show_category",
          "value"       => "",
          "description" => __( "Enter category SLUGS (comma separated) you want to display.", 'roof-core')
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Miss-Aligned?', 'roof-core'),
          "param_name"  => "product_min_height",
          "value"       => "",
          "description" => __( "Set minimum height of all products in pixel value. Default : 100px", 'roof-core')
        ),
        RoofLib::vt_class_option(),

      )
    ) );
  }
}
