<?php
/* ===========================================================
    Pricing
=========================================================== */
if ( !function_exists('roof_pricing_function')) {
  function roof_pricing_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'plan_title'         => '',
      'plan_icon'     => '',
      'price'         => '',
      'price_in'      => '',
      'short_text'    => '',
      'btn_text'      => '',
      'btn_link'      => '',
      'class'         => '',
      'pricing_features' => '',
    ), $atts));

    // Group Field
    $pricing_features = (array) vc_param_group_parse_atts( $pricing_features );

    // Atts
    $uniqtab     = uniqid();
    $plan_icon  = $plan_icon ? '<i class="icons '.$plan_icon.'"></i>' : '';
    $plan_title = $plan_title ? '<h5 class="plan-title">'.$plan_title.'</h5>' : '';
    $price_in = $price_in ? $price_in : '$';
    $price = $price ? '<div class="plan-price">'.$price.'<sup>'.$price_in.'</sup></div>' : '';
    $short_text = $short_text ? '<h6 class="plan-sub-title">'.$short_text.'</h6>' : '';
    $btn_text = $btn_text ? $btn_text : 'Contact us';
    $btn_link = $btn_link ? '<a href="'.$btn_link.'" class="roof-btn roof-btn-black">'.$btn_text.'</a>' : '<span class="roof-btn roof-btn-black">'.$btn_text.'</span>';

    // Output
    $output = '<div class="plan-item"><div class="plan-type">'.$plan_icon.''.$plan_title.''.$short_text.'</div>'.$price.'<div class="plan-info"><ul>';

    // Foreach features
    $i = 1;
    foreach ( $pricing_features as $list_item ) {
      if(!isset($list_item['feature_avail'] )){
        $avail_class = 'fa-close';
      } else {
        $avail_class = 'fa-check';
      }
      $output .= '<li><i class="fa '.$avail_class.'" aria-hidden="true"></i> '.$list_item['title'].'</li>';
    }
    // Foreach features

    $output .= '</ul><div class="text-center">'.$btn_link.'</div></div></div>';

    return $output;

  }
}
add_shortcode( 'roof_pricing', 'roof_pricing_function' );
