<?php
/**
 * Pricing - Shortcode Options
 */
add_action( 'init', 'roof_pricing_vc_map' );
if ( ! function_exists( 'roof_pricing_vc_map' ) ) {
  function roof_pricing_vc_map() {
    vc_map( array(
      "name" => __( "Pricing", 'roof-core'),
      "base" => "roof_pricing",
      "description" => __( "Pricing Styles", 'roof-core'),
      "icon" => "fa fa-usd color-orange",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          "type" => "vt_icon",
          "heading" => __( "PLan Icon", 'roof-core' ),
          "param_name" => "plan_icon",
          'value' => '',
          "description" => __( "Include your pricing icon.", 'roof-core'),
        ),
        array(
          "type" => "textfield",
          "heading" => __( "PLan Name", 'roof-core' ),
          "param_name" => "plan_title",
          'value' => '',
          'admin_label' => true,
          "description" => __( "Enter your pricing title.", 'roof-core'),
        ),
        array(
          "type" => "textarea",
          "heading" => __( "Short Text", 'roof-core' ),
          "param_name" => "short_text",
          'value' => '',
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Price", 'roof-core' ),
          "param_name" => "price",
          'value' => '',
          'edit_field_class'  => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Price currency", 'roof-core' ),
          "param_name" => "price_in",
          'value' => '',
          'edit_field_class'  => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Button Text", 'roof-core' ),
          "param_name" => "btn_text",
          'value' => '',
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Button Link", 'roof-core' ),
          "param_name" => "btn_link",
          'value' => '',
          'edit_field_class'  => 'vc_col-md-6 vc_column vt_field_space',
        ),
        RoofLib::vt_class_option(),

        // List of features
        array(
          'type' => 'param_group',
          'value' => '',
          'param_name' => 'pricing_features',
          'params' => array(
            array(
              'type' => 'textfield',
              'value' => '',
              'heading' => __( 'Feature Title', 'roof-core' ),
              'param_name' => 'title',
              'admin_label' => true,
            ),
            array(
              'type' => 'switcher',
              'value' => '',
              'heading' => __( 'Feature Availability', 'roof-core' ),
              'param_name' => 'feature_avail',
              'admin_label' => true,
            ),

          )
        ),

      )
    ) );
  }
}
