<?php
/* ==========================================================
  Portfolio
=========================================================== */
if ( !function_exists('roof_portfolio_function')) {
  function roof_portfolio_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'portfolio_style'  => '',
      'portfolio_view'   => '',
      'portfolio_limit'  => '',
      'all_btn_txt'      => '',
      'all_btn_link'      => '',
      'portfolio_column'  => '',
      // Enable & Disable
      'portfolio_filter'  => '',
      'portfolio_pagination'  => '',
      'portfolio_no_space'  => '',
      'home_layout'         => '',
      'disable_size_limit'  => '',
      'img_click'           => '',
      // Listing
      'portfolio_order'  => '',
      'portfolio_orderby'  => '',
      'portfolio_show_category'  => '',
      'class'  => '',

      // Carousel
      'slick_loop'  => '',
      'slick_items'  => '',
      'slick_dots'  => '',
      'slick_nav'  => '',
      'slick_autoplay_timeout'  => '',
      'slick_autoplay'  => '',
      'slick_slides_scroll' => '',
      'slick_desktop'  => '',
      'slick_laptop'  => '',
      'slick_tablet'  => '',
      'slick_mobile'  => '',

      // Style - Filter
      'filter_txt_color'  => '',
      'filter_txt_hover_color'  => '',
      'filter_bg_color' => '',
      'filter_bg_hover_color' => '',
      'filter_active_color'  => '',
      'filter_line_color'  => '',
      'filter_txt_size'  => '',

      // carousel color
      'owl_dots_color' => '',
      'nav_arrow_color' => '',
      'owl_dots_active_color' => '',

      // Style - Colors And Sizes
      'image_overlay_color'  => '',
      'portfolio_title_size'  => '',
      'portfolio_title_color'  => '',
      'portfolio_title_hover_color'  => '',
      'btn_bg_color'  => '',
      'btn_bg_hover_color' => '',
      'btn_text_color'  => '',
      'btn_text_hover_color'  => '',
      'btn_text'  => '',
    ), $atts));

    // Shortcode Style CSS
    $e_uniqid        = uniqid();
    $inline_style  = '';

    // Image Overlay Color
    if ( $image_overlay_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .work-info {';
      $inline_style .= ( $image_overlay_color ) ? 'background-color:'. $image_overlay_color .';' : '';
      $inline_style .= '}';
    }

    // Carousel dots color
    if ( $owl_dots_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .slick-slider .slick-dots li button:before {';
      $inline_style .= ( $owl_dots_color ) ? 'color:'. $owl_dots_color .';' : '';
      $inline_style .= '}';
    }
    if ( $owl_dots_active_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .slick-slider .slick-dots li.slick-active button:before {';
      $inline_style .= ( $owl_dots_active_color ) ? 'color:'. $owl_dots_active_color .';' : '';
      $inline_style .= '}';
    }
    if ( $nav_arrow_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .slick-slider .slick-prev:before, .roof-portfolio-'. $e_uniqid .' .slick-slider .slick-next:before  {';
      $inline_style .= ( $nav_arrow_color ) ? 'color:'. $nav_arrow_color .';' : '';
      $inline_style .= '}';
    }

    // Title Color
    if ( $portfolio_title_size || $portfolio_title_color  || $portfolio_title_hover_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .work-info .work-title a {';
      $inline_style .= ( $portfolio_title_color ) ? 'color:'. $portfolio_title_color .';' : '';
      $inline_style .= ( $portfolio_title_size ) ? 'font-size:'. $portfolio_title_size .';' : '';
      $inline_style .= '}';
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .work-info .work-title a:hover {';
      $inline_style .= ( $portfolio_title_hover_color ) ? 'color:'. $portfolio_title_hover_color .';' : '';
      $inline_style .= '}';
    }
    // Button
    if ( $btn_bg_color || $btn_text_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .roof-btn {';
      $inline_style .= ( $btn_bg_color ) ? 'background-color:'. $btn_bg_color .';' : '';
      $inline_style .= ( $btn_text_color ) ? 'color:'. $btn_text_color .';' : '';
      $inline_style .= '}';
    }
    if ( $btn_bg_hover_color || $btn_text_hover_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .roof-btn {';
      $inline_style .= ( $btn_bg_hover_color ) ? 'background-color:'. $btn_bg_hover_color .';' : '';
      $inline_style .= ( $btn_text_hover_color ) ? 'color:'. $btn_text_hover_color .';' : '';
      $inline_style .= '}';
    }

    // Filter
    if ( $filter_txt_color || $filter_txt_size ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .filters-nav > li > a {';
      $inline_style .= ( $filter_txt_color ) ? 'color:'. $filter_txt_color .';' : '';
      $inline_style .= ( $filter_txt_size ) ? 'font-size:'. roof_core_check_px($filter_txt_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $filter_txt_hover_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .filters-nav > li:hover a, .roof-portfolio-'. $e_uniqid .' .filters-nav > li:active a {';
      $inline_style .= ( $filter_txt_hover_color ) ? 'color:'. $filter_txt_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $filter_bg_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .filters-nav {';
      $inline_style .= ( $filter_bg_color ) ? 'background:'. $filter_bg_color .';' : '';
      $inline_style .= '}';
    }
    if ( $filter_active_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .' .filters-nav > li > a.active {';
      $inline_style .= ( $filter_active_color ) ? 'background:'. $filter_active_color .';' : '';
      $inline_style .= '}';
    }
    if ( $filter_line_color ) {
      $inline_style .= '.roof-portfolio-'. $e_uniqid .'.bpw-filter li .btn-active:after {';
      $inline_style .= ( $filter_line_color ) ? 'background-color:'. $filter_line_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' roof-portfolio-'. $e_uniqid;

    // Items
    $slick_items = $slick_items ? 'data-items="'. $slick_items .'"' : '';
    $slick_desktop = $slick_desktop ? 'data-desktop="'. $slick_desktop .'"' : '';
    $slick_laptop = $slick_laptop ? 'data-laptop="'. $slick_laptop .'"' : '';
    $slick_tablet = $slick_tablet ? 'data-tablet="'. $slick_tablet .'"' : '';
    $slick_mobile = $slick_mobile ? 'data-mobile="'. $slick_mobile .'"' : '';

    // Slide Functions
    $slick_autoplay = $slick_autoplay ? 'data-autoplay="'. $slick_autoplay .'"' : '';
    $slick_autoplay_timeout = $slick_autoplay_timeout ? 'data-autoplay-time="'. $slick_autoplay_timeout .'"' : '';
    $slick_loop = $slick_loop ? 'data-loop="'. $slick_loop .'"' : '';
    $slick_slides_scroll = $slick_slides_scroll ? 'data-slides-scroll="' .$slick_slides_scroll .'"' : '';

    // Carousel Data's
    $slick_dots = $slick_dots ? 'data-dots="'. $slick_dots .'"' : '';
    $slick_nav = $slick_nav ? 'data-arrow="'. $slick_nav .'"' : '';

    // Style
    $portfolio_style_class = $portfolio_style === 'bpw-style-two' ? 'roof-masonry ' : 'slick-horizontal';
    if ($portfolio_style === 'bpw-style-two' || $portfolio_style === 'bpw-style-one') {
      $portfolio_column = '';
    } else {
      $portfolio_column = $portfolio_column ? $portfolio_column : 'bpw-col-3';
    }

    if($img_click) {
      $click_class = ' full-link';
    } else {
      $click_class = ' not-link';
    }

    // View Details Button
    if (roof_framework_active()) {
      $view_more_text = cs_get_option('view_more_text');
      if ($btn_text) {
        $btn_text = $btn_text;
      } elseif($view_more_text) {
        $btn_text = $view_more_text;
      } else {
        $btn_text = __('View Details', 'roof-core');
      }
    } else {
      $btn_text = $btn_text ? $btn_text : __('View Details', 'roof-core');
    }

    // Portfolio No Space
    $portfolio_no_space = $portfolio_no_space ? 'masonry-no-spacer ' : '';

    // Turn output buffer on
    ob_start();
      if($portfolio_style === 'bpw-style-three'){
        $port_style = ' works-style-three';
      } else {
        $port_style = '';
      }

    // Project Filter
    $allproject_text = cs_get_option('allproject_text');
    $allproject_text = $allproject_text ? $allproject_text : esc_html__( 'All Projects', 'roof-core' );

    ?>

    <section class="roof-works <?php echo esc_attr($styled_class. $port_style. $click_class); ?>">
    <?php
    // Portfolio Filter
    if ($portfolio_filter) {
      if ($portfolio_style === 'bpw-style-two') { ?>
      <ul class="nav navbar-nav filters-nav masonry-filters <?php echo esc_attr($styled_class); ?>">
      <li><a href="javascript:void(0);" data-filter="*" class="active"><?php echo $allproject_text; ?></a></li>
    <?php } elseif ($portfolio_style === 'bpw-style-three') { ?>
      <ul class="nav navbar-nav filters-nav masonry-filters <?php echo esc_attr($styled_class); ?>">
      <li><a href="javascript:void(0);" data-filter="*" class="active"><?php echo $allproject_text; ?></a></li>
    <?php } else { ?>
      <ul class="nav navbar-nav filters-nav slick-filter-nav <?php echo esc_attr($styled_class); ?>">
			<li><a href="javascript:void(0);" class="active" id="all"><?php echo $allproject_text; ?></a></li>
    <?php }

        if ($portfolio_show_category) {
          $cat_name = explode(',', $portfolio_show_category);
          $terms = $cat_name;
          $count = count($terms);
          if ($count > 0) {
            foreach ($terms as $term) {
              echo '<li class="cat-'. preg_replace('/\s+/', "", strtolower($term)) .'"><a href="javascript:void(0);" id="'.$term->slug .'" class="filter cat-'. preg_replace('/\s+/', "", strtolower($term)) .'" data-filter=".'. preg_replace('/\s+/', "", strtolower($term)) .'-item" title="' . str_replace('-', " ", strtolower($term)) . '">' . str_replace('-', " ", strtolower($term)) . '</a></li>';
             }
          }
        } else {
          $terms = get_terms('portfolio_category');
          $count = count($terms);
          $i=0;
          $term_list = '';
          if ($count > 0) {
            foreach ($terms as $term) {
              $i++;
              if ($portfolio_style === 'bpw-style-two' || $portfolio_style === 'bpw-style-three') {
                $term_list .= '<li><a href="javascript:void(0);" data-filter=".'. $term->slug .'-item">' . $term->name . '</a></li>';
              } else {
                $term_list .= '<li><a href="javascript:void(0);" id="'. $term->slug .'">' . $term->name . '</a></li>';
              }

              if ($count != $i) {
                $term_list .= '';
              } else {
                $term_list .= '';
              }
            }
            echo $term_list;
          }
        }
      ?>
		</ul>
    <?php
    }

    // Pagination
    global $paged;
    if( get_query_var( 'paged' ) )
      $my_page = get_query_var( 'paged' );
    else {
      if( get_query_var( 'page' ) )
        $my_page = get_query_var( 'page' );
      else
        $my_page = 1;
      set_query_var( 'paged', $my_page );
      $paged = $my_page;
    }

    $args = array(
      // other query params here,
      'paged' => $my_page,
      'post_type' => 'portfolio',
      'posts_per_page' => (int)$portfolio_limit,
      'portfolio_category' => esc_attr($portfolio_show_category),
      'orderby' => $portfolio_orderby,
      'order' => $portfolio_order
    );

    $roof_port = new WP_Query( $args );

    if($portfolio_style === 'bpw-style-two' ) {
        if ($portfolio_pagination) {
          $portfolio_msnr_class = '';
        } else {
          $portfolio_msnr_class = 'masonry-item-five ';
        }
    } else {
      $portfolio_msnr_class = '';
    }

    // Portfolio Start
    if($portfolio_style === 'bpw-style-three' ) { ?>
      <div class="roof-masonry masonry-fullwidth <?php echo esc_attr($portfolio_column); ?> <?php echo esc_attr($portfolio_no_space); ?> <?php echo esc_attr($class); ?>">
    <?php } else { ?>
    <div class="<?php echo esc_attr($portfolio_style_class); ?> <?php echo esc_attr($portfolio_msnr_class); ?> <?php echo esc_attr($portfolio_no_space); ?> <?php echo esc_attr($class); ?>" <?php echo $slick_loop .' '. $slick_slides_scroll .' '. $slick_items . ' '. $slick_laptop .' '. $slick_dots .' '. $slick_nav .' '. $slick_autoplay_timeout .' '. $slick_autoplay .' '.$slick_desktop.' '. $slick_tablet .' '. $slick_mobile; ?>>
    <?php }

      if ($roof_port->have_posts()) : while ($roof_port->have_posts()) : $roof_port->the_post();

        global $post;
        $roof_id    = ( isset( $post ) ) ? $post->ID : 0;
        $roof_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $roof_id;
        $roof_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $roof_id;
        $roof_meta  = get_post_meta( get_the_ID(), 'portfolio_type_metabox', true );

        if ($roof_meta) {
          $masonry_img_size  = $roof_meta['masonry_img_size'];
        } else {
          $masonry_img_size = '';
        }

        // Category
        $terms = wp_get_post_terms($post->ID,'portfolio_category');
        foreach ($terms as $term) {
          if ($portfolio_style === 'bpw-style-two'|| $portfolio_style === 'bpw-style-three') {
            $cat_class = $term->slug .'-item';
          } else {
            $cat_class = 'filter-' . $term->slug;
          }
        }
        $count = count($terms);
        $i=0;
        $cat_class = '';
        if ($count > 0) {
          foreach ($terms as $term) {
            $i++;
            if ($portfolio_style === 'bpw-style-two' || $portfolio_style === 'bpw-style-three') {
              $cat_class .= $term->slug.'-item ';
            } else {
              $cat_class .= 'filter-'. $term->slug .' ';
            }
            if ($count != $i) {
              $cat_class .= '';
            } else {
              $cat_class .= '';
            }
          }
        }

        // Featured Image
        $large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
        $large_image = isset($large_image[0]) ? $large_image[0] : '';

        if (!$disable_size_limit) {

          if ($portfolio_style === 'bpw-style-two') {
            if($portfolio_view === 'masonry'){

            if ($masonry_img_size === '2x-width'){
                  if(class_exists('Aq_Resize')) {
                    if ($home_layout) {
                    $portfolio_img = aq_resize( $large_image, '380', '297', true );
                    } else {
                      $portfolio_img = aq_resize( $large_image, '575', '300', true );
                    }
                  } else {
                    $portfolio_img = $large_image;
                  }
                $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
              } elseif ($masonry_img_size === '2x-width-height') {
                  if(class_exists('Aq_Resize')) {
                    if ($home_layout) {
                    $portfolio_img = aq_resize( $large_image, '761', '595', true );
                    } else {
                      $portfolio_img = aq_resize( $large_image, '575', '620', true );
                    }
                  } else {
                    $portfolio_img = $large_image;
                  }
                  $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
              } else {

                  if(class_exists('Aq_Resize')) {
                    if ($home_layout) {
                    $portfolio_img = aq_resize( $large_image, '380', '297', true );
                    } else {
                      $portfolio_img = aq_resize( $large_image, '278', '300', true );
                    }
                  } else {
                    $portfolio_img = $large_image;
                  }
                  $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
            }  } else {
                  if(class_exists('Aq_Resize')) {
                    $portfolio_img = aq_resize( $large_image, '370', '300', true );
                  } else {
                    $portfolio_img = $large_image;
                  }
                  $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
              }
          } elseif($portfolio_style === 'bpw-style-three') {

              if(class_exists('Aq_Resize')) {
                if($portfolio_column === 'bpw-col-3'){
                  $portfolio_img = aq_resize( $large_image, '601', '531', true );
                } elseif($portfolio_column === 'bpw-col-5'){
                  $portfolio_img = aq_resize( $large_image, '356', '259', true );
                } elseif($portfolio_column === 'bpw-col-2'){
                  $portfolio_img = $large_image;
                } else {
                  $portfolio_img = aq_resize( $large_image, '450', '327', true );
                }
              } else {
                $portfolio_img = $large_image;
              }
                $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';

          } else {

            if(class_exists('Aq_Resize')) {
              $portfolio_img = aq_resize( $large_image, '384', '350', true );
            } else {
              $portfolio_img = $large_image;
            }
              $featured_img = ( $portfolio_img ) ? $portfolio_img : ROOF_PLUGIN_ASTS . '/images/280x190.jpg';
          }
        } else {
          $featured_img = ( $large_image ) ? $large_image : '';
        }

        if ($portfolio_style === 'bpw-style-two') {
          if($portfolio_view ==='masonry'){

            if ($masonry_img_size === '2x-width') {
              if ($home_layout) {
                $msnr_class = '';
              } else {
                $msnr_class = 'one-half ';
              }
            } elseif ($masonry_img_size === '2x-width-height') {
              if ($home_layout) {
                $msnr_class = 'one-fourth ';
              } else {
                $msnr_class = 'one-half ';
              }
            } else {
              $msnr_class = '';
            }
          } else {
            $msnr_class = 'masonry-grid ';
          }
        } else {
          $msnr_class = '';
        }

        if ($portfolio_style === 'bpw-style-two') {
          if($home_layout){
            $img_wdth_class = '';
          } else {
            $img_wdth_class = 'msry-detail-page ';
          }
          global $post;
           ?>
          <div class="masonry-item <?php echo esc_attr($msnr_class); ?><?php echo esc_attr($img_wdth_class); ?><?php echo esc_attr($cat_class); ?>" data-category="<?php echo esc_attr($cat_class); ?>">
            <div class="work-list">
              <div class="roof-picture"> <img src="<?php echo $featured_img; ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></div>
              <div class="work-info">
                <div class="roof-table-container">
                  <div class="roof-align-container">
                    <h5 class="work-title"><a href="<?php esc_url(the_permalink()); ?>"><?php esc_attr(the_title()); ?></a></h5>
                    <div class="view-more"><a href="<?php esc_url(the_permalink()); ?>" class="roof-btn roof-btn-small"><?php echo esc_attr($btn_text); ?></a></div>
                  </div>
                </div>
              </div>
            </div>
          </div>

        <?php
        } elseif($portfolio_style === 'bpw-style-three' ) {
      ?>
      <div class="masonry-item <?php echo esc_attr($msnr_class); ?><?php echo esc_attr($cat_class); ?>" data-category="<?php echo esc_attr($cat_class); ?>">
        <div class="work-list">
          <div class="roof-picture"> <img src="<?php echo $featured_img; ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></div>
          <div class="work-info">
            <div class="roof-table-container">
              <div class="roof-align-container">
                <h5 class="work-title"><a href="<?php esc_url(the_permalink()); ?>"><?php esc_attr(the_title()); ?></a></h5>
                <h5 class="work-category">
                  <?php foreach ($terms as $term) {
                    $terms = wp_get_post_terms($post->ID,'portfolio_category');?>
                    <span><?php echo $term->slug; ?></span>
                  <?php } ?>
                </h5>
              </div>
            </div>
          </div>
        </div>
      </div>
      <?php } else { ?>

      <div class="item filter-all <?php echo esc_attr($cat_class); ?> <?php echo esc_attr($styled_class); ?>">
      <div class="work-list">
        <div class="roof-picture"><img src="<?php echo $featured_img; ?>" alt="<?php echo esc_attr(get_the_title()); ?>"></div>
        <div class="work-info">
          <div class="roof-table-container">
            <div class="roof-align-container">
              <h5 class="work-title"><?php esc_attr(the_title()); ?></h5>
              <div class="view-more"><a href="<?php esc_url(the_permalink()); ?>" class="roof-btn roof-btn-small"><?php echo esc_attr($btn_text); ?></a></div>
            </div>
          </div>
        </div>
      </div>
    </div>

    <?php
      }
    endwhile;
    endif;
    wp_reset_postdata(); ?>

    </div>
    <?php if($portfolio_style === 'bpw-style-two' || $portfolio_style === 'bpw-style-three' ) {
      $all_btn_link = $all_btn_link ? '<a href="'.$all_btn_link.'" class="roof-btn roof-btn-medium roof-btn-orange-border">'.$all_btn_txt.'</a>' :
      '<span class="roof-btn roof-btn-medium roof-btn-orange-border">'.$all_btn_txt.'</span>';
      $all_btn_txt = $all_btn_txt ? '<div class="all-project">'.$all_btn_link.'</div>' : '';
      echo $all_btn_txt;
    ?>
    <?php }  ?>
    </section>
    <!-- Portfolio End -->

    <?php
    if ($portfolio_pagination) {
      if ( function_exists('wp_pagenavi')) {
        wp_pagenavi(array( 'query' => $roof_port ) );
        wp_reset_postdata();  // avoid errors further down the page
      }
    }

    // Return outbut buffer
    return ob_get_clean();

  }
}
add_shortcode( 'roof_portfolio', 'roof_portfolio_function' );
