<?php
/**
 * Portfolio - Shortcode Options
 */
add_action( 'init', 'roof_portfolio_vc_map' );
if ( ! function_exists( 'roof_portfolio_vc_map' ) ) {
  function roof_portfolio_vc_map() {
    vc_map( array(
      "name" => __( "Portfolio", 'roof-core'),
      "base" => "roof_portfolio",
      "description" => __( "Portfolio Styles", 'roof-core'),
      "icon" => "fa fa-briefcase color-green",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        array(
          'type' => 'dropdown',
          'heading' => __( 'Portfolio Style', 'roof-core' ),
          'value' => array(
            __( 'Style One', 'roof-core' ) => 'bpw-style-one',
            __( 'Style Two', 'roof-core' ) => 'bpw-style-two',
            __( 'Style Three', 'roof-core' ) => 'bpw-style-three',
          ),
          'admin_label' => true,
          'param_name' => 'portfolio_style',
          'description' => __( 'Select your portfolio style.', 'roof-core' ),
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Grid or Masonry', 'roof-core' ),
          'value' => array(
            __( 'Grid', 'roof-core' ) => 'grid',
            __( 'Masonry', 'roof-core' ) => 'masonry',
          ),
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-two',
          ),
          'param_name' => 'portfolio_view',
          'description' => __( 'Select your portfolio style.', 'roof-core' ),
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Limit', 'roof-core'),
          "param_name"  => "portfolio_limit",
          "value"       => "",
          "description" => __( "Enter the number of items to show.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Button Text', 'roof-core'),
          "param_name"  => "btn_text",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => array('bpw-style-one','bpw-style-two'),
          ),
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('All Projects Button Text', 'roof-core'),
          "param_name"  => "all_btn_txt",
          "value"       => "",
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => array('bpw-style-two','bpw-style-three'),
          ),
          "description" => __( "Enter all projects button text.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('All Projects Button Link', 'roof-core'),
          "param_name"  => "all_btn_link",
          "value"       => "",
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => array('bpw-style-two','bpw-style-three'),
          ),
          "description" => __( "Enter all projects button link.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Columns', 'roof-core' ),
          'value' => array(
            __( 'Select Portfolio Columns', 'roof-core' ) => '',
            __( 'Column Two', 'roof-core' ) => 'bpw-col-2',
            __( 'Column Three', 'roof-core' ) => 'bpw-col-3',
            __( 'Column Four', 'roof-core' ) => 'bpw-col-4',
            __( 'Column Five', 'roof-core' ) => 'bpw-col-5',
          ),
          'admin_label' => true,
          'param_name' => 'portfolio_column',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-three',
          ),
          'description' => __( 'Select your portfolio column.', 'roof-core' ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),

        array(
    			"type"        => "notice",
    			"heading"     => __( "Enable & Disable", 'roof-core' ),
    			"param_name"  => 'ends_opt',
    			'class'       => 'cs-warning',
    			'value'       => '',
    		),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Filter', 'roof-core'),
          "param_name"  => "portfolio_filter",
          "value"       => "",
          "std"         => true,
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Pagination', 'roof-core'),
          "param_name"  => "portfolio_pagination",
          "value"       => "",
          "std"         => true,
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('No Space', 'roof-core'),
          "param_name"  => "portfolio_no_space",
          "value"       => "",
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-two',
          ),
          "std"         => false,
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Homepage layout', 'roof-core'),
          "param_name"  => "home_layout",
          "value"       => "",
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-two',
          ),
          "std"         => false,
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"        =>'switcher',
          "heading"     =>__('Full Image Clickable', 'roof-core'),
          "param_name"  => "img_click",
          "value"       => "",
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-three',
          ),
          "std"         => false,
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"        => 'switcher',
          "heading"     => __('Disable Featured Image Size Limit', 'roof-core'),
          "param_name"  => "disable_size_limit",
          "value"       => "",
          "std"         => false,
        ),

        array(
    			"type"        => "notice",
    			"heading"     => __( "Listing", 'roof-core' ),
    			"param_name"  => 'lsng_opt',
    			'class'       => 'cs-warning',
    			'value'       => '',
    		),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order', 'roof-core' ),
          'value' => array(
            __( 'Select Portfolio Order', 'roof-core' ) => '',
            __('Asending', 'roof-core') => 'ASC',
            __('Desending', 'roof-core') => 'DESC',
          ),
          'param_name' => 'portfolio_order',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          'type' => 'dropdown',
          'heading' => __( 'Order By', 'roof-core' ),
          'value' => array(
            __('None', 'roof-core') => 'none',
            __('ID', 'roof-core') => 'ID',
            __('Author', 'roof-core') => 'author',
            __('Title', 'roof-core') => 'title',
            __('Date', 'roof-core') => 'date',
            __('Menu Order', 'roof-core') => 'menu_order',
          ),
          'param_name' => 'portfolio_orderby',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Show only certain categories?', 'roof-core'),
          "param_name"  => "portfolio_show_category",
          "value"       => "",
          "description" => __( "Enter category SLUGS (comma separated) you want to display.", 'roof-core')
        ),
        RoofLib::vt_class_option(),

        // Carousel
        array(
          "type"        => "notice",
          "heading"     => __( "Basic Options", 'roof-core' ),
          "param_name"  => 'bsic_opt',
          'class'       => 'cs-warning',
          'value'       => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Carousel', 'roof-core'),
        ),
        array(
          "type" => "switcher",
          "heading" => __( "Disable Loop?", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_loop",
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          "value" => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "description" => __( "Continuously moving carousel, if enabled.", 'roof-core')
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Items", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_items",
          'value' => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "Enter the numeric value of how many items you want in per slide.", 'roof-core')
        ),
        array(
          "type" => "switcher",
          "heading" => __( "Dots", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_dots",
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          "value" => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "If you want Carousel Dots, enable it.", 'roof-core')
        ),
        array(
          "type" => "switcher",
          "heading" => __( "Navigation", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_nav",
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          "value" => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
          "description" => __( "If you want Carousel Navigation, enable it.", 'roof-core')
        ),

        array(
          "type"        => "notice",
          "heading"     => __( "Auto Play & Interaction", 'roof-core' ),
          "param_name"  => 'apyi_opt',
          'class'       => 'cs-warning',
          'value'       => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Carousel', 'roof-core'),
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Autoplay Timeout", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "Slick_autoplay_timeout",
          'value' => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "description" => __( "Change carousel Autoplay timing value. Default : 5000. Means 5 seconds.", 'roof-core')
        ),
        array(
          "type" => "switcher",
          "heading" => __( "Autoplay", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_autoplay",
          "on_text" => __( "Yes", 'roof-core' ),
          "off_text" => __( "No", 'roof-core' ),
          "value" => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
          "description" => __( "If you want to start Carousel automatically, enable it.", 'roof-core')
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Slides To Scrool", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_slides_scroll",
          "value" => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
          "description" => __( "Enter the number of slides to scroll.", 'roof-core')
        ),

        array(
          "type"        => "notice",
          "heading"     => __( "Responsive Options", 'roof-core' ),
          "param_name"  => 'res_opt',
          'class'       => 'cs-warning',
          'value'       => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Carousel', 'roof-core'),
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Desktop", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_desktop",
          'value' => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
          "description" => __( "Enter number of items to show in desktop screen(screen width:1600).", 'roof-core')
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Laptop", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_laptop",
          'value' => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
          "description" => __( "Enter number of items to show in laptop screen(screen width:1200).", 'roof-core')
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Tablet", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_tablet",
          'value' => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
          "description" => __( "Enter number of items to show in tablet(screen width:850).", 'roof-core')
        ),
        array(
          "type" => "textfield",
          "heading" => __( "Mobile", 'roof-core' ),
          "group" => __( "Carousel", 'roof-core' ),
          "param_name" => "slick_mobile",
          'value' => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
          "description" => __( "Enter number of items to show in mobile(screen width:520).", 'roof-core')
        ),

        // Stylings
        array(
    			"type"        => "notice",
    			"heading"     => __( "Filter", 'roof-core' ),
    			"param_name"  => 'flst_opt',
    			'class'       => 'cs-warning',
    			'value'       => '',
          "group"       => __('Style', 'roof-core'),
    		),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Text Color', 'roof-core'),
          "param_name"  => "filter_txt_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
          'dependency' => array(
            'element' => 'portfolio_filter',
            'value' => 'true',
          ),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Text Hover Color', 'roof-core'),
          "param_name"  => "filter_txt_hover_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
          'dependency' => array(
            'element' => 'portfolio_filter',
            'value' => 'true',
          ),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('BG Color', 'roof-core'),
          "param_name"  => "filter_bg_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
          'dependency' => array(
            'element' => 'portfolio_filter',
            'value' => 'true',
          ),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Active Color', 'roof-core'),
          "param_name"  => "filter_active_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
          'dependency' => array(
            'element' => 'portfolio_filter',
            'value' => 'true',
          ),
        ),

        array(
          "type"        => 'textfield',
          "heading"     => __('Text Size', 'roof-core'),
          "param_name"  => "filter_txt_size",
          "value"       => "",
          "group"       => __('Style', 'roof-core'),
          "description" => __( "Enter filter text size in px.", 'roof-core'),
          'dependency' => array(
            'element' => 'portfolio_filter',
            'value' => 'true',
          ),
        ),

        // Carousel
        array(
          "type"        => "notice",
          "heading"     => __( "Carousel colors", 'roof-core' ),
          "param_name"  => 'itm_opt',
          'class'       => 'cs-warning',
          'value'       => '',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Owl Dots Color', 'roof-core'),
          "param_name"  => "owl_dots_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Owl Dots Active Color', 'roof-core'),
          "param_name"  => "owl_dots_active_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Navigation Arrow Color', 'roof-core'),
          "param_name"  => "nav_arrow_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-one',
          ),
          "group"       => __('Style', 'roof-core'),
        ),

        // Size
        array(
    			"type"        => "notice",
    			"heading"     => __( "Item Style", 'roof-core' ),
    			"param_name"  => 'itm_opt',
    			'class'       => 'cs-warning',
    			'value'       => '',
          "group"       => __('Style', 'roof-core'),
    		),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Image Overlay Color', 'roof-core'),
          "param_name"  => "image_overlay_color",
          "value"       => "rgba(0,41,82,0.9)",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'textfield',
          "heading"     => __('Title Size', 'roof-core'),
          "param_name"  => "portfolio_title_size",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Title Color', 'roof-core'),
          "param_name"  => "portfolio_title_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Title Hover Color', 'roof-core'),
          "param_name"  => "portfolio_title_hover_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
          'dependency' => array(
            'element' => 'portfolio_style',
            'value' => 'bpw-style-two',
          ),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Button BG Color', 'roof-core'),
          "param_name"  => "btn_bg_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Button BG Hover Color', 'roof-core'),
          "param_name"  => "btn_bg_hover_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Button Text Color', 'roof-core'),
          "param_name"  => "btn_text_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),
        array(
          "type"        => 'colorpicker',
          "heading"     => __('Button Text Hover Color', 'roof-core'),
          "param_name"  => "btn_text_hover_color",
          "value"       => "",
          'edit_field_class'   => 'vc_col-md-4 vt_field_space',
          "group"       => __('Style', 'roof-core'),
        ),

      )
    ) );
  }
}
