<?php
/* ==========================================================
  Partner
=========================================================== */
if ( !function_exists('roof_partners_function')) {
  function roof_partners_function( $atts, $content = true ) {

    extract(shortcode_atts(array(
      'open_link'  => '',
      'partner_logo'  => '',
      'partner_logo_link'  => '',
      'partner_title'  => '',
      'partner_content' => '',
      'partner_website'  => '',
      'partner_website_link' => '',
      'class'  => '',

      // Style
      'partner_title_size' => '',
      'title_color' => '',
      'title_hover_color' => '',
      'partner_address_size' => '',
      'address_color' => '',
      'partner_content_size' => '',
      'content_color' => '',
      'partner_link_size' => '',
      'link_color' => '',
      'link_hover_color' => '',

    ), $atts));

    $content = wpb_js_remove_wpautop($content, true);
    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $title_color || $partner_title_size) {
      $inline_style .= '.partner-'.$e_uniqid.' .partner-info h5 a {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $partner_title_size ) ? 'font-size:'. roof_check_px($partner_title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $title_hover_color) {
      $inline_style .= '.partner-'.$e_uniqid.' .partner-info h5 a:hover {';
      $inline_style .= ( $title_hover_color ) ? 'color:'. $title_hover_color .';' : '';
      $inline_style .= '}';
    }
    if ( $address_color || $partner_address_size) {
      $inline_style .= '.partner-'.$e_uniqid.' .partner-info .partner-address p {';
      $inline_style .= ( $address_color ) ? 'color:'. $address_color .';' : '';
      $inline_style .= ( $partner_address_size ) ? 'font-size:'. roof_check_px($partner_address_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $content_color || $partner_content_size) {
      $inline_style .= '.partner-'.$e_uniqid.' .partner-info p {';
      $inline_style .= ( $content_color ) ? 'color:'. $content_color .';' : '';
      $inline_style .= ( $partner_content_size ) ? 'font-size:'. roof_check_px($partner_content_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $link_color || $partner_link_size) {
      $inline_style .= '.partner-'.$e_uniqid.' .partner-website a {';
      $inline_style .= ( $link_color ) ? 'color:'. $link_color .';' : '';
      $inline_style .= ( $partner_link_size ) ? 'font-size:'. roof_check_px($partner_link_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $link_hover_color) {
      $inline_style .= '.partner-'.$e_uniqid.' .partner-website a:hover {';
      $inline_style .= ( $link_hover_color ) ? 'color:'. $link_hover_color .';' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' partner-'. $e_uniqid;

    // Link Target
    $open_link = $open_link ? 'target="_blank"' : '';

    // Link and Title
    if ( function_exists( 'vc_parse_multi_attribute' ) ) {
      $parse_args = vc_parse_multi_attribute( $partner_title );
      $url        = ( isset( $parse_args['url'] ) ) ? $parse_args['url'] : '';
      $title      = ( isset( $parse_args['title'] ) ) ? $parse_args['title'] : '';
      $target     = ( isset( $parse_args['target'] ) ) ? trim( $parse_args['target'] ) : '_self';
    }
    if ($url) {
      $partner_title = '<h5 class="partner-title"><a href="'. $url .'" target="'. $target .'">'. $title .'</a></h5>';
    } else {
      $partner_title = '<h5 class="partner-title">'. $title .'</h5>';
    }

    // Partner Logo
    $image_url = wp_get_attachment_url( $partner_logo );
    if ($partner_logo_link) {
      $partner_logo = $partner_logo ? '<div class="roof-picture"><a href="'. $partner_logo_link .'" '. $open_link .'><img src="'. $image_url .'" alt="'. $title .'"></a></div>' : '';
    } else {
      $partner_logo = $partner_logo ? '<div class="roof-picture"><img src="'. $image_url .'" alt=""></div>' : '';
    }

    // Address
    $partner_address = $content ? '<address class="partner-address">'.$content.'</address>' : '';

    // Content
    $partner_content_actual = $partner_content ? '<p>'.$partner_content.'</p>' : '';

    // Website
    $partner_website_link = $partner_website_link ? '<div class="partner-website"><a href="'.$partner_website_link.'" '. $open_link .'>'.$partner_website.'</a></div>' : '<div class="partner-website">'.$partner_website.'</div>';
    $partner_website = $partner_website ? $partner_website_link : '<div class="partner-website">'.$partner_website_link.'</div>';

    // Output
    return '<div class="partners-wrap '.$styled_class.' '.$class.'"><div class="partner-item">'.$partner_logo.'<div class="partner-info">'.$partner_title.''.$partner_address.''.$partner_content_actual.''.$partner_website.'</div></div></div>';

  }
}
add_shortcode( 'roof_partners', 'roof_partners_function' );
