<?php
/**
 * Partners - Shortcode Options
 */
add_action( 'init', 'roof_partners_vc_map' );
if ( ! function_exists( 'roof_partners_vc_map' ) ) {
  function roof_partners_vc_map() {
    vc_map( array(
      "name" => __( "Partners", 'roof-core'),
      "base" => "roof_partners",
      "description" => __( "Our Partners", 'roof-core'),
      "icon" => "fa fa-user-plus color-orange",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

        RoofLib::vt_open_link_tab(),
        array(
          "type"        =>'attach_image',
          "heading"     =>__('Upload Partner Logo', 'roof-core'),
          "param_name"  => "partner_logo",
          "value"       => "",
          'admin_label' => true,
          "description" => __( "Upload your partner logo.", 'roof-core')
        ),
        array(
          "type"        =>'href',
          "heading"     =>__('Logo Link', 'roof-core'),
          "param_name"  => "partner_logo_link",
          "value"       => "",
          "description" => __( "Enter your partner logo link, if you want.", 'roof-core')
        ),
        array(
          "type"        =>'vc_link',
          "heading"     =>__('Title', 'roof-core'),
          "param_name"  => "partner_title",
          "value"       => "",
          "description" => __( "Enter your partner title and link, if you want.", 'roof-core')
        ),
        array(
          "type"        =>'textarea_html',
          "heading"     =>__('Address', 'roof-core'),
          "param_name"  => "content",
          "value"       => "",
          "description" => __( "Enter your partner profession.", 'roof-core')
        ),
        array(
          "type"        =>'textarea',
          "heading"     =>__('Content', 'roof-core'),
          "param_name"  => "partner_content",
          "value"       => "",
          "description" => __( "Enter your partner detailed information.", 'roof-core')
        ),
        array(
          "type"        =>'textfield',
          "heading"     =>__('Website Name', 'roof-core'),
          "param_name"  => "partner_website",
          "value"       => "",
          "description" => __( "Enter your partner website name.", 'roof-core')
        ),
        array(
          "type"        =>'href',
          "heading"     =>__('Website Link', 'roof-core'),
          "param_name"  => "partner_website_link",
          "value"       => "",
          "description" => __( "Enter your partner website link.", 'roof-core')
        ),
        RoofLib::vt_class_option(),

        // Styling
        array(
          "type"      => 'textfield',
          "heading"   => __('Partner Title Size', 'roof-core'),
          "param_name" => "partner_title_size",
          "value"      => "",
          "group"       => 'Style',
          "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Color', 'roof-core'),
          "param_name" => "title_color",
          "value"      => "",
          "description" => __( "Pick your heading color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Title Hover Color', 'roof-core'),
          "param_name" => "title_hover_color",
          "value"      => "",
          "description" => __( "Pick your heading hover color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Partner Address Size', 'roof-core'),
          "param_name" => "partner_address_size",
          "value"      => "",
          "group"       => 'Style',
          "description" => __( "Enter the numeric value for address size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Address Color', 'roof-core'),
          "param_name" => "address_color",
          "value"      => "",
          "description" => __( "Pick your address color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Partner Content Size', 'roof-core'),
          "param_name" => "partner_content_size",
          "value"      => "",
          "group"       => 'Style',
          "description" => __( "Enter the numeric value for content size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Content Color', 'roof-core'),
          "param_name" => "content_color",
          "value"      => "",
          "description" => __( "Pick your content color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
        ),
        array(
          "type"      => 'textfield',
          "heading"   => __('Partner Link Size', 'roof-core'),
          "param_name" => "partner_link_size",
          "value"      => "",
          "group"       => 'Style',
          "description" => __( "Enter the numeric value for link size in px.", 'roof-core'),
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Link Color', 'roof-core'),
          "param_name" => "link_color",
          "value"      => "",
          "description" => __( "Pick your link color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),
        array(
          "type"      => 'colorpicker',
          "heading"   => __('Link Hover Color', 'roof-core'),
          "param_name" => "link_hover_color",
          "value"      => "",
          "description" => __( "Pick your link hover color.", 'roof-core'),
          "group"       => 'Style',
          'edit_field_class'   => 'vc_col-md-4 vc_column vt_field_space',
        ),

      )
    ) );
  }
}
