<?php
/* ==========================================================
  Description Box
=========================================================== */
if ( !function_exists('roof_parallax_content_function')) {
  function roof_parallax_content_function( $atts, $content = NULL ) {

    extract(shortcode_atts(array(
      'parallax_title'  => '',
      'title_caption'  => '',
      'button_txt'  => '',
      'button_link'  => '',
      'parallax_content_align' => '',

      // Style
      'bg_color' => '',
      'bg_hover_color' => '',
      'title_color'  => '',
      'title_size'  => '',
      'caption_color'  => '',
      'caption_size'  => '',
      'btn_txt_color'  => '',
      'btn_txt_hover_color'  => '',
      'class'  => '',
    ), $atts));

    // Shortcode Style CSS
    $e_uniqid       = uniqid();
    $inline_style   = '';

    // Colors & Size
    if ( $title_color || $title_size) {
      $inline_style .= '.roof-main-wrap .roof-content-side .parallax-'.$e_uniqid.' h2.quote-title {';
      $inline_style .= ( $title_color ) ? 'color:'. $title_color .';' : '';
      $inline_style .= ( $title_size ) ? 'font-size:'. roof_check_px($title_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $caption_color || $caption_size) {
      $inline_style .= '.roof-main-wrap .roof-content-side .parallax-'.$e_uniqid.' h5.quote-sub-title {';
      $inline_style .= ( $caption_color ) ? 'color:'. $caption_color .';' : '';
      $inline_style .= ( $caption_size ) ? 'font-size:'. roof_check_px($caption_size) .';' : '';
      $inline_style .= '}';
    }
    if ( $bg_color || $btn_txt_color) {
      $inline_style .= '.parallax-'.$e_uniqid.' .roof-btn, .roof-main-wrap .roof-content-side .parallax-'.$e_uniqid.' .roof-btn {';
      $inline_style .= ( $bg_color ) ? 'background:'. $bg_color .';' : '';
      $inline_style .= ( $btn_txt_color ) ? 'color:'. $btn_txt_color .' !important;' : '';
      $inline_style .= '}';
    }
    if ( $bg_hover_color || $btn_txt_hover_color) {
      $inline_style .= '.parallax-'.$e_uniqid.' .roof-btn:hover, .parallax-'.$e_uniqid.' .roof-btn:focus, .roof-main-wrap .roof-content-side .parallax-'.$e_uniqid.' .roof-btn:hover, .roof-main-wrap .roof-content-side .parallax-'.$e_uniqid.' .roof-btn:focus {';
      $inline_style .= ( $bg_hover_color ) ? 'background:'. $bg_hover_color .';' : '';
      $inline_style .= ( $btn_txt_hover_color ) ? 'color:'. $btn_txt_hover_color .' !important;' : '';
      $inline_style .= '}';
    }

    // add inline style
    add_inline_style( $inline_style );
    $styled_class  = ' parallax-'. $e_uniqid;

    $parallax_title = $parallax_title ? '<h2 class="quote-title">'.$parallax_title.'</h2>' : '';
    $title_caption = $title_caption ? '<h5 class="quote-sub-title">'.$title_caption.'</h5>' : '';
    $button_link = $button_link ? '<a href="'.$button_link.'" class="roof-btn roof-btn-big">'.$button_txt.' <i class="fa fa-angle-right" aria-hidden="true"></i></a>' : '<span class="roof-btn roof-btn-big">'.$button_txt.' <i class="fa fa-angle-right" aria-hidden="true"></i></span>';
    $button_txt = $button_txt ? $button_link : '';

    if($parallax_content_align === 'right_align') {
      $align_class = 'pull-right';
    } else {
      $align_class = '';
    }

    $output = '';
    $output .= '<div class="col-md-6 container '.$styled_class.' '. $class .' '.$align_class.'">'.$title_caption.''.$parallax_title.''.$button_txt.'</div>';

    return $output;
  }
}
add_shortcode( 'roof_parallax_content', 'roof_parallax_content_function' );
