<?php
/**
 * Parallax Content - Shortcode Options
 */
add_action( 'init', 'roof_parallax_content_vc_map' );
if ( ! function_exists( 'roof_parallax_content_vc_map' ) ) {
  function roof_parallax_content_vc_map() {
    vc_map( array(
      "name" => __( "Parallax Content", 'roof-core'),
      "base" => "roof_parallax_content",
      "description" => __( "Parallax Content Shortcodes", 'roof-core'),
      "icon" => "fa fa-cog color-brown",
      "category" => RoofLib::roof_cat_name(),
      "params" => array(

          RoofLib::vt_class_option(),

                array(
                  "type"      => 'textfield',
                  "heading"   => __('Title', 'roof-core'),
                  "param_name" => "parallax_title",
                  "value"      => "",
                  "description" => __( "Enter your Parallax title.", 'roof-core'),
                ),
                array(
                  "type"      => 'textarea',
                  "heading"   => __('Title Caption', 'roof-core'),
                  "param_name" => "title_caption",
                  "value"      => "",
                  "description" => __( "Enter your Parallax title caption here.", 'roof-core'),
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Button Text', 'roof-core'),
                  "param_name" => "button_txt",
                  "value"      => "",
                  "description" => __( "Enter your button text here.", 'roof-core'),
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Button Link', 'roof-core'),
                  "param_name" => "button_link",
                  "value"      => "",
                  "description" => __( "Enter your button link here.", 'roof-core'),
                ),
                array(
                  'type' => 'dropdown',
                  'heading' => __( 'Content Align', 'roof-core' ),
                  'value' => array(
                    __( 'Left', 'roof-core' ) => 'left_align',
                    __( 'Right', 'roof-core' ) => 'right_align',
                  ),
                  'param_name' => 'parallax_content_align',
                  'description' => __( 'Select your parallax content Alignment.', 'roof-core' ),
                ),

                // Style
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Title Color', 'roof-core'),
                  "param_name" => "title_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your heading color.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Title Size', 'roof-core'),
                  "param_name" => "title_size",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Enter the numeric value for title size in px.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Title Caption Color', 'roof-core'),
                  "param_name" => "caption_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your title caption color.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'textfield',
                  "heading"   => __('Title Caption Size', 'roof-core'),
                  "param_name" => "caption_size",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Enter the numeric value for caption size in px.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Button Background Color', 'roof-core'),
                  "param_name" => "bg_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your background color for button.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Button Background Hover Color', 'roof-core'),
                  "param_name" => "bg_hover_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your background hover color for button.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Button Text Color', 'roof-core'),
                  "param_name" => "btn_txt_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your text color for button.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),
                array(
                  "type"      => 'colorpicker',
                  "heading"   => __('Button Text hover Color', 'roof-core'),
                  "param_name" => "btn_txt_hover_color",
                  "value"      => "",
                  "group"      => "Style",
                  "description" => __( "Pick your text hover color for button.", 'roof-core'),
                  'edit_field_class'   => 'vc_col-md-6 vc_column vt_field_space',
                ),

        )
      ) );

  }
}
